# (generated with --quick)

import _typeshed
import argparse
import dataclasses
import ray_cli.utils.formatters
from typing import Annotated, Any, Callable, Dict, Mapping, Optional, Sequence, Tuple, Type, TypeVar, Union, overload

ARGPARSE_META: Dict[str, bool]
CustomHelpFormatter: Type[ray_cli.utils.formatters.CustomHelpFormatter]

_T = TypeVar('_T')

@dataclasses.dataclass
class BaseCli:
    kwargs: Annotated[Dict[str, Any], 'property']
    def __init__(self) -> None: ...

@dataclasses.dataclass
class Cli(BaseCli):
    prog: str = ...
    description: str = ...
    add_help: bool = ...
    formatter_class: Optional[Type[argparse.HelpFormatter]] = ...
    options: Sequence[Union[Group, Option]] = ...
    command_groups: Sequence[CommandGroup] = ...
    def __init__(self, prog: str = ..., description: str = ..., add_help: bool = ..., formatter_class: Optional[Type[argparse.HelpFormatter]] = ..., options: Sequence[Union[Group, Option]] = ..., command_groups: Sequence[CommandGroup] = ...) -> None: ...
    def parse_args(self, args = ...) -> argparse.Namespace: ...

@dataclasses.dataclass
class Command(BaseCli):
    name: str = ...
    help: str = ...
    add_help: Optional[bool] = ...
    formatter_class: Optional[Type[argparse.HelpFormatter]] = ...
    options: Sequence[Union[Group, Option]] = ...
    callback: Optional[Callable] = ...
    def __init__(self, name: str = ..., help: str = ..., add_help: Optional[bool] = ..., formatter_class: Optional[Type[argparse.HelpFormatter]] = ..., options: Sequence[Union[Group, Option]] = ..., callback: Optional[Callable] = ...) -> None: ...
    def register(self, subparser: argparse._SubParsersAction) -> None: ...

@dataclasses.dataclass
class CommandGroup(BaseCli):
    dest: Optional[str] = ...
    required: Optional[bool] = ...
    metavar: Optional[str] = ...
    commands: Sequence[Command] = ...
    def __init__(self, dest: Optional[str] = ..., required: Optional[bool] = ..., metavar: Optional[str] = ..., commands: Sequence[Command] = ...) -> None: ...
    def register(self, parser: argparse.ArgumentParser) -> None: ...

@dataclasses.dataclass
class Group(BaseCli):
    name: Optional[str] = ...
    options: Sequence[Union[MutualExclusiveGroup, Option]] = ...
    def __init__(self, name: Optional[str] = ..., options: Sequence[Union[MutualExclusiveGroup, Option]] = ...) -> None: ...
    def register(self, parser: argparse.ArgumentParser) -> None: ...

@dataclasses.dataclass
class MutualExclusiveGroup(BaseCli):
    name: Optional[str] = ...
    options: Sequence[Option] = ...
    required: bool = ...
    def __init__(self, name: Optional[str] = ..., options: Sequence[Option] = ..., required: bool = ...) -> None: ...
    def register(self, parser: argparse.ArgumentParser) -> None: ...

@dataclasses.dataclass
class Option(BaseCli):
    name_or_flags: Sequence[str]
    default: Any = ...
    type: Any = ...
    choices: Optional[Sequence[str]] = ...
    action: Any = ...
    nargs: Any = ...
    metavar: Optional[str] = ...
    dest: Optional[str] = ...
    required: Optional[bool] = ...
    const: Any = ...
    version: Any = ...
    help: str = ...
    bounds: Optional[Tuple[Any, Any]] = ...
    def __init__(self, name_or_flags: Sequence[str], default = ..., type = ..., choices: Optional[Sequence[str]] = ..., action = ..., nargs = ..., metavar: Optional[str] = ..., dest: Optional[str] = ..., required: Optional[bool] = ..., const = ..., version = ..., help: str = ..., bounds: Optional[Tuple[Any, Any]] = ...) -> None: ...
    def _generate_help(self) -> str: ...
    def register(self, parser: Union[argparse.ArgumentParser, argparse._ArgumentGroup]) -> None: ...

def arg_field(*, default = ...) -> Any: ...
def bounded(converter: Callable[[str], Any], *, lower: Optional[float] = ..., upper: Optional[float] = ..., label: Optional[str] = ...) -> Callable[[str], Any]: ...
@overload
def dataclass(__cls: None) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def dataclass(__cls: Type[_T]) -> Type[_T]: ...
@overload
def dataclass(*, init: bool = ..., repr: bool = ..., eq: bool = ..., order: bool = ..., unsafe_hash: bool = ..., frozen: bool = ..., match_args: bool = ..., kw_only: bool = ..., slots: bool = ..., weakref_slot: bool = ...) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def field(*, default: _T, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, default_factory: Callable[[], _T], init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> Any: ...
def fields(class_or_instance: Union[_typeshed.DataclassInstance, Type[_typeshed.DataclassInstance]]) -> Tuple[dataclasses.Field, ...]: ...
