# (generated with --quick)

import dataclasses
from typing import Any, Callable, Mapping, Optional, Sequence, Type, TypeVar, overload

ACN_PID: bytes
ACN_POSTAMBLE_SIZE: int
ACN_PREAMBLE_SIZE: int
VECTOR_DMP_SET_PROPERTY: int
VECTOR_E131_DATA_PACKET: int
VECTOR_ROOT_E131_DATA: int

_T = TypeVar('_T')

@dataclasses.dataclass
class DMPLayer:
    start_code: int = ...
    dmx_data: bytes = ...
    address_type: int = ...
    first_property_address: int = ...
    address_increment: int = ...
    def __bytes__(self) -> bytes: ...
    def __init__(self, start_code: int = ..., dmx_data: bytes = ..., address_type: int = ..., first_property_address: int = ..., address_increment: int = ...) -> None: ...

@dataclasses.dataclass
class DataPacket:
    cid: bytes
    source_name: str = ...
    universe: int = ...
    sequence: int = ...
    priority: int = ...
    dmx_data: Sequence[int] = ...
    def __bytes__(self) -> bytes: ...
    def __init__(self, cid: bytes, source_name: str = ..., universe: int = ..., sequence: int = ..., priority: int = ..., dmx_data: Sequence[int] = ...) -> None: ...

@dataclasses.dataclass
class FramingLayer:
    source_name: str
    universe: int
    sequence_number: int = ...
    priority: int = ...
    sync_address: int = ...
    options: int = ...
    dmp_layer: DMPLayer = ...
    def __bytes__(self) -> bytes: ...
    def __init__(self, source_name: str, universe: int, sequence_number: int = ..., priority: int = ..., sync_address: int = ..., options: int = ..., dmp_layer: DMPLayer = ...) -> None: ...

@dataclasses.dataclass
class RootLayer:
    cid: bytes
    vector: int
    child_pdu: bytes
    def __bytes__(self) -> bytes: ...
    def __init__(self, cid: bytes, vector: int, child_pdu: bytes) -> None: ...

@overload
def dataclass(__cls: None) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def dataclass(__cls: Type[_T]) -> Type[_T]: ...
@overload
def dataclass(*, init: bool = ..., repr: bool = ..., eq: bool = ..., order: bool = ..., unsafe_hash: bool = ..., frozen: bool = ..., match_args: bool = ..., kw_only: bool = ..., slots: bool = ..., weakref_slot: bool = ...) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def field(*, default: _T, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, default_factory: Callable[[], _T], init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> Any: ...
