# (generated with --quick)

import abc
import ray_cli.protocols.sacn.packets
from typing import Callable, Sequence, Type, TypeVar

ABC: Type[abc.ABC]
DataPacket: Type[ray_cli.protocols.sacn.packets.DataPacket]

_FuncT = TypeVar('_FuncT', bound=Callable)

class Encoder(abc.ABC):
    @abstractmethod
    def build_frame(self, universe: int, priority: int, sequence: int, dmx_data: Sequence[int]) -> bytes: ...

class SACNEncoder(Encoder):
    cid: bytes
    source_name: str
    def __init__(self, cid: bytes, source_name: str) -> None: ...
    def build_frame(self, universe: int, priority: int, sequence: int, dmx_data: Sequence[int]) -> bytes: ...

def abstractmethod(funcobj: _FuncT) -> _FuncT: ...
