# (generated with --quick)

import abc
import itertools
import math
from typing import Callable, Iterator, Sequence, Type, TypeVar

DmxData = Sequence[int]

ABC: Type[abc.ABC]

_FuncT = TypeVar('_FuncT', bound=Callable)
_TBaseGenerator = TypeVar('_TBaseGenerator', bound=BaseGenerator)

class BaseGenerator(abc.ABC):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    def __init__(self, channels: int, fps: int, frequency: float, intensity_upper: int, intensity_lower: int = ...) -> None: ...
    def __iter__(self: _TBaseGenerator) -> _TBaseGenerator: ...
    def __next__(self) -> Sequence[int]: ...
    @classmethod
    @abstractmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    @abstractmethod
    def next(self) -> Sequence[int]: ...

class ChaseModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class RampDownModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class RampModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class RampUpModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class SineModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class SquareModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

class StaticModeDmxDataGenerator(BaseGenerator):
    channels: int
    fps: int
    frequency: float
    generator: Iterator
    intensity_lower: int
    intensity_upper: int
    @classmethod
    def create(cls, channels: int, fps: int, frequency: float, intensity_lower: int, intensity_upper: int) -> Iterator: ...
    def next(self) -> Sequence[int]: ...

def abstractmethod(funcobj: _FuncT) -> _FuncT: ...
def linspace(start: float, stop: float, num: int) -> Iterator[float]: ...
