# (generated with --quick)

import abc
import ipaddress
import ray_cli.core.socket
from typing import Callable, Generic, Hashable, Optional, Sequence, Type, TypeVar

FrameEncoder = Callable[[int, Sequence[int]], bytes]

ABC: Type[abc.ABC]
BaseUDPSocket: Type[ray_cli.core.socket.BaseUDPSocket]

U = TypeVar('U', bound=Hashable)
_FuncT = TypeVar('_FuncT', bound=Callable)

class ProtocolFactory(abc.ABC, Generic[U]):
    @abstractmethod
    def create_frame_encoder(self, universe) -> Callable[[int, Sequence[int]], bytes]: ...
    @abstractmethod
    def create_socket(self, universe: U, src: ipaddress.IPv4Address, dst: Optional[ipaddress.IPv4Address]) -> ray_cli.core.socket.BaseUDPSocket: ...

def abstractmethod(funcobj: _FuncT) -> _FuncT: ...
