# (generated with --quick)

import abc
import dataclasses
import ipaddress
import itertools
import ray_cli.core.socket
import ray_cli.core.types
from typing import Any, Callable, Dict, Generic, Hashable, Mapping, Optional, Sequence, Type, TypeVar, overload

FrameEncoder = Callable[[int, Sequence[int]], bytes]

ABC: Type[abc.ABC]
BaseUDPSocket: Type[ray_cli.core.socket.BaseUDPSocket]
ProtocolFactory: Type[ray_cli.core.types.ProtocolFactory]

U = TypeVar('U', bound=Hashable)
_FuncT = TypeVar('_FuncT', bound=Callable)
_T = TypeVar('_T')
_TBaseSender = TypeVar('_TBaseSender', bound=BaseSender)

class BaseSender(abc.ABC):
    def __enter__(self: _TBaseSender) -> _TBaseSender: ...
    @overload
    def __exit__(self, exc_type: Type[BaseException], exc: BaseException, tb) -> None: ...
    @overload
    def __exit__(self, exc_type: None, exc: BaseException, tb) -> None: ...
    @overload
    def __exit__(self, exc_type: Type[BaseException], exc: None, tb) -> None: ...
    @overload
    def __exit__(self, exc_type: None, exc: None, tb) -> None: ...
    @overload
    def __exit__(self, exc_type: Type[BaseException], exc: BaseException, tb: None) -> None: ...
    @overload
    def __exit__(self, exc_type: None, exc: BaseException, tb: None) -> None: ...
    @overload
    def __exit__(self, exc_type: Type[BaseException], exc: None, tb: None) -> None: ...
    @overload
    def __exit__(self, exc_type: None, exc: None, tb: None) -> None: ...
    @abstractmethod
    def close(self) -> None: ...
    @abstractmethod
    def open(self) -> None: ...
    @abstractmethod
    def send(self, dmx_data: Sequence[int]) -> None: ...

class Sender(BaseSender, Generic[U]):
    _universes: Dict[U, Universe]
    def __init__(self, universes: Sequence[U], factory: ray_cli.core.types.ProtocolFactory, *, src: ipaddress.IPv4Address = ..., dst: Optional[ipaddress.IPv4Address] = ...) -> None:
        self = Sender[U]
    def close(self) -> None: ...
    def open(self) -> None: ...
    def send(self, dmx_data: Sequence[int]) -> None: ...

@dataclasses.dataclass
class Universe:
    socket: ray_cli.core.socket.BaseUDPSocket
    encode: Callable[[int, Sequence[int]], bytes]
    seq_iter: itertools.cycle = ...
    def __init__(self, socket: ray_cli.core.socket.BaseUDPSocket, encode: Callable[[int, Sequence[int]], bytes], seq_iter: itertools.cycle = ...) -> None: ...

def abstractmethod(funcobj: _FuncT) -> _FuncT: ...
@overload
def dataclass(__cls: None) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def dataclass(__cls: Type[_T]) -> Type[_T]: ...
@overload
def dataclass(*, init: bool = ..., repr: bool = ..., eq: bool = ..., order: bool = ..., unsafe_hash: bool = ..., frozen: bool = ..., match_args: bool = ..., kw_only: bool = ..., slots: bool = ..., weakref_slot: bool = ...) -> Callable[[Type[_T]], Type[_T]]: ...
@overload
def field(*, default: _T, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, default_factory: Callable[[], _T], init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> _T: ...
@overload
def field(*, init: bool = ..., repr: bool = ..., hash: Optional[bool] = ..., compare: bool = ..., metadata: Optional[Mapping] = ..., kw_only: bool = ...) -> Any: ...
