"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubWave = exports.StackCapabilities = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const pipelines_1 = require("aws-cdk-lib/pipelines");
/**
 * Enumeration for IAM capabilities that must be acknowledged in AWS CloudFormation templates.
 *
 * These capabilities are required for stacks that include IAM resources or specific features.
 *
 * @see [AWS CloudFormation IAM Capabilities Documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
 */
var StackCapabilities;
(function (StackCapabilities) {
    /** Acknowledge that the stack includes IAM resources. */
    StackCapabilities["IAM"] = "CAPABILITY_IAM";
    /** Acknowledge that the stack includes custom names for IAM resources. */
    StackCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /** Acknowledge that the stack contains one or more macros. */
    StackCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(StackCapabilities || (exports.StackCapabilities = StackCapabilities = {}));
/**
 * Represents a wave in the GitHub Actions pipeline.
 *
 * This class provides a wrapper around the Wave class from the AWS CDK pipelines module,
 * enabling additional functionality for managing stages with specific options and configurations.
 */
class GitHubWave {
    id;
    waveStageAdder;
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.GitHubWave", version: "0.0.21" };
    innerWave;
    /**
     * Constructs a new instance of GitHubWave.
     *
     * @param id - Unique identifier for the wave.
     * @param waveStageAdder - An instance of IWaveStageAdder to manage the addition of stages.
     * @param props - Optional properties to configure the wave.
     */
    constructor(id, waveStageAdder, props = {}) {
        this.id = id;
        this.waveStageAdder = waveStageAdder;
        this.innerWave = new pipelines_1.Wave(id, props);
    }
    /**
     * Adds a stage to the wave with specified options.
     *
     * This method creates a deployment for the provided stage and integrates it
     * into the wave, managing pre- and post-jobs as configured.
     *
     * @param stage - The stage to be added to the wave.
     * @param options - Optional configuration for the stage.
     * @returns The deployment information for the added stage.
     */
    addStage(stage, options = {}) {
        const stageDeployment = this.innerWave.addStage(stage, {
            pre: options.preJobs,
            post: options.postJobs,
        });
        this.waveStageAdder.addStageFromWave(stageDeployment, options);
        return stageDeployment;
    }
    /**
     * Internal method to access the wrapped Wave instance.
     *
     * This is intended for use within the implementation and should not be called
     * from outside the class.
     *
     * @internal
     */
    get _innerWave() {
        return this.innerWave;
    }
}
exports.GitHubWave = GitHubWave;
//# sourceMappingURL=data:application/json;base64,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