"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StageJob = exports.Synth = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const pipelines_1 = require("aws-cdk-lib/pipelines");
/**
 * Represents a Synth step in a GitHub Actions pipeline.
 *
 * This step is responsible for synthesizing the AWS CloudFormation templates
 * from the CDK application. It extends the ShellStep to execute shell commands
 * defined in the properties.
 */
class Synth extends pipelines_1.ShellStep {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.Synth", version: "0.0.21" };
    /**
     * Constructs a new instance of the Synth step.
     *
     * @param props - Configuration properties for the synth step.
     */
    constructor(props) {
        super("synth", {
            env: props.env,
            installCommands: props.installCommands,
            commands: props.commands,
        });
    }
}
exports.Synth = Synth;
/**
 * Represents a job in a stage of the GitHub Actions pipeline.
 *
 * This class extends the Step class, providing functionality for executing a job
 * with specified options and configurations.
 */
class StageJob extends pipelines_1.Step {
    id;
    props;
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.StageJob", version: "0.0.21" };
    /**
     * Constructs a new instance of StageJob.
     *
     * @param id - Unique identifier for the job step.
     * @param props - Configuration options for the job.
     */
    constructor(id, props) {
        super(id);
        this.id = id;
        this.props = props;
    }
}
exports.StageJob = StageJob;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RlcHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvc3RlcHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLHFEQUF3RDtBQThCeEQ7Ozs7OztHQU1HO0FBQ0gsTUFBYSxLQUFNLFNBQVEscUJBQVM7O0lBQ2xDOzs7O09BSUc7SUFDSCxZQUFZLEtBQWlCO1FBQzNCLEtBQUssQ0FBQyxPQUFPLEVBQUU7WUFDYixHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1NBQ3pCLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBWkgsc0JBYUM7QUFtQ0Q7Ozs7O0dBS0c7QUFDSCxNQUFhLFFBQVMsU0FBUSxnQkFBSTtJQVFkO0lBQ1Q7O0lBUlQ7Ozs7O09BS0c7SUFDSCxZQUNrQixFQUFVLEVBQ25CLEtBQXVCO1FBRTlCLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUhNLE9BQUUsR0FBRixFQUFFLENBQVE7UUFDbkIsVUFBSyxHQUFMLEtBQUssQ0FBa0I7SUFHaEMsQ0FBQzs7QUFaSCw0QkFhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFNoZWxsU3RlcCwgU3RlcCB9IGZyb20gXCJhd3MtY2RrLWxpYi9waXBlbGluZXNcIjtcbmltcG9ydCB0eXBlIHsgSm9iUHJvcHMgfSBmcm9tIFwiZ2l0aHViLWFjdGlvbnMtY2RrXCI7XG5pbXBvcnQgdHlwZSB7IElKb2JQaGFzZSB9IGZyb20gXCIuL2pvYnNcIjtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBjb25maWd1cmluZyBhIFN5bnRoIHN0ZXAgaW4gdGhlIEdpdEh1YiBBY3Rpb25zIHBpcGVsaW5lLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN5bnRoUHJvcHMge1xuICAvKipcbiAgICogT3B0aW9uYWwgZW52aXJvbm1lbnQgdmFyaWFibGVzIHRvIHNldCBkdXJpbmcgdGhlIHN0ZXAgZXhlY3V0aW9uLlxuICAgKlxuICAgKiBUaGVzZSB2YXJpYWJsZXMgY2FuIGJlIHVzZWQgdG8gY29uZmlndXJlIHRoZSBiZWhhdmlvciBvZiB0aGUgY29tbWFuZHMgcnVuIGluIHRoZSBzeW50aCBzdGVwLlxuICAgKi9cbiAgcmVhZG9ubHkgZW52PzogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcblxuICAvKipcbiAgICogT3B0aW9uYWwgbGlzdCBvZiBjb21tYW5kcyB0byBydW4gZm9yIGluc3RhbGxpbmcgZGVwZW5kZW5jaWVzIGJlZm9yZSBleGVjdXRpbmcgdGhlIG1haW4gY29tbWFuZHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gaW5zdGFsbCBjb21tYW5kcyB3aWxsIGJlIGV4ZWN1dGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFsbENvbW1hbmRzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIFRoZSBtYWluIGNvbW1hbmRzIHRvIGV4ZWN1dGUgZm9yIHRoZSBzeW50aCBzdGVwLlxuICAgKlxuICAgKiBUaGVzZSBjb21tYW5kcyB0eXBpY2FsbHkgaW5jbHVkZSBidWlsZCBvciBzeW50aGVzaXMgY29tbWFuZHMgZm9yIHRoZSBDREsgYXBwbGljYXRpb24uXG4gICAqL1xuICByZWFkb25seSBjb21tYW5kczogc3RyaW5nW107XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIFN5bnRoIHN0ZXAgaW4gYSBHaXRIdWIgQWN0aW9ucyBwaXBlbGluZS5cbiAqXG4gKiBUaGlzIHN0ZXAgaXMgcmVzcG9uc2libGUgZm9yIHN5bnRoZXNpemluZyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlc1xuICogZnJvbSB0aGUgQ0RLIGFwcGxpY2F0aW9uLiBJdCBleHRlbmRzIHRoZSBTaGVsbFN0ZXAgdG8gZXhlY3V0ZSBzaGVsbCBjb21tYW5kc1xuICogZGVmaW5lZCBpbiB0aGUgcHJvcGVydGllcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFN5bnRoIGV4dGVuZHMgU2hlbGxTdGVwIHtcbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIFN5bnRoIHN0ZXAuXG4gICAqXG4gICAqIEBwYXJhbSBwcm9wcyAtIENvbmZpZ3VyYXRpb24gcHJvcGVydGllcyBmb3IgdGhlIHN5bnRoIHN0ZXAuXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcm9wczogU3ludGhQcm9wcykge1xuICAgIHN1cGVyKFwic3ludGhcIiwge1xuICAgICAgZW52OiBwcm9wcy5lbnYsXG4gICAgICBpbnN0YWxsQ29tbWFuZHM6IHByb3BzLmluc3RhbGxDb21tYW5kcyxcbiAgICAgIGNvbW1hbmRzOiBwcm9wcy5jb21tYW5kcyxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGNvbmZpZ3VyaW5nIGEgam9iIGluIGEgc3RhZ2Ugb2YgdGhlIEdpdEh1YiBBY3Rpb25zIHBpcGVsaW5lLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElTdGFnZUpvYk9wdGlvbnMgZXh0ZW5kcyBJSm9iUGhhc2Uge1xuICAvKipcbiAgICogT3B0aW9uYWwgbmFtZSBmb3IgdGhlIGpvYi5cbiAgICpcbiAgICogSWYgbm90IHNwZWNpZmllZCwgYSBkZWZhdWx0IG5hbWUgd2lsbCBiZSBnZW5lcmF0ZWQuXG4gICAqL1xuICByZWFkb25seSBuYW1lPzogSm9iUHJvcHNbXCJuYW1lXCJdO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBlbnZpcm9ubWVudCB2YXJpYWJsZXMgZm9yIHRoZSBqb2IuXG4gICAqXG4gICAqIFRoZXNlIHZhcmlhYmxlcyB3aWxsIGJlIHNldCBpbiB0aGUgam9iJ3MgZXhlY3V0aW9uIGVudmlyb25tZW50LlxuICAgKi9cbiAgcmVhZG9ubHkgZW52PzogSm9iUHJvcHNbXCJlbnZcIl07XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIHBlcm1pc3Npb25zIGZvciB0aGUgam9iLlxuICAgKlxuICAgKiBUaGVzZSBwZXJtaXNzaW9ucyBjb250cm9sIHRoZSBhY3Rpb25zIHRoYXQgdGhlIGpvYiBjYW4gcGVyZm9ybSBpbiB0aGUgR2l0SHViIEFjdGlvbnMgZW52aXJvbm1lbnQuXG4gICAqL1xuICByZWFkb25seSBwZXJtaXNzaW9ucz86IEpvYlByb3BzW1wicGVybWlzc2lvbnNcIl07XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIGNvbmZpZ3VyYXRpb24gZm9yIHRoZSBqb2IncyBlbnZpcm9ubWVudC5cbiAgICpcbiAgICogVGhpcyBhbGxvd3MgZm9yIGFkZGl0aW9uYWwgY3VzdG9taXphdGlvbiBvZiB0aGUgam9iJ3MgZXhlY3V0aW9uIGNvbnRleHQuXG4gICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudD86IEpvYlByb3BzW1wiZW52aXJvbm1lbnRcIl07XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGpvYiBpbiBhIHN0YWdlIG9mIHRoZSBHaXRIdWIgQWN0aW9ucyBwaXBlbGluZS5cbiAqXG4gKiBUaGlzIGNsYXNzIGV4dGVuZHMgdGhlIFN0ZXAgY2xhc3MsIHByb3ZpZGluZyBmdW5jdGlvbmFsaXR5IGZvciBleGVjdXRpbmcgYSBqb2JcbiAqIHdpdGggc3BlY2lmaWVkIG9wdGlvbnMgYW5kIGNvbmZpZ3VyYXRpb25zLlxuICovXG5leHBvcnQgY2xhc3MgU3RhZ2VKb2IgZXh0ZW5kcyBTdGVwIHtcbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgU3RhZ2VKb2IuXG4gICAqXG4gICAqIEBwYXJhbSBpZCAtIFVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGUgam9iIHN0ZXAuXG4gICAqIEBwYXJhbSBwcm9wcyAtIENvbmZpZ3VyYXRpb24gb3B0aW9ucyBmb3IgdGhlIGpvYi5cbiAgICovXG4gIGNvbnN0cnVjdG9yKFxuICAgIHB1YmxpYyByZWFkb25seSBpZDogc3RyaW5nLFxuICAgIHB1YmxpYyBwcm9wczogSVN0YWdlSm9iT3B0aW9ucyxcbiAgKSB7XG4gICAgc3VwZXIoaWQpO1xuICB9XG59XG4iXX0=