"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StagePipelineJob = exports.DeployPipelineJob = exports.PublishPipelineJob = exports.SynthPipelineJob = exports.PipelineJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = __importStar(require("node:path"));
const github_actions_cdk_1 = require("github-actions-cdk");
const assets_1 = require("./private/assets");
const CDKOUT_ARTIFACT = "cdk.out";
/**
 * Represents a job within the pipeline that requires AWS credentials and CDK output.
 *
 * @remarks
 * The `PipelineJob` class extends the `Job` class and includes specific properties and methods for managing
 * AWS authentication, CDK output references, and version control for GitHub Actions used in the pipeline.
 */
class PipelineJob extends github_actions_cdk_1.Job {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.PipelineJob", version: "0.0.21" };
    /** AWS credentials provider associated with this job. */
    awsCredentials;
    /** Specific version overrides for GitHub Actions, if any are provided. */
    versionOverrides;
    /** Directory containing the CDK output files for this job. */
    cdkoutDir;
    /**
     * Constructs a new instance of `PipelineJob`.
     *
     * @param scope - The scope in which to define this job construct.
     * @param id - Unique identifier for this job within the workflow.
     * @param props - Properties for configuring the pipeline job.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.awsCredentials = props.awsCredentials;
        this.versionOverrides = props.versionOverrides ?? {};
        this.cdkoutDir = props.cdkoutDir;
    }
    /**
     * Looks up the version override for a given action identifier, if available.
     *
     * @param actionIdentifier - The identifier of the GitHub Action to retrieve the version for.
     * @returns The overridden version (or SHA) for the action, if specified; otherwise, `undefined`.
     */
    lookupVersion(actionIdentifier) {
        return this.versionOverrides[actionIdentifier] ?? undefined;
    }
}
exports.PipelineJob = PipelineJob;
/**
 * A job that synthesizes the CloudFormation template using CDK.
 */
class SynthPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.SynthPipelineJob", version: "0.0.21" };
    constructor(scope, id, props) {
        super(scope, id, props);
        new github_actions_cdk_1.actions.CheckoutV4(this, "checkout", {
            name: "Checkout",
            version: this.lookupVersion(github_actions_cdk_1.actions.CheckoutV4.IDENTIFIER),
        });
        if (props.preBuild)
            props.preBuild.steps(this);
        if (props.installCommands && props.installCommands.length > 0) {
            new github_actions_cdk_1.RunStep(this, "install", {
                name: "Install",
                run: props.installCommands,
            });
        }
        new github_actions_cdk_1.RunStep(this, "build", {
            name: "Build",
            run: props.commands,
        });
        if (props.postBuild)
            props.postBuild.steps(this);
        new github_actions_cdk_1.actions.UploadArtifactV4(this, "upload", {
            name: `Upload ${CDKOUT_ARTIFACT}`,
            artifactName: CDKOUT_ARTIFACT,
            path: props.cdkoutDir,
            includeHiddenFiles: true,
            version: this.lookupVersion(github_actions_cdk_1.actions.UploadArtifactV4.IDENTIFIER),
        });
    }
}
exports.SynthPipelineJob = SynthPipelineJob;
/**
 * A job that publishes stack assets to AWS.
 *
 * @remarks
 * The `PublishPipelineJob` class handles the process of publishing assets to AWS.
 * It defines the steps required to download artifacts, install necessary dependencies,
 * and execute the publish command for each asset. The job integrates with AWS
 * credentials for secure authentication and provides hooks for outputting asset hashes.
 */
class PublishPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.PublishPipelineJob", version: "0.0.21" };
    /**
     * Constructs a new instance of `PublishPipelineJob`.
     *
     * @param scope - The parent construct scope.
     * @param id - Unique identifier for this publish job.
     * @param props - Configuration properties for the publish job.
     *
     * @remarks
     * The constructor initializes the publish job by setting up the necessary steps
     * to download artifacts, install dependencies, and publish assets. It iterates
     * through each asset and creates the appropriate publish steps.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Download artifact step
        new github_actions_cdk_1.actions.DownloadArtifactV4(this, "DownloadArtifact", {
            name: `Download ${CDKOUT_ARTIFACT}`,
            artifactName: CDKOUT_ARTIFACT,
            path: props.cdkoutDir,
            version: this.lookupVersion(github_actions_cdk_1.actions.DownloadArtifactV4.IDENTIFIER),
        });
        // Install CDK assets
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : "";
        new github_actions_cdk_1.RunStep(this, "install", {
            name: "Install",
            run: `npm install --no-save cdk-assets${installSuffix}`,
        });
        // AWS credentials configuration
        props.awsCredentials.credentialSteps(this, "us-east-1");
        const scriptGen = new assets_1.PublishAssetScriptGenerator(props.cdkoutDir, props.assets);
        // Write script to cdk.out directory
        const scriptFilename = path.join(props.cdkoutDir, `publish-assets-${id}.sh`);
        scriptGen.writePublishScript(scriptFilename);
        const publishStep = new github_actions_cdk_1.RunStep(this, "publish", {
            name: `Publish ${id}`,
            run: `/bin/bash ${props.cdkoutDir}/${posixPath(path.relative(props.cdkoutDir, scriptFilename))}`,
        });
        scriptGen.assetIdMap.forEach((outputName, hash) => {
            props.assetHashMap[hash] = `\${{ needs.${this.id}.outputs.${outputName} }}`;
            this.addOutput(outputName, publishStep.outputExpression(outputName));
        });
    }
}
exports.PublishPipelineJob = PublishPipelineJob;
/**
 * A job that deploys a CloudFormation stack.
 *
 * @remarks
 * The `DeployPipelineJob` class is responsible for executing the deployment of a
 * specified CloudFormation stack. It integrates with AWS credentials for authentication
 * and ensures that the stack is deployed with the correct template and asset replacements.
 * The job will throw errors if required properties are not provided, ensuring
 * robustness in the deployment process.
 */
class DeployPipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.DeployPipelineJob", version: "0.0.21" };
    /**
     * Constructs a new instance of `DeployPipelineJob`.
     *
     * @param scope - The parent construct scope.
     * @param id - Unique identifier for this deployment job.
     * @param props - Configuration properties for the deployment job.
     *
     * @remarks
     * The constructor validates required properties for the stack and sets up the
     * necessary steps to deploy the CloudFormation stack using the provided asset hash
     * mappings and options. It initializes the deployment action with AWS CloudFormation.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Validate required properties
        if (!props.stack.region) {
            throw new Error('"region" is required');
        }
        if (!props.stack.templateUrl) {
            throw new Error(`unable to determine template URL for stack ${props.stack.stackArtifactId}`);
        }
        // Configure AWS credentials for deployment
        props.awsCredentials.credentialSteps(this, props.stack.region, props.stack.assumeRoleArn);
        // Function to replace asset hash in the template
        const replaceAssetHash = (template) => {
            const hash = path.parse(template.split("/").pop() ?? "").name;
            if (props.assetHashMap[hash] === undefined) {
                throw new Error(`Template asset hash ${hash} not found.`);
            }
            return template.replace(hash, props.assetHashMap[hash]);
        };
        // Create the CloudFormation deployment action
        new github_actions_cdk_1.actions.AwsCloudFormationGitHubDeployV1(this, "deploy", {
            stackName: props.stack.stackName,
            template: replaceAssetHash(props.stack.templateUrl),
            noFailOnEmptyChangeset: "1",
            roleArn: props.stack.executionRoleArn,
            capabilities: props.stackOptions?.capabilities?.join(","),
            version: this.lookupVersion(github_actions_cdk_1.actions.AwsCloudFormationGitHubDeployV1.IDENTIFIER),
        });
    }
}
exports.DeployPipelineJob = DeployPipelineJob;
/**
 * A job that executes a specific phase of steps in the pipeline.
 */
class StagePipelineJob extends PipelineJob {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@github-actions-cdk/aws-cdk.StagePipelineJob", version: "0.0.21" };
    constructor(scope, id, props) {
        super(scope, id, props);
        props.phase.steps(this);
    }
}
exports.StagePipelineJob = StagePipelineJob;
/**
 * Converts a Windows or POSIX path to a POSIX path format.
 *
 * @param windowsOrPosixPath - The input path in either Windows or POSIX format.
 * @returns The normalized POSIX path.
 */
function posixPath(windowsOrPosixPath) {
    return windowsOrPosixPath.split(path.sep).join(path.posix.sep);
}
//# sourceMappingURL=data:application/json;base64,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