import type { Construct } from "constructs";
import type { ProjectProps } from "github-actions-cdk";
import { Project } from "github-actions-cdk";
/**
 * The `AwsCdkAdapter` class integrates GitHub Actions workflows with AWS CDK constructs,
 * inheriting from the `Project` base class in `github-actions-cdk`.
 *
 * This adapter binds the lifecycle of a GitHub Actions workflow to an AWS CDK Construct,
 * allowing workflow creation, error handling, and annotation of errors and warnings
 * during the CDK synthesis process.
 */
export declare class AwsCdkAdapter extends Project {
    private readonly awsCdkScope;
    private hasValidationErrors;
    /**
     * Constructs a new `AwsCdkAdapter` instance.
     *
     * @param awsCdkScope - The AWS CDK construct scope associated with this adapter.
     * This scope is used as a base for adding validations, annotations, and managing synthesis errors.
     * @param props - Project properties for configuring GitHub Actions workflows.
     */
    constructor(awsCdkScope: Construct, props?: ProjectProps);
    /**
     * Handles synthesis errors encountered during workflow generation.
     * If the error is a validation error, it registers the error message as a validation
     * message on the associated CDK scope.
     *
     * @param error - The error encountered during synthesis.
     * @throws Error - If the error is not a validation error, it will be re-thrown.
     */
    protected handleSynthesisError(error: unknown): void;
    /**
     * Finalizes the synthesis process by transferring workflow annotations to
     * the CDK context as appropriate.
     *
     * This method checks each annotation's severity level (info, warning, error) and
     * adds it to the CDK scope using the `Annotations` utility.
     *
     * Additionally, this method stops synthesis if there are blocking errors,
     * unless overridden by `continueOnErrorAnnotations`.
     */
    protected finalizeSynthesis(): void;
}
