<!-- Allow HTML -->
<!-- markdownlint-disable MD033 -->

<!-- Allow HTML top-level heading -->
<!-- markdownlint-disable MD041 -->

<a name="readme-top"></a>

<!-- PROJECT SHIELDS -->
<div align="center">

<a href="[pypi-url]">[![PYPI - Version][version-shield]][pypi-url]</a>
<a href="[pypi-url]">[![PYPI - Downloads][downloads-shield]][pypi-url]</a>
<a href="[forks-url]">[![Forks][forks-shield]][forks-url]</a>
<a href="[stars-url]">[![Stargazers][stars-shield]][stars-url]</a>
<a href="[license-url]">[![BSD-3-Clause License][license-shield]][license-url]</a>

</div>

<!-- PROJECT LOGO -->
<br />
<div align="center">
  <a href="https://github.com/python-thread/thread">
    <img src="https://thread.ngjx.org/favicon.svg" alt="Logo" width="80" height="80">
  </a>

  <h3 align="center">Thread</h3>

  <p align="center">
    A python threading library extension
    <br />
    <a href="https://thread.ngjx.org"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/python-thread/thread/issues">Report Bug</a>
    ·
    <a href="https://github.com/python-thread/thread/issues">Request Feature</a>
  </p>
</div>

<!-- ABOUT THE PROJECT -->

## About The Project

[![Social Card][socialcard]](https://thread.ngjx.org)

Strictly type-safe and Wraps around the python threading library
and provides extra functionality

Fully compatible with the threading library, this project hopes to
provide a more out-of-the-box solution with multi-threaded processing
and fetching values from a completed thread, etc.

<br />

**!! Important !!**<br />
This project is in it's very early stages of development and bugs are to be expected.

<br />

I hope thread will become your threading solution! ♡⸜(˶˃ ᵕ ˂˶)⸝♡

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- GETTING STARTED -->

## Getting Started

This is an example of how you can set up your project locally.
To get a local copy up and running follow these simple example steps.

### Prerequisites

- Python 3.9+

### Installation

_Below is an example of how you can install and use thread._

#### 1. Install the package

```sh
pip install -U thread
```

#### 2. Import thread into your library

```py
import thread
from thread import Thread, ConcurrentProcessing
```

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- CONTRIBUTING -->

## Contributing

Contributions are what make the open source community
such an amazing place to learn, inspire, and create.
Any contributions you make are **greatly appreciated**. ( ˶ˆᗜˆ˵ )

If you have a suggestion that would make this better,
please fork the repo and create a pull request.
You can also simply open an issue with the tag "enhancement".
Don't forget to give the project a star! Thanks again!

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

Read our [contributing guide](./CONTRIBUTING.md) for more information.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- LICENSE -->

## License

Distributed under the BSD-3-Clause License.
See [LICENSE.txt](./LICENSE.txt) for more information.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- CONTACT -->

## Contact

Alex - [contact@thread.ngjx.org](mailto:contact@thread.ngjx.org)

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- ACKNOWLEDGMENTS -->

## Acknowledgments

- [Choose an Open Source License](https://choosealicense.com)
- [GitHub Emoji Cheat Sheet](https://www.webpagefx.com/tools/emoji-cheat-sheet)
- [Malven's Flexbox Cheatsheet](https://flexbox.malven.co/)
- [Malven's Grid Cheatsheet](https://grid.malven.co/)
- [Img Shields](https://shields.io)

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->

[version-shield]: https://img.shields.io/pypi/v/thread.svg?style=for-the-badge&color=efd0cd
[downloads-shield]: https://img.shields.io/pypi/dm/thread.svg?style=for-the-badge
[pypi-url]: https://pypi.org/project/thread/
[forks-shield]: https://img.shields.io/github/forks/python-thread/thread.svg?style=for-the-badge
[forks-url]: https://github.com/python-thread/thread/network/members
[stars-shield]: https://img.shields.io/github/stars/python-thread/thread.svg?style=for-the-badge&color=yellow
[stars-url]: https://github.com/python-thread/thread/stargazers
[license-shield]: https://img.shields.io/github/license/python-thread/thread.svg?style=for-the-badge
[license-url]: https://github.com/python-thread/thread/blob/master/LICENSE.txt
[socialcard]: https://thread.ngjx.org/socialcard-white.jpg
