# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rkviewer',
 'rkviewer.canvas',
 'rkviewer.plugin',
 'rkviewer.resources',
 'rkviewer_plugins']

package_data = \
{'': ['*']}

install_requires = \
['commentjson>=0.9.0,<0.10.0',
 'marshmallow-polyfield>=5.10,<6.0',
 'marshmallow>=3.11.1,<4.0.0',
 'requests',
 'sortedcontainers>=2.3.0,<3.0.0',
 'wheel',
 'wxPython>=4.1.1,<5.0.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.8,<0.9'],
 'sbml': ['tellurium>=2.2.1,<3.0.0',
          'sbml2matlab==1.2.3',
          'networkx>=2.5.1,<3.0.0',
          'simplesbml>=2.2.0,<3.0.0',
          'python-libsbml>=5.18.0,<6.0.0',
          'pandas>=1.3.0,<2.0.0']}

entry_points = \
{'console_scripts': ['coyote = rkviewer.main:main']}

setup_kwargs = {
    'name': 'pyrkviewer',
    'version': '1.0.7',
    'description': 'COYOTE: An Extensible Python Based Reaction Editor and Viewer.',
    'long_description': '# Coyote: A visualization tool for reaction networks.\n\n## Introduction\n\nCoyote, also called PyRKViewer, is a cross-platform visualization tool for drawing reaction networks written with the\n[wxPython](https://www.wxpython.org/) framework. It can draw reactants, products, reactions, and compartments, and its features include but are not limited to:\n* Support for floating and boundary species.\n* Reactions can be displayed using Bezier curves and straight lines.\n* Plugin support, with some plugin examples: Arrow Designer, Random Network, Auto Layout, etc.\n\n## Getting Started\n\n### Installing with Pypi\n* `pip install pyrkviewer` for the base application\n* `pip install pyrkviewer[sbml]` to install the additional SBML dependencies used by certain plugins\nas well. Note that this is a large set of dependencies.\n* To run the application, simply run `coyote` or `python -m coyote`\n* Note that on MacOS, if you wish to use Coyote in a virtual environment, use `venv` instead of\n`virtualenv`, due to the latter\'s issues with wxPython.\n\n### Installing with Poetry\n1. If you do not have poetry installed on your computer, follow the quick steps shown [here](https://python-poetry.org/docs/).\n2. Once you have poetry installed, you will download Coyote. Click the green button at the top of this page that says “Code” and choose “Download ZIP”. You want to make sure you know where you have downloaded this. Unzip the folder to your desired directory.\n3. Next, open your terminal and navigate to the directory containing Coyote.\n4. Once inside the main folder of the application you can install the dependencies. To install the base dependencies simply run `poetry install`. To install the optional ones as well, run `poetry install -E sbml`. Note that this step may take a while. To learn more about which set of dependencies is right for you, refer to the [Dependencies](#Dependencies) section below.\n5. Finally, you will run the application with the command `poetry run coyote`.\n\nAfter you have completed all of these steps, you will not have to repeat them every time you want to run the application. Once the setup is done you will only need to open the terminal, navigate into the folder that contains your Coyote application, and run the command `poetry run coyote`.\n\n### Installing without Poetry\n\nAgain, we strongly advise following the steps above, as it makes the set-up process much faster and simpler. However, to install Coyote without Poetry, here is the process you will follow:\n\n1. First, download Coyote. Click the green button at the top of this page that says “Code” and choose “Download ZIP”. You want to make sure you know where you have downloaded this. Unzip the folder to your desired directory.\n2. Next, open your terminal and navigate to the directory containing Coyote.\n3. To install the base set of dependencies, you will run `pip install -r requirements.txt`. Then if you want to install the optional dependencies as well, run `pip install -r requirements-sbml.txt`. To learn more about which set of dependencies is right for you, refer to the [Dependencies](#Dependencies) section below.\n4. Finally, you will run the application with the command `python -m rkviewer.main`.\nAfter you have completed all of these steps, you will not have to repeat them every time you want to run the application. Once the setup is done you will only need to open the terminal, navigate into the folder that contains your Coyote application, and run the command `python -m rkviewer.main`.\n\n### Running\n* If you have poetry, simply run `poetry run coyote`.\n* Otherwise, in your virtual environment, run `python -m rkviewer.main`.\n* Then, check out the [documentation](#documentation).\n\n## Development Setup\n\n### Dependencies\nWe are using [poetry](https://python-poetry.org/) for dependency management. If you are just looking\nto build and run, though, you can work solely with `pip` as well.\n\nThere are currently three dependency groups: "base", "development", and "sbml".\n* "base" is the bare minimum requirements to run the application without any plugins.\n* "development" includes the additional requirements for development, such as for documentation\nand testing.\n* "sbml" includes a large set of dependencies required for running most SBML-related plugins,\nsuch as import/exportSBML and load Antimony. (This is in addition to the base requirements).\n\nIf you plan to work with SBML or Antimony code, you are almost certainly going to need the\n"sbml" dependency group. Note that "sbml" includes quite a large set of dependencies (mostly\nSBML-related, so if you usually work with SBML, you\'ll probably have most of it installed already).\n\nThe dependency groups are specified in `pyproject.toml` for `poetry`. There are additionally\n`requirement.txt` files generated by `poetry`, including `requirements.txt`, `requirements-dev.txt`,\nand `requirements-sbml.txt`. If you do not have poetry, you can opt for those as well. If you are\nusing linux, extra work would need to be done on installing wxPython. Please refer to the\n"Linux Notes" section below.\n\n### Installing Dependencies\n`poetry` is recommended for installing dependencies. Simply `poetry install` for the base\ndependencies and `poetry install -E sbml` to install the optional ones as well.\n\nIf you don\'t have poetry, you can simply run `pip install -r <>` for any of the aforementioned\n`requirements.txt` files.\n\n### Running locally\n* If you have poetry, simply `poetry run coyote`.\n* Otherwise, in your virtual environment, run `python -m rkviewer.main`.\n\n## Distributing\n* Use `poetry build` and `poetry publish`. Refer to [poetry docs](https://python-poetry.org/docs/)\nfor more detail.\n* To re-generate the `requirements*.txt`, run `scripts/gen_requirements.py`.\n\n### Bundling an Executable with PyInstaller\n**NOTE: This section is obsolete for now, as we are currently distributing with pip.**\n* Always run `pyinstaller rkviewer.spec` when `rkviewer.spec` is present.\n* If somehow `rkviewer.spec` went missing or you want to regenerate the build specs, run `pyinstaller -F --windowed --add-data ext/Iodine.dll;. main.py` on Windows or `pyinstaller -F -- windowed --add-data ext/Iodine.dll:. main.py` on Linux/Mac to generate a file named `main.spec`. Note that if a `main.spec` file is already  present **it will be overwritten**.\n\n## Documentation\n\nThe full documentation can be found at: https://sys-bio.github.io/PyRKViewer/\n\n## For Different Platforms\n\nThe python version for development was 3.7.7.\n\n### Mac Notes\n* pyinstaller and wxPython require a python built with `enable-framework` on. Therefore, one should do `env PYTHON_CONFIGURE_OPTS="--enable-framework" pyenv install 3.7.7` and\nuse that Python installation for building.\n* If the text is blurry in the app bundled by `pyinstaller`, one needs to add an entry in the pyinstaller settings as described [here](https://stackoverflow.com/a/40676321).\n\n### Linux Notes\n* To install wxPython on linux, see https://wxpython.org/blog/2017-08-17-builds-for-linux-with-pip/index.html. `requirements-dev.txt` and `requirements.txt` assume the user is on Ubuntu 18.04 for readthedocs. If you have a different distro and have trouble using `requirements.txt`, just install wxPython manually using the previous link.\n* Related to the last note, if readthedocs start having trouble building wxPython, understand that it might be because readthedocs updated its distro from Ubuntu 18.04. Go to `requirements-dev.txt` and change the line above `wxPython` to look in the appropriate link.\n* i.e. `-f https://extras.wxpython.org/wxPython4/extras/linux/gtk3/ubuntu-18.04/ \\n wxPython==4.1.1`\n\n## Future Development\n\n### Testing and Profiling\n* To run all tests, go to project root and run `python -m unittest discover`.\n* To run a specific test suite, run e.g. `python -m unittest test.api.test_node`.\n* Or even more specific: `python -m unittest test.api.test_node.TestNode.test_add_nodes`.\n* To profile the application, run `python -m cProfile -o rkviewer.stat main.py`.\n* To visualize the profile result, run `tuna rkviewer.stat`.\n\n### Building Local Docs\n* Run `sphinx-apidoc -f -o docs/source/rkviewer rkviewer rkviewer/plugin rkviewer/resources ` to regenerate the full reference doc source\ncode, if new files were added to the package rkviewer.\n* Run `sphinx-build -b html docs\\source docs\\build`.\n\n### Note on Style\nUsually snake_case is used for function names. However, to retain some degree of backwards\ncompatibility for wxPython, subclasses of wxPython classes use PascalCase for their methods, e.g. `Canvas::RegisterAllChildren`.\n\n### TODOs\n* ENHANCEMENT: Add support for multiple net IDs. Currently all net IDs are set to 0 by default.\n\n### Shapes TODOs\n* Events (NodeModified)\n\n### Roadmap for Shape Engine\nA shape "engine" allows the user to specify custom composite shapes for nodes and compartments.\nComposite shapes are constructed out of primitives such as circles, (rounded) rectangles, polygons,\netc.\n\nRKViewer provides a default list of (composite) shapes, but the user may also create their own\nshapes out of primitives. A (composite) shape is formed out of one or many primitives, each\nscaled, rotated, and translated by certain amounts. User-created shapes will be\nassociated with each model in the exported `.json` files.\n\nA shape-creation plugin may be created in the future to facilitate the process of designing\ncomplex shapes.\n\nHere is the roadmap for the shape engine:\n* Create preliminary list of primitives and a default list of shapes. Allow model loader/saver to\nreference that list.\n* Modify renderer to be able to render these default shapes.\n* Modify inspector to allow the user to change the properties of the primitives in the shape, such\nas colors, border thickness, etc.\n* Modify model loader/saver to allow users to create custom shape lists manually.\n* Write shape-creation plugin?\n',
    'author': 'Jin Xu and Gary Geng et al',
    'author_email': 'jxu2019@uw.edu',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<3.11',
}


setup(**setup_kwargs)
