"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        var _a, _b;
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = (_a = actionProperties.runOrder) !== null && _a !== void 0 ? _a : 1;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = (_b = actionProperties.role) !== null && _b !== void 0 ? _b : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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