import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::CodePipeline::CustomActionType`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
export interface CfnCustomActionTypeProps {
    /**
     * `AWS::CodePipeline::CustomActionType.Category`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category
     */
    readonly category: string;
    /**
     * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
     */
    readonly inputArtifactDetails: CfnCustomActionType.ArtifactDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
     */
    readonly outputArtifactDetails: CfnCustomActionType.ArtifactDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.Provider`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider
     */
    readonly provider: string;
    /**
     * `AWS::CodePipeline::CustomActionType.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version
     */
    readonly version: string;
    /**
     * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
     */
    readonly configurationProperties?: Array<CfnCustomActionType.ConfigurationPropertiesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.Settings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
     */
    readonly settings?: CfnCustomActionType.SettingsProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodePipeline::CustomActionType`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::CustomActionType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
export declare class CfnCustomActionType extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodePipeline::CustomActionType";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCustomActionType;
    /**
     * `AWS::CodePipeline::CustomActionType.Category`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category
     */
    category: string;
    /**
     * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
     */
    inputArtifactDetails: CfnCustomActionType.ArtifactDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
     */
    outputArtifactDetails: CfnCustomActionType.ArtifactDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::CustomActionType.Provider`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider
     */
    provider: string;
    /**
     * `AWS::CodePipeline::CustomActionType.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version
     */
    version: string;
    /**
     * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
     */
    configurationProperties: Array<CfnCustomActionType.ConfigurationPropertiesProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::CustomActionType.Settings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
     */
    settings: CfnCustomActionType.SettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::CustomActionType.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodePipeline::CustomActionType`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomActionTypeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodePipeline::CustomActionType`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::CustomActionType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
export declare namespace CfnCustomActionType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html
     */
    interface ArtifactDetailsProperty {
        /**
         * `CfnCustomActionType.ArtifactDetailsProperty.MaximumCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-maximumcount
         */
        readonly maximumCount: number;
        /**
         * `CfnCustomActionType.ArtifactDetailsProperty.MinimumCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-minimumcount
         */
        readonly minimumCount: number;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::CustomActionType`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::CustomActionType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
export declare namespace CfnCustomActionType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html
     */
    interface ConfigurationPropertiesProperty {
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-description
         */
        readonly description?: string;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-key
         */
        readonly key: boolean | cdk.IResolvable;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-name
         */
        readonly name: string;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Queryable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-queryable
         */
        readonly queryable?: boolean | cdk.IResolvable;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Required`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-required
         */
        readonly required: boolean | cdk.IResolvable;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Secret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-secret
         */
        readonly secret: boolean | cdk.IResolvable;
        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::CustomActionType`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::CustomActionType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
export declare namespace CfnCustomActionType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html
     */
    interface SettingsProperty {
        /**
         * `CfnCustomActionType.SettingsProperty.EntityUrlTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-entityurltemplate
         */
        readonly entityUrlTemplate?: string;
        /**
         * `CfnCustomActionType.SettingsProperty.ExecutionUrlTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-executionurltemplate
         */
        readonly executionUrlTemplate?: string;
        /**
         * `CfnCustomActionType.SettingsProperty.RevisionUrlTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-revisionurltemplate
         */
        readonly revisionUrlTemplate?: string;
        /**
         * `CfnCustomActionType.SettingsProperty.ThirdPartyConfigurationUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-thirdpartyconfigurationurl
         */
        readonly thirdPartyConfigurationUrl?: string;
    }
}
/**
 * Properties for defining a `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export interface CfnPipelineProps {
    /**
     * `AWS::CodePipeline::Pipeline.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::CodePipeline::Pipeline.Stages`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages
     */
    readonly stages: Array<CfnPipeline.StageDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.ArtifactStore`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore
     */
    readonly artifactStore?: CfnPipeline.ArtifactStoreProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.ArtifactStores`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores
     */
    readonly artifactStores?: Array<CfnPipeline.ArtifactStoreMapProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.DisableInboundStageTransitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions
     */
    readonly disableInboundStageTransitions?: Array<CfnPipeline.StageTransitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name
     */
    readonly name?: string;
    /**
     * `AWS::CodePipeline::Pipeline.RestartExecutionOnUpdate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate
     */
    readonly restartExecutionOnUpdate?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodePipeline::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::CodePipeline::Pipeline.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn
     */
    roleArn: string;
    /**
     * `AWS::CodePipeline::Pipeline.Stages`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages
     */
    stages: Array<CfnPipeline.StageDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Pipeline.ArtifactStore`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore
     */
    artifactStore: CfnPipeline.ArtifactStoreProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::Pipeline.ArtifactStores`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores
     */
    artifactStores: Array<CfnPipeline.ArtifactStoreMapProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::Pipeline.DisableInboundStageTransitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions
     */
    disableInboundStageTransitions: Array<CfnPipeline.StageTransitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::Pipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name
     */
    name: string | undefined;
    /**
     * `AWS::CodePipeline::Pipeline.RestartExecutionOnUpdate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate
     */
    restartExecutionOnUpdate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodePipeline::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodePipeline::Pipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPipelineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html
     */
    interface ActionDeclarationProperty {
        /**
         * `CfnPipeline.ActionDeclarationProperty.ActionTypeId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-actiontypeid
         */
        readonly actionTypeId: CfnPipeline.ActionTypeIdProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActionDeclarationProperty.Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-configuration
         */
        readonly configuration?: any | cdk.IResolvable;
        /**
         * `CfnPipeline.ActionDeclarationProperty.InputArtifacts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-inputartifacts
         */
        readonly inputArtifacts?: Array<CfnPipeline.InputArtifactProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.ActionDeclarationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.ActionDeclarationProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-actiondeclaration-namespace
         */
        readonly namespace?: string;
        /**
         * `CfnPipeline.ActionDeclarationProperty.OutputArtifacts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-outputartifacts
         */
        readonly outputArtifacts?: Array<CfnPipeline.OutputArtifactProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.ActionDeclarationProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-region
         */
        readonly region?: string;
        /**
         * `CfnPipeline.ActionDeclarationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnPipeline.ActionDeclarationProperty.RunOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html#cfn-codepipeline-pipeline-stages-actions-runorder
         */
        readonly runOrder?: number;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html
     */
    interface ActionTypeIdProperty {
        /**
         * `CfnPipeline.ActionTypeIdProperty.Category`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html#cfn-codepipeline-pipeline-stages-actions-actiontypeid-category
         */
        readonly category: string;
        /**
         * `CfnPipeline.ActionTypeIdProperty.Owner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html#cfn-codepipeline-pipeline-stages-actions-actiontypeid-owner
         */
        readonly owner: string;
        /**
         * `CfnPipeline.ActionTypeIdProperty.Provider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html#cfn-codepipeline-pipeline-stages-actions-actiontypeid-provider
         */
        readonly provider: string;
        /**
         * `CfnPipeline.ActionTypeIdProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html#cfn-codepipeline-pipeline-stages-actions-actiontypeid-version
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html
     */
    interface ArtifactStoreProperty {
        /**
         * `CfnPipeline.ArtifactStoreProperty.EncryptionKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-encryptionkey
         */
        readonly encryptionKey?: CfnPipeline.EncryptionKeyProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ArtifactStoreProperty.Location`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-location
         */
        readonly location: string;
        /**
         * `CfnPipeline.ArtifactStoreProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html
     */
    interface ArtifactStoreMapProperty {
        /**
         * `CfnPipeline.ArtifactStoreMapProperty.ArtifactStore`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-artifactstore
         */
        readonly artifactStore: CfnPipeline.ArtifactStoreProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ArtifactStoreMapProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-region
         */
        readonly region: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-blockers.html
     */
    interface BlockerDeclarationProperty {
        /**
         * `CfnPipeline.BlockerDeclarationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-blockers.html#cfn-codepipeline-pipeline-stages-blockers-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.BlockerDeclarationProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-blockers.html#cfn-codepipeline-pipeline-stages-blockers-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore-encryptionkey.html
     */
    interface EncryptionKeyProperty {
        /**
         * `CfnPipeline.EncryptionKeyProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore-encryptionkey.html#cfn-codepipeline-pipeline-artifactstore-encryptionkey-id
         */
        readonly id: string;
        /**
         * `CfnPipeline.EncryptionKeyProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore-encryptionkey.html#cfn-codepipeline-pipeline-artifactstore-encryptionkey-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-inputartifacts.html
     */
    interface InputArtifactProperty {
        /**
         * `CfnPipeline.InputArtifactProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-inputartifacts.html#cfn-codepipeline-pipeline-stages-actions-inputartifacts-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-outputartifacts.html
     */
    interface OutputArtifactProperty {
        /**
         * `CfnPipeline.OutputArtifactProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-outputartifacts.html#cfn-codepipeline-pipeline-stages-actions-outputartifacts-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages.html
     */
    interface StageDeclarationProperty {
        /**
         * `CfnPipeline.StageDeclarationProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages.html#cfn-codepipeline-pipeline-stages-actions
         */
        readonly actions: Array<CfnPipeline.ActionDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.StageDeclarationProperty.Blockers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages.html#cfn-codepipeline-pipeline-stages-blockers
         */
        readonly blockers?: Array<CfnPipeline.BlockerDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.StageDeclarationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages.html#cfn-codepipeline-pipeline-stages-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-disableinboundstagetransitions.html
     */
    interface StageTransitionProperty {
        /**
         * `CfnPipeline.StageTransitionProperty.Reason`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-disableinboundstagetransitions.html#cfn-codepipeline-pipeline-disableinboundstagetransitions-reason
         */
        readonly reason: string;
        /**
         * `CfnPipeline.StageTransitionProperty.StageName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-disableinboundstagetransitions.html#cfn-codepipeline-pipeline-disableinboundstagetransitions-stagename
         */
        readonly stageName: string;
    }
}
/**
 * Properties for defining a `AWS::CodePipeline::Webhook`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html
 */
export interface CfnWebhookProps {
    /**
     * `AWS::CodePipeline::Webhook.Authentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-authentication
     */
    readonly authentication: string;
    /**
     * `AWS::CodePipeline::Webhook.AuthenticationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-authenticationconfiguration
     */
    readonly authenticationConfiguration: CfnWebhook.WebhookAuthConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Webhook.Filters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-filters
     */
    readonly filters: Array<CfnWebhook.WebhookFilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Webhook.TargetAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetaction
     */
    readonly targetAction: string;
    /**
     * `AWS::CodePipeline::Webhook.TargetPipeline`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetpipeline
     */
    readonly targetPipeline: string;
    /**
     * `AWS::CodePipeline::Webhook.TargetPipelineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetpipelineversion
     */
    readonly targetPipelineVersion: number;
    /**
     * `AWS::CodePipeline::Webhook.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-name
     */
    readonly name?: string;
    /**
     * `AWS::CodePipeline::Webhook.RegisterWithThirdParty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-registerwiththirdparty
     */
    readonly registerWithThirdParty?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodePipeline::Webhook`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Webhook
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html
 */
export declare class CfnWebhook extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodePipeline::Webhook";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWebhook;
    /**
     * @external
     * @cloudformationAttribute Url
     */
    readonly attrUrl: string;
    /**
     * `AWS::CodePipeline::Webhook.Authentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-authentication
     */
    authentication: string;
    /**
     * `AWS::CodePipeline::Webhook.AuthenticationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-authenticationconfiguration
     */
    authenticationConfiguration: CfnWebhook.WebhookAuthConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Webhook.Filters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-filters
     */
    filters: Array<CfnWebhook.WebhookFilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodePipeline::Webhook.TargetAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetaction
     */
    targetAction: string;
    /**
     * `AWS::CodePipeline::Webhook.TargetPipeline`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetpipeline
     */
    targetPipeline: string;
    /**
     * `AWS::CodePipeline::Webhook.TargetPipelineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-targetpipelineversion
     */
    targetPipelineVersion: number;
    /**
     * `AWS::CodePipeline::Webhook.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-name
     */
    name: string | undefined;
    /**
     * `AWS::CodePipeline::Webhook.RegisterWithThirdParty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html#cfn-codepipeline-webhook-registerwiththirdparty
     */
    registerWithThirdParty: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodePipeline::Webhook`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWebhookProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodePipeline::Webhook`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Webhook
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html
 */
export declare namespace CfnWebhook {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookauthconfiguration.html
     */
    interface WebhookAuthConfigurationProperty {
        /**
         * `CfnWebhook.WebhookAuthConfigurationProperty.AllowedIPRange`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookauthconfiguration.html#cfn-codepipeline-webhook-webhookauthconfiguration-allowediprange
         */
        readonly allowedIpRange?: string;
        /**
         * `CfnWebhook.WebhookAuthConfigurationProperty.SecretToken`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookauthconfiguration.html#cfn-codepipeline-webhook-webhookauthconfiguration-secrettoken
         */
        readonly secretToken?: string;
    }
}
/**
 * A CloudFormation `AWS::CodePipeline::Webhook`.
 *
 * @external
 * @cloudformationResource AWS::CodePipeline::Webhook
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html
 */
export declare namespace CfnWebhook {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookfilterrule.html
     */
    interface WebhookFilterRuleProperty {
        /**
         * `CfnWebhook.WebhookFilterRuleProperty.JsonPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookfilterrule.html#cfn-codepipeline-webhook-webhookfilterrule-jsonpath
         */
        readonly jsonPath: string;
        /**
         * `CfnWebhook.WebhookFilterRuleProperty.MatchEquals`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookfilterrule.html#cfn-codepipeline-webhook-webhookfilterrule-matchequals
         */
        readonly matchEquals?: string;
    }
}
