# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-password-reset-config.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class PasswordResetConfig(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* Password Reset
    Configuration.
    """
    def __init__(self, undef_enabled=True):
        super(PasswordResetConfig, self).__init__()
        self._type = ("PasswordResetConfig", True)
        self._token_validity = (self.__undef__, True)

    API_VERSION = "1.11.16"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(PasswordResetConfig, cls).from_dict(data, dirty, undef_enabled)
        obj._token_validity = (data.get("tokenValidity", obj.__undef__), dirty)
        if obj._token_validity[0] is not None and obj._token_validity[0] is not obj.__undef__:
            assert isinstance(obj._token_validity[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._token_validity[0], type(obj._token_validity[0])))
            common.validate_format(obj._token_validity[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(PasswordResetConfig, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "token_validity" == "type" or (self.token_validity is not self.__undef__ and (not (dirty and not self._token_validity[1]) or isinstance(self.token_validity, list) or belongs_to_parent)):
            dct["tokenValidity"] = dictify(self.token_validity)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._token_validity = (self._token_validity[0], True)

    def is_dirty(self):
        return any([self._token_validity[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, PasswordResetConfig):
            return False
        return super(PasswordResetConfig, self).__eq__(other) and \
               self.token_validity == other.token_validity

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def token_validity(self):
        """
        The amount of time (in minutes) a token is considered valid after being
        issued. Setting this value to 0 disables the password reset feature.

        :rtype: ``int``
        """
        return self._token_validity[0]

    @token_validity.setter
    def token_validity(self, value):
        self._token_validity = (value, True)

