# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-fluentd-secret-attribute.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.web.objects.FluentdAttribute import FluentdAttribute
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class FluentdSecretAttribute(FluentdAttribute):
    """
    *(extends* :py:class:`delphixpy.web.vo.FluentdAttribute` *)* Fluentd
    attribute with a secret value.
    """
    def __init__(self, undef_enabled=True):
        super(FluentdSecretAttribute, self).__init__()
        self._type = ("FluentdSecretAttribute", True)
        self._secret_value = (self.__undef__, True)

    API_VERSION = "1.11.16"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(FluentdSecretAttribute, cls).from_dict(data, dirty, undef_enabled)
        obj._secret_value = (data.get("secretValue", obj.__undef__), dirty)
        if obj._secret_value[0] is not None and obj._secret_value[0] is not obj.__undef__:
            assert isinstance(obj._secret_value[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._secret_value[0], type(obj._secret_value[0])))
            common.validate_format(obj._secret_value[0], "password", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(FluentdSecretAttribute, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "secret_value" == "type" or (self.secret_value is not self.__undef__ and (not (dirty and not self._secret_value[1]) or isinstance(self.secret_value, list) or belongs_to_parent)):
            dct["secretValue"] = dictify(self.secret_value)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._secret_value = (self._secret_value[0], True)

    def is_dirty(self):
        return any([self._secret_value[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, FluentdSecretAttribute):
            return False
        return super(FluentdSecretAttribute, self).__eq__(other) and \
               self.secret_value == other.secret_value

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def secret_value(self):
        """
        Secret attribute value.

        :rtype: ``TEXT_TYPE``
        """
        return self._secret_value[0]

    @secret_value.setter
    def secret_value(self, value):
        self._secret_value = (value, True)

