# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-fluentd-plugin.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.web.objects.UserObject import UserObject
from delphixpy import factory
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class FluentdPlugin(UserObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.UserObject` *)* Upload and manage
    fluentd plugins.
    """
    def __init__(self, undef_enabled=True):
        super(FluentdPlugin, self).__init__()
        self._type = ("FluentdPlugin", True)
        self._plugin = (self.__undef__, True)
        self._gems = (self.__undef__, True)
        self._attribute_definitions = (self.__undef__, True)
        self._schema_definition = (self.__undef__, True)

    API_VERSION = "1.11.16"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(FluentdPlugin, cls).from_dict(data, dirty, undef_enabled)
        obj._plugin = (data.get("plugin", obj.__undef__), dirty)
        if obj._plugin[0] is not None and obj._plugin[0] is not obj.__undef__:
            assert isinstance(obj._plugin[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._plugin[0], type(obj._plugin[0])))
            common.validate_format(obj._plugin[0], "None", None, None)
        obj._gems = (data.get("gems", obj.__undef__), dirty)
        if obj._gems[0] is not None and obj._gems[0] is not obj.__undef__:
            assert isinstance(obj._gems[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._gems[0], type(obj._gems[0])))
            common.validate_format(obj._gems[0], "None", None, None)
        obj._attribute_definitions = []
        for item in data.get("attributeDefinitions") or []:
            obj._attribute_definitions.append(factory.create_object(item))
            factory.validate_type(obj._attribute_definitions[-1], "FluentdAttributeDefinition")
        obj._attribute_definitions = (obj._attribute_definitions, dirty)
        if "schemaDefinition" in data and data["schemaDefinition"] is not None:
            obj._schema_definition = (data["schemaDefinition"], dirty)
        else:
            obj._schema_definition = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(FluentdPlugin, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "plugin" == "type" or (self.plugin is not self.__undef__ and (not (dirty and not self._plugin[1]))):
            dct["plugin"] = dictify(self.plugin)
        if "gems" == "type" or (self.gems is not self.__undef__ and (not (dirty and not self._gems[1]))):
            dct["gems"] = dictify(self.gems)
        if "attribute_definitions" == "type" or (self.attribute_definitions is not self.__undef__ and (not (dirty and not self._attribute_definitions[1]))):
            dct["attributeDefinitions"] = dictify(self.attribute_definitions)
        if "schema_definition" == "type" or (self.schema_definition is not self.__undef__ and (not (dirty and not self._schema_definition[1]))):
            dct["schemaDefinition"] = dictify(self.schema_definition)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._plugin = (self._plugin[0], True)
        self._gems = (self._gems[0], True)
        self._attribute_definitions = (self._attribute_definitions[0], True)
        self._schema_definition = (self._schema_definition[0], True)

    def is_dirty(self):
        return any([self._plugin[1], self._gems[1], self._attribute_definitions[1], self._schema_definition[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, FluentdPlugin):
            return False
        return super(FluentdPlugin, self).__eq__(other) and \
               self.plugin == other.plugin and \
               self.gems == other.gems and \
               self.attribute_definitions == other.attribute_definitions and \
               self.schema_definition == other.schema_definition

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def plugin(self):
        """
        Name of the fluentd plugin.

        :rtype: ``TEXT_TYPE``
        """
        return self._plugin[0]

    @plugin.setter
    def plugin(self, value):
        self._plugin = (value, True)

    @property
    def gems(self):
        """
        A comma separated list of ruby gems.

        :rtype: ``TEXT_TYPE``
        """
        return self._gems[0]

    @gems.setter
    def gems(self, value):
        self._gems = (value, True)

    @property
    def attribute_definitions(self):
        """
        A list of the attribute definitions needed for configuration.

        :rtype: ``list`` of
            :py:class:`delphixpy.web.vo.FluentdAttributeDefinition`
        """
        return self._attribute_definitions[0]

    @attribute_definitions.setter
    def attribute_definitions(self, value):
        self._attribute_definitions = (value, True)

    @property
    def schema_definition(self):
        """
        A schema definition generated with attribute names and their types. The
        type is taken string by default.

        :rtype: :py:class:`delphixpy.web.vo.SchemaDraftV4`
        """
        return self._schema_definition[0]

    @schema_definition.setter
    def schema_definition(self, value):
        self._schema_definition = (value, True)

