# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-delphix-managed-backup-ingestion-strategy.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_9_3.web.objects.IngestionStrategy import IngestionStrategy
from delphixpy.v1_9_3 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class DelphixManagedBackupIngestionStrategy(IngestionStrategy):
    """
    *(extends* :py:class:`v1_9_3.web.vo.IngestionStrategy` *)* This link source
    has a Delphix managed backup ingestion strategy that will create copy-only
    full backups based on a policy and ingest that backup.
    """
    def __init__(self, undef_enabled=True):
        super(DelphixManagedBackupIngestionStrategy, self).__init__()
        self._type = ("DelphixManagedBackupIngestionStrategy", True)
        self._compression_enabled = (self.__undef__, True)

    API_VERSION = "1.9.3"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(DelphixManagedBackupIngestionStrategy, cls).from_dict(data, dirty, undef_enabled)
        obj._compression_enabled = (data.get("compressionEnabled", obj.__undef__), dirty)
        if obj._compression_enabled[0] is not None and obj._compression_enabled[0] is not obj.__undef__:
            assert isinstance(obj._compression_enabled[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._compression_enabled[0], type(obj._compression_enabled[0])))
            common.validate_format(obj._compression_enabled[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(DelphixManagedBackupIngestionStrategy, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "compression_enabled" == "type" or (self.compression_enabled is not self.__undef__ and (not (dirty and not self._compression_enabled[1]) or isinstance(self.compression_enabled, list) or belongs_to_parent)):
            dct["compressionEnabled"] = dictify(self.compression_enabled)
        elif belongs_to_parent and self.compression_enabled is self.__undef__:
            dct["compressionEnabled"] = False
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._compression_enabled = (self._compression_enabled[0], True)

    def is_dirty(self):
        return any([self._compression_enabled[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, DelphixManagedBackupIngestionStrategy):
            return False
        return super(DelphixManagedBackupIngestionStrategy, self).__eq__(other) and \
               self.compression_enabled == other.compression_enabled

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def compression_enabled(self):
        """
        Specify whether the backups taken should be compressed or uncompressed.

        :rtype: ``bool``
        """
        return self._compression_enabled[0]

    @compression_enabled.setter
    def compression_enabled(self, value):
        self._compression_enabled = (value, True)

