# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-network-latency-test.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_4_3.web.objects.UserObject import UserObject
from delphixpy.v1_4_3 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class NetworkLatencyTest(UserObject):
    """
    *(extends* :py:class:`v1_4_3.web.vo.UserObject` *)* Round-trip latency
    tests to a target system.
    """
    def __init__(self, undef_enabled=True):
        super(NetworkLatencyTest, self).__init__()
        self._type = ("NetworkLatencyTest", True)
        self._average = (self.__undef__, True)
        self._end_time = (self.__undef__, True)
        self._loss = (self.__undef__, True)
        self._maximum = (self.__undef__, True)
        self._minimum = (self.__undef__, True)
        self._remote_address = (self.__undef__, True)
        self._remote_host = (self.__undef__, True)
        self._request_count = (self.__undef__, True)
        self._request_size = (self.__undef__, True)
        self._start_time = (self.__undef__, True)
        self._state = (self.__undef__, True)
        self._stddev = (self.__undef__, True)

    API_VERSION = "1.4.3"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(NetworkLatencyTest, cls).from_dict(data, dirty, undef_enabled)
        obj._average = (data.get("average", obj.__undef__), dirty)
        if obj._average[0] is not None and obj._average[0] is not obj.__undef__:
            assert isinstance(obj._average[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._average[0], type(obj._average[0])))
            common.validate_format(obj._average[0], "None", None, None)
        obj._end_time = (data.get("endTime", obj.__undef__), dirty)
        if obj._end_time[0] is not None and obj._end_time[0] is not obj.__undef__:
            assert isinstance(obj._end_time[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._end_time[0], type(obj._end_time[0])))
            common.validate_format(obj._end_time[0], "date", None, None)
        obj._loss = (data.get("loss", obj.__undef__), dirty)
        if obj._loss[0] is not None and obj._loss[0] is not obj.__undef__:
            assert isinstance(obj._loss[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._loss[0], type(obj._loss[0])))
            common.validate_format(obj._loss[0], "None", None, None)
        obj._maximum = (data.get("maximum", obj.__undef__), dirty)
        if obj._maximum[0] is not None and obj._maximum[0] is not obj.__undef__:
            assert isinstance(obj._maximum[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._maximum[0], type(obj._maximum[0])))
            common.validate_format(obj._maximum[0], "None", None, None)
        obj._minimum = (data.get("minimum", obj.__undef__), dirty)
        if obj._minimum[0] is not None and obj._minimum[0] is not obj.__undef__:
            assert isinstance(obj._minimum[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._minimum[0], type(obj._minimum[0])))
            common.validate_format(obj._minimum[0], "None", None, None)
        obj._remote_address = (data.get("remoteAddress", obj.__undef__), dirty)
        if obj._remote_address[0] is not None and obj._remote_address[0] is not obj.__undef__:
            assert isinstance(obj._remote_address[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._remote_address[0], type(obj._remote_address[0])))
            common.validate_format(obj._remote_address[0], "ipAddress", None, None)
        obj._remote_host = (data.get("remoteHost", obj.__undef__), dirty)
        if obj._remote_host[0] is not None and obj._remote_host[0] is not obj.__undef__:
            assert isinstance(obj._remote_host[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._remote_host[0], type(obj._remote_host[0])))
            common.validate_format(obj._remote_host[0], "objectReference", None, None)
        obj._request_count = (data.get("requestCount", obj.__undef__), dirty)
        if obj._request_count[0] is not None and obj._request_count[0] is not obj.__undef__:
            assert isinstance(obj._request_count[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._request_count[0], type(obj._request_count[0])))
            common.validate_format(obj._request_count[0], "None", None, None)
        obj._request_size = (data.get("requestSize", obj.__undef__), dirty)
        if obj._request_size[0] is not None and obj._request_size[0] is not obj.__undef__:
            assert isinstance(obj._request_size[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._request_size[0], type(obj._request_size[0])))
            common.validate_format(obj._request_size[0], "None", None, None)
        obj._start_time = (data.get("startTime", obj.__undef__), dirty)
        if obj._start_time[0] is not None and obj._start_time[0] is not obj.__undef__:
            assert isinstance(obj._start_time[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._start_time[0], type(obj._start_time[0])))
            common.validate_format(obj._start_time[0], "date", None, None)
        obj._state = (data.get("state", obj.__undef__), dirty)
        if obj._state[0] is not None and obj._state[0] is not obj.__undef__:
            assert isinstance(obj._state[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._state[0], type(obj._state[0])))
            assert obj._state[0] in ['RUNNING', 'COMPLETED', 'FAILED', 'CANCELED'], "Expected enum ['RUNNING', 'COMPLETED', 'FAILED', 'CANCELED'] but got %s" % obj._state[0]
            common.validate_format(obj._state[0], "None", None, None)
        obj._stddev = (data.get("stddev", obj.__undef__), dirty)
        if obj._stddev[0] is not None and obj._stddev[0] is not obj.__undef__:
            assert isinstance(obj._stddev[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._stddev[0], type(obj._stddev[0])))
            common.validate_format(obj._stddev[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(NetworkLatencyTest, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "average" == "type" or (self.average is not self.__undef__ and (not (dirty and not self._average[1]))):
            dct["average"] = dictify(self.average)
        if "end_time" == "type" or (self.end_time is not self.__undef__ and (not (dirty and not self._end_time[1]))):
            dct["endTime"] = dictify(self.end_time)
        if "loss" == "type" or (self.loss is not self.__undef__ and (not (dirty and not self._loss[1]))):
            dct["loss"] = dictify(self.loss)
        if "maximum" == "type" or (self.maximum is not self.__undef__ and (not (dirty and not self._maximum[1]))):
            dct["maximum"] = dictify(self.maximum)
        if "minimum" == "type" or (self.minimum is not self.__undef__ and (not (dirty and not self._minimum[1]))):
            dct["minimum"] = dictify(self.minimum)
        if "remote_address" == "type" or (self.remote_address is not self.__undef__ and (not (dirty and not self._remote_address[1]))):
            dct["remoteAddress"] = dictify(self.remote_address)
        if "remote_host" == "type" or (self.remote_host is not self.__undef__ and (not (dirty and not self._remote_host[1]))):
            dct["remoteHost"] = dictify(self.remote_host)
        if "request_count" == "type" or (self.request_count is not self.__undef__ and (not (dirty and not self._request_count[1]))):
            dct["requestCount"] = dictify(self.request_count)
        if "request_size" == "type" or (self.request_size is not self.__undef__ and (not (dirty and not self._request_size[1]))):
            dct["requestSize"] = dictify(self.request_size)
        if "start_time" == "type" or (self.start_time is not self.__undef__ and (not (dirty and not self._start_time[1]))):
            dct["startTime"] = dictify(self.start_time)
        if "state" == "type" or (self.state is not self.__undef__ and (not (dirty and not self._state[1]))):
            dct["state"] = dictify(self.state)
        if "stddev" == "type" or (self.stddev is not self.__undef__ and (not (dirty and not self._stddev[1]))):
            dct["stddev"] = dictify(self.stddev)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._average = (self._average[0], True)
        self._end_time = (self._end_time[0], True)
        self._loss = (self._loss[0], True)
        self._maximum = (self._maximum[0], True)
        self._minimum = (self._minimum[0], True)
        self._remote_address = (self._remote_address[0], True)
        self._remote_host = (self._remote_host[0], True)
        self._request_count = (self._request_count[0], True)
        self._request_size = (self._request_size[0], True)
        self._start_time = (self._start_time[0], True)
        self._state = (self._state[0], True)
        self._stddev = (self._stddev[0], True)

    def is_dirty(self):
        return any([self._average[1], self._end_time[1], self._loss[1], self._maximum[1], self._minimum[1], self._remote_address[1], self._remote_host[1], self._request_count[1], self._request_size[1], self._start_time[1], self._state[1], self._stddev[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, NetworkLatencyTest):
            return False
        return super(NetworkLatencyTest, self).__eq__(other) and \
               self.average == other.average and \
               self.end_time == other.end_time and \
               self.loss == other.loss and \
               self.maximum == other.maximum and \
               self.minimum == other.minimum and \
               self.remote_address == other.remote_address and \
               self.remote_host == other.remote_host and \
               self.request_count == other.request_count and \
               self.request_size == other.request_size and \
               self.start_time == other.start_time and \
               self.state == other.state and \
               self.stddev == other.stddev

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def average(self):
        """
        Average measured round-trip time (us).

        :rtype: ``int``
        """
        return self._average[0]

    @average.setter
    def average(self, value):
        self._average = (value, True)

    @property
    def end_time(self):
        """
        Time when the test ended.

        :rtype: ``TEXT_TYPE``
        """
        return self._end_time[0]

    @end_time.setter
    def end_time(self, value):
        self._end_time = (value, True)

    @property
    def loss(self):
        """
        Percentage of requests or replies lost.

        :rtype: ``int``
        """
        return self._loss[0]

    @loss.setter
    def loss(self, value):
        self._loss = (value, True)

    @property
    def maximum(self):
        """
        Maximum measured round-trip time (us).

        :rtype: ``int``
        """
        return self._maximum[0]

    @maximum.setter
    def maximum(self, value):
        self._maximum = (value, True)

    @property
    def minimum(self):
        """
        Minimum measured round-trip time (us).

        :rtype: ``int``
        """
        return self._minimum[0]

    @minimum.setter
    def minimum(self, value):
        self._minimum = (value, True)

    @property
    def remote_address(self):
        """
        The IP address of the remote host used for the latency test.

        :rtype: ``TEXT_TYPE``
        """
        return self._remote_address[0]

    @remote_address.setter
    def remote_address(self, value):
        self._remote_address = (value, True)

    @property
    def remote_host(self):
        """
        The remote environment host used for the latency test.

        :rtype: ``TEXT_TYPE``
        """
        return self._remote_host[0]

    @remote_host.setter
    def remote_host(self, value):
        self._remote_host = (value, True)

    @property
    def request_count(self):
        """
        Number of requests sent (and received).

        :rtype: ``int``
        """
        return self._request_count[0]

    @request_count.setter
    def request_count(self, value):
        self._request_count = (value, True)

    @property
    def request_size(self):
        """
        Size of requests used (bytes).

        :rtype: ``int``
        """
        return self._request_size[0]

    @request_size.setter
    def request_size(self, value):
        self._request_size = (value, True)

    @property
    def start_time(self):
        """
        Time when the test was started.

        :rtype: ``TEXT_TYPE``
        """
        return self._start_time[0]

    @start_time.setter
    def start_time(self, value):
        self._start_time = (value, True)

    @property
    def state(self):
        """
        The state of the test. *(permitted values: RUNNING, COMPLETED, FAILED,
        CANCELED)*

        :rtype: ``TEXT_TYPE``
        """
        return self._state[0]

    @state.setter
    def state(self, value):
        self._state = (value, True)

    @property
    def stddev(self):
        """
        Standard deviation (us).

        :rtype: ``int``
        """
        return self._stddev[0]

    @stddev.setter
    def stddev(self, value):
        self._stddev = (value, True)

