# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-js-bookmark-capacity-data.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_4_0.web.objects.TypedObject import TypedObject
from delphixpy.v1_4_0 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class JSBookmarkCapacityData(TypedObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.TypedObject` *)* The capacity
    information for a Jet Stream bookmark.
    """
    def __init__(self, undef_enabled=True):
        super(JSBookmarkCapacityData, self).__init__()
        self._type = ("JSBookmarkCapacityData", True)
        self._bookmark = (self.__undef__, True)
        self._data_layout = (self.__undef__, True)
        self._referenced_by_bookmarks = (self.__undef__, True)
        self._referenced_by_branches = (self.__undef__, True)
        self._referenced_externally = (self.__undef__, True)
        self._referencing_bookmarks = (self.__undef__, True)
        self._referencing_branches = (self.__undef__, True)
        self._unique = (self.__undef__, True)

    API_VERSION = "1.4.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(JSBookmarkCapacityData, cls).from_dict(data, dirty, undef_enabled)
        obj._bookmark = (data.get("bookmark", obj.__undef__), dirty)
        if obj._bookmark[0] is not None and obj._bookmark[0] is not obj.__undef__:
            assert isinstance(obj._bookmark[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._bookmark[0], type(obj._bookmark[0])))
            common.validate_format(obj._bookmark[0], "objectReference", None, None)
        obj._data_layout = (data.get("dataLayout", obj.__undef__), dirty)
        if obj._data_layout[0] is not None and obj._data_layout[0] is not obj.__undef__:
            assert isinstance(obj._data_layout[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._data_layout[0], type(obj._data_layout[0])))
            common.validate_format(obj._data_layout[0], "None", None, None)
        obj._referenced_by_bookmarks = (data.get("referencedByBookmarks", obj.__undef__), dirty)
        if obj._referenced_by_bookmarks[0] is not None and obj._referenced_by_bookmarks[0] is not obj.__undef__:
            assert isinstance(obj._referenced_by_bookmarks[0], float), ("Expected one of ['number'], but got %s of type %s" % (obj._referenced_by_bookmarks[0], type(obj._referenced_by_bookmarks[0])))
            common.validate_format(obj._referenced_by_bookmarks[0], "None", None, None)
        obj._referenced_by_branches = (data.get("referencedByBranches", obj.__undef__), dirty)
        if obj._referenced_by_branches[0] is not None and obj._referenced_by_branches[0] is not obj.__undef__:
            assert isinstance(obj._referenced_by_branches[0], float), ("Expected one of ['number'], but got %s of type %s" % (obj._referenced_by_branches[0], type(obj._referenced_by_branches[0])))
            common.validate_format(obj._referenced_by_branches[0], "None", None, None)
        obj._referenced_externally = (data.get("referencedExternally", obj.__undef__), dirty)
        if obj._referenced_externally[0] is not None and obj._referenced_externally[0] is not obj.__undef__:
            assert isinstance(obj._referenced_externally[0], float), ("Expected one of ['number'], but got %s of type %s" % (obj._referenced_externally[0], type(obj._referenced_externally[0])))
            common.validate_format(obj._referenced_externally[0], "None", None, None)
        obj._referencing_bookmarks = []
        for item in data.get("referencingBookmarks") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._referencing_bookmarks.append(item)
        obj._referencing_bookmarks = (obj._referencing_bookmarks, dirty)
        obj._referencing_branches = []
        for item in data.get("referencingBranches") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._referencing_branches.append(item)
        obj._referencing_branches = (obj._referencing_branches, dirty)
        obj._unique = (data.get("unique", obj.__undef__), dirty)
        if obj._unique[0] is not None and obj._unique[0] is not obj.__undef__:
            assert isinstance(obj._unique[0], float), ("Expected one of ['number'], but got %s of type %s" % (obj._unique[0], type(obj._unique[0])))
            common.validate_format(obj._unique[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(JSBookmarkCapacityData, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "bookmark" == "type" or (self.bookmark is not self.__undef__ and (not (dirty and not self._bookmark[1]))):
            dct["bookmark"] = dictify(self.bookmark)
        if "data_layout" == "type" or (self.data_layout is not self.__undef__ and (not (dirty and not self._data_layout[1]))):
            dct["dataLayout"] = dictify(self.data_layout)
        if "referenced_by_bookmarks" == "type" or (self.referenced_by_bookmarks is not self.__undef__ and (not (dirty and not self._referenced_by_bookmarks[1]))):
            dct["referencedByBookmarks"] = dictify(self.referenced_by_bookmarks)
        if "referenced_by_branches" == "type" or (self.referenced_by_branches is not self.__undef__ and (not (dirty and not self._referenced_by_branches[1]))):
            dct["referencedByBranches"] = dictify(self.referenced_by_branches)
        if "referenced_externally" == "type" or (self.referenced_externally is not self.__undef__ and (not (dirty and not self._referenced_externally[1]))):
            dct["referencedExternally"] = dictify(self.referenced_externally)
        if "referencing_bookmarks" == "type" or (self.referencing_bookmarks is not self.__undef__ and (not (dirty and not self._referencing_bookmarks[1]))):
            dct["referencingBookmarks"] = dictify(self.referencing_bookmarks)
        if "referencing_branches" == "type" or (self.referencing_branches is not self.__undef__ and (not (dirty and not self._referencing_branches[1]))):
            dct["referencingBranches"] = dictify(self.referencing_branches)
        if "unique" == "type" or (self.unique is not self.__undef__ and (not (dirty and not self._unique[1]))):
            dct["unique"] = dictify(self.unique)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._bookmark = (self._bookmark[0], True)
        self._data_layout = (self._data_layout[0], True)
        self._referenced_by_bookmarks = (self._referenced_by_bookmarks[0], True)
        self._referenced_by_branches = (self._referenced_by_branches[0], True)
        self._referenced_externally = (self._referenced_externally[0], True)
        self._referencing_bookmarks = (self._referencing_bookmarks[0], True)
        self._referencing_branches = (self._referencing_branches[0], True)
        self._unique = (self._unique[0], True)

    def is_dirty(self):
        return any([self._bookmark[1], self._data_layout[1], self._referenced_by_bookmarks[1], self._referenced_by_branches[1], self._referenced_externally[1], self._referencing_bookmarks[1], self._referencing_branches[1], self._unique[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, JSBookmarkCapacityData):
            return False
        return super(JSBookmarkCapacityData, self).__eq__(other) and \
               self.bookmark == other.bookmark and \
               self.data_layout == other.data_layout and \
               self.referenced_by_bookmarks == other.referenced_by_bookmarks and \
               self.referenced_by_branches == other.referenced_by_branches and \
               self.referenced_externally == other.referenced_externally and \
               self.referencing_bookmarks == other.referencing_bookmarks and \
               self.referencing_branches == other.referencing_branches and \
               self.unique == other.unique

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def bookmark(self):
        """
        The Jet Stream bookmark that this capacity information is for.

        :rtype: ``TEXT_TYPE``
        """
        return self._bookmark[0]

    @bookmark.setter
    def bookmark(self, value):
        self._bookmark = (value, True)

    @property
    def data_layout(self):
        """
        The data layout that this bookmark belongs to.

        :rtype: ``TEXT_TYPE``
        """
        return self._data_layout[0]

    @data_layout.setter
    def data_layout(self, value):
        self._data_layout = (value, True)

    @property
    def referenced_by_bookmarks(self):
        """
        The amount of space referenced by this bookmark that cannot be freed up
        by deleting this bookmark because it is being used by neighboring
        bookmarks on the same data layout.

        :rtype: ``float``
        """
        return self._referenced_by_bookmarks[0]

    @referenced_by_bookmarks.setter
    def referenced_by_bookmarks(self, value):
        self._referenced_by_bookmarks = (value, True)

    @property
    def referenced_by_branches(self):
        """
        The amount of space referenced by this bookmark that cannot be freed up
        by deleting this bookmark because it is referenced by branches that
        have been restored to or created from this bookmark.

        :rtype: ``float``
        """
        return self._referenced_by_branches[0]

    @referenced_by_branches.setter
    def referenced_by_branches(self, value):
        self._referenced_by_branches = (value, True)

    @property
    def referenced_externally(self):
        """
        The amount of space referenced by this bookmark that cannot be freed up
        by deleting this bookmark because it is referenced outside of Jet
        Stream or by branches that have been restored to or created from this
        bookmark.

        :rtype: ``float``
        """
        return self._referenced_externally[0]

    @referenced_externally.setter
    def referenced_externally(self, value):
        self._referenced_externally = (value, True)

    @property
    def referencing_bookmarks(self):
        """
        The names of the bookmarks on the same data layout that are referencing
        the same space as this bookmark.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._referencing_bookmarks[0]

    @referencing_bookmarks.setter
    def referencing_bookmarks(self, value):
        self._referencing_bookmarks = (value, True)

    @property
    def referencing_branches(self):
        """
        The names of the branches that were restored or created from this
        bookmark.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._referencing_branches[0]

    @referencing_branches.setter
    def referencing_branches(self, value):
        self._referencing_branches = (value, True)

    @property
    def unique(self):
        """
        The amount of space that will be freed if this bookmark is deleted.

        :rtype: ``float``
        """
        return self._unique[0]

    @unique.setter
    def unique(self, value):
        self._unique = (value, True)

