# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-host-parameters.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_16.web.objects.TypedObject import TypedObject
from delphixpy.v1_11_16 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class OracleHostParameters(TypedObject):
    """
    *(extends* :py:class:`v1_11_16.web.vo.TypedObject` *)* Oracle specific host
    parameters.
    """
    def __init__(self, undef_enabled=True):
        super(OracleHostParameters, self).__init__()
        self._type = ("OracleHostParameters", True)
        self._jdbc_keystore_password = (self.__undef__, True)
        self._tde_keystores_root_path = (self.__undef__, True)

    API_VERSION = "1.11.16"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(OracleHostParameters, cls).from_dict(data, dirty, undef_enabled)
        obj._jdbc_keystore_password = (data.get("jdbcKeystorePassword", obj.__undef__), dirty)
        if obj._jdbc_keystore_password[0] is not None and obj._jdbc_keystore_password[0] is not obj.__undef__:
            assert isinstance(obj._jdbc_keystore_password[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._jdbc_keystore_password[0], type(obj._jdbc_keystore_password[0])))
            common.validate_format(obj._jdbc_keystore_password[0], "password", 1, None)
        obj._tde_keystores_root_path = (data.get("tdeKeystoresRootPath", obj.__undef__), dirty)
        if obj._tde_keystores_root_path[0] is not None and obj._tde_keystores_root_path[0] is not obj.__undef__:
            assert isinstance(obj._tde_keystores_root_path[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._tde_keystores_root_path[0], type(obj._tde_keystores_root_path[0])))
            common.validate_format(obj._tde_keystores_root_path[0], "None", 1, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(OracleHostParameters, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "jdbc_keystore_password" == "type" or (self.jdbc_keystore_password is not self.__undef__ and (not (dirty and not self._jdbc_keystore_password[1]) or isinstance(self.jdbc_keystore_password, list) or belongs_to_parent)):
            dct["jdbcKeystorePassword"] = dictify(self.jdbc_keystore_password)
        if "tde_keystores_root_path" == "type" or (self.tde_keystores_root_path is not self.__undef__ and (not (dirty and not self._tde_keystores_root_path[1]) or isinstance(self.tde_keystores_root_path, list) or belongs_to_parent)):
            dct["tdeKeystoresRootPath"] = dictify(self.tde_keystores_root_path)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._jdbc_keystore_password = (self._jdbc_keystore_password[0], True)
        self._tde_keystores_root_path = (self._tde_keystores_root_path[0], True)

    def is_dirty(self):
        return any([self._jdbc_keystore_password[1], self._tde_keystores_root_path[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleHostParameters):
            return False
        return super(OracleHostParameters, self).__eq__(other) and \
               self.jdbc_keystore_password == other.jdbc_keystore_password and \
               self.tde_keystores_root_path == other.tde_keystores_root_path

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def jdbc_keystore_password(self):
        """
        The password for the user managed Oracle JDBC keystore.

        :rtype: ``TEXT_TYPE``
        """
        return self._jdbc_keystore_password[0]

    @jdbc_keystore_password.setter
    def jdbc_keystore_password(self, value):
        self._jdbc_keystore_password = (value, True)

    @property
    def tde_keystores_root_path(self):
        """
        The path to the root of the Oracle TDE keystores artifact directories.

        :rtype: ``TEXT_TYPE``
        """
        return self._tde_keystores_root_path[0]

    @tde_keystores_root_path.setter
    def tde_keystores_root_path(self, value):
        self._tde_keystores_root_path = (value, True)

