# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-base-staging-link-data.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_15.web.objects.OracleBaseLinkData import OracleBaseLinkData
from delphixpy.v1_11_15 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class OracleBaseStagingLinkData(OracleBaseLinkData):
    """
    *(extends* :py:class:`v1_11_15.web.vo.OracleBaseLinkData` *)* Represents
    common parameters to link an Oracle database using a staging database.
    """
    def __init__(self, undef_enabled=True):
        super(OracleBaseStagingLinkData, self).__init__()
        self._type = ("OracleBaseStagingLinkData", True)
        self._allow_auto_staging_restart_on_host_reboot = (self.__undef__, True)

    API_VERSION = "1.11.15"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(OracleBaseStagingLinkData, cls).from_dict(data, dirty, undef_enabled)
        obj._allow_auto_staging_restart_on_host_reboot = (data.get("allowAutoStagingRestartOnHostReboot", obj.__undef__), dirty)
        if obj._allow_auto_staging_restart_on_host_reboot[0] is not None and obj._allow_auto_staging_restart_on_host_reboot[0] is not obj.__undef__:
            assert isinstance(obj._allow_auto_staging_restart_on_host_reboot[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._allow_auto_staging_restart_on_host_reboot[0], type(obj._allow_auto_staging_restart_on_host_reboot[0])))
            common.validate_format(obj._allow_auto_staging_restart_on_host_reboot[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(OracleBaseStagingLinkData, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "allow_auto_staging_restart_on_host_reboot" == "type" or (self.allow_auto_staging_restart_on_host_reboot is not self.__undef__ and (not (dirty and not self._allow_auto_staging_restart_on_host_reboot[1]) or isinstance(self.allow_auto_staging_restart_on_host_reboot, list) or belongs_to_parent)):
            dct["allowAutoStagingRestartOnHostReboot"] = dictify(self.allow_auto_staging_restart_on_host_reboot)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._allow_auto_staging_restart_on_host_reboot = (self._allow_auto_staging_restart_on_host_reboot[0], True)

    def is_dirty(self):
        return any([self._allow_auto_staging_restart_on_host_reboot[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleBaseStagingLinkData):
            return False
        return super(OracleBaseStagingLinkData, self).__eq__(other) and \
               self.allow_auto_staging_restart_on_host_reboot == other.allow_auto_staging_restart_on_host_reboot

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def allow_auto_staging_restart_on_host_reboot(self):
        """
        Indicates whether Delphix should automatically restart this staging
        database when staging host reboot is detected.

        :rtype: ``bool``
        """
        return self._allow_auto_staging_restart_on_host_reboot[0]

    @allow_auto_staging_restart_on_host_reboot.setter
    def allow_auto_staging_restart_on_host_reboot(self, value):
        self._allow_auto_staging_restart_on_host_reboot = (value, True)

