# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudfrontWebAcl <a name="CloudfrontWebAcl" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl"></a>

This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the region of the parent cdk stack.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer"></a>

```typescript
import { CloudfrontWebAcl } from '@aws-prototyping-sdk/static-website'

new CloudfrontWebAcl(scope: Construct, id: string, props?: CloudFrontWebAclProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct"></a>

```typescript
import { CloudfrontWebAcl } from '@aws-prototyping-sdk/static-website'

CloudfrontWebAcl.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn">webAclArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId">webAclId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `webAclArn`<sup>Required</sup> <a name="webAclArn" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn"></a>

```typescript
public readonly webAclArn: string;
```

- *Type:* string

---

##### `webAclId`<sup>Required</sup> <a name="webAclId" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId"></a>

```typescript
public readonly webAclId: string;
```

- *Type:* string

---


### StaticWebsite <a name="StaticWebsite" id="@aws-prototyping-sdk/static-website.StaticWebsite"></a>

Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.

This construct configures a webAcl containing rules that are generally applicable to web applications. This
provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer"></a>

```typescript
import { StaticWebsite } from '@aws-prototyping-sdk/static-website'

new StaticWebsite(scope: Construct, id: string, props: StaticWebsiteProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps">StaticWebsiteProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps">StaticWebsiteProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/static-website.StaticWebsite.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct"></a>

```typescript
import { StaticWebsite } from '@aws-prototyping-sdk/static-website'

StaticWebsite.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment">bucketDeployment</a></code> | <code>aws-cdk-lib.aws_s3_deployment.BucketDeployment</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution">cloudFrontDistribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket">websiteBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `bucketDeployment`<sup>Required</sup> <a name="bucketDeployment" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment"></a>

```typescript
public readonly bucketDeployment: BucketDeployment;
```

- *Type:* aws-cdk-lib.aws_s3_deployment.BucketDeployment

---

##### `cloudFrontDistribution`<sup>Required</sup> <a name="cloudFrontDistribution" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution"></a>

```typescript
public readonly cloudFrontDistribution: Distribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.Distribution

---

##### `websiteBucket`<sup>Required</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket"></a>

```typescript
public readonly websiteBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---


## Structs <a name="Structs" id="Structs"></a>

### BucketDeploymentProps <a name="BucketDeploymentProps" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps"></a>

Bucket Deployment props.

NOTE: forked from aws-cdk-lib/s3-deployment without any required props.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.Initializer"></a>

```typescript
import { BucketDeploymentProps } from '@aws-prototyping-sdk/static-website'

const bucketDeploymentProps: BucketDeploymentProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.accessControl">accessControl</a></code> | <code>aws-cdk-lib.aws_s3.BucketAccessControl</code> | System-defined x-amz-acl metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.cacheControl">cacheControl</a></code> | <code>aws-cdk-lib.aws_s3_deployment.CacheControl[]</code> | System-defined cache-control metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentDisposition">contentDisposition</a></code> | <code>string</code> | System-defined cache-disposition metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentEncoding">contentEncoding</a></code> | <code>string</code> | System-defined content-encoding metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentLanguage">contentLanguage</a></code> | <code>string</code> | System-defined content-language metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentType">contentType</a></code> | <code>string</code> | System-defined content-type metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.destinationKeyPrefix">destinationKeyPrefix</a></code> | <code>string</code> | Key prefix in the destination bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distribution">distribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.IDistribution</code> | The CloudFront distribution using the destination bucket as an origin. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distributionPaths">distributionPaths</a></code> | <code>string[]</code> | The file paths to invalidate in the CloudFront distribution. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.ephemeralStorageSize">ephemeralStorageSize</a></code> | <code>aws-cdk-lib.Size</code> | The size of the AWS Lambda function’s /tmp directory in MiB. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.exclude">exclude</a></code> | <code>string[]</code> | If this is set, matching files or objects will be excluded from the deployment's sync command. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.expires">expires</a></code> | <code>aws-cdk-lib.Expiration</code> | System-defined expires metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.extract">extract</a></code> | <code>boolean</code> | If this is set, the zip file will be synced to the destination S3 bucket and extracted. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.include">include</a></code> | <code>string[]</code> | If this is set, matching files or objects will be included with the deployment's sync command. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.logRetention">logRetention</a></code> | <code>aws-cdk-lib.aws_logs.RetentionDays</code> | The number of days that the lambda function's log events are kept in CloudWatch Logs. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.memoryLimit">memoryLimit</a></code> | <code>number</code> | The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.metadata">metadata</a></code> | <code>{[ key: string ]: string}</code> | User-defined object metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.prune">prune</a></code> | <code>boolean</code> | If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update). |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.retainOnDelete">retainOnDelete</a></code> | <code>boolean</code> | If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | Execution role associated with this function. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryption">serverSideEncryption</a></code> | <code>aws-cdk-lib.aws_s3_deployment.ServerSideEncryption</code> | System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionAwsKmsKeyId">serverSideEncryptionAwsKmsKeyId</a></code> | <code>string</code> | System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionCustomerAlgorithm">serverSideEncryptionCustomerAlgorithm</a></code> | <code>string</code> | System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.signContent">signContent</a></code> | <code>boolean</code> | If set to true, uploads will precompute the value of `x-amz-content-sha256` and include it in the signed S3 request headers. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.storageClass">storageClass</a></code> | <code>aws-cdk-lib.aws_s3_deployment.StorageClass</code> | System-defined x-amz-storage-class metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.useEfs">useEfs</a></code> | <code>boolean</code> | Mount an EFS file system. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | The VPC network to place the deployment lambda handler in. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpcSubnets">vpcSubnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | Where in the VPC to place the deployment lambda handler. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.websiteRedirectLocation">websiteRedirectLocation</a></code> | <code>string</code> | System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment. |

---

##### `accessControl`<sup>Optional</sup> <a name="accessControl" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.accessControl"></a>

```typescript
public readonly accessControl: BucketAccessControl;
```

- *Type:* aws-cdk-lib.aws_s3.BucketAccessControl
- *Default:* Not set.

System-defined x-amz-acl metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl)

---

##### `cacheControl`<sup>Optional</sup> <a name="cacheControl" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.cacheControl"></a>

```typescript
public readonly cacheControl: CacheControl[];
```

- *Type:* aws-cdk-lib.aws_s3_deployment.CacheControl[]
- *Default:* Not set.

System-defined cache-control metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `contentDisposition`<sup>Optional</sup> <a name="contentDisposition" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentDisposition"></a>

```typescript
public readonly contentDisposition: string;
```

- *Type:* string
- *Default:* Not set.

System-defined cache-disposition metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `contentEncoding`<sup>Optional</sup> <a name="contentEncoding" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentEncoding"></a>

```typescript
public readonly contentEncoding: string;
```

- *Type:* string
- *Default:* Not set.

System-defined content-encoding metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `contentLanguage`<sup>Optional</sup> <a name="contentLanguage" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentLanguage"></a>

```typescript
public readonly contentLanguage: string;
```

- *Type:* string
- *Default:* Not set.

System-defined content-language metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `contentType`<sup>Optional</sup> <a name="contentType" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentType"></a>

```typescript
public readonly contentType: string;
```

- *Type:* string
- *Default:* Not set.

System-defined content-type metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `destinationKeyPrefix`<sup>Optional</sup> <a name="destinationKeyPrefix" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.destinationKeyPrefix"></a>

```typescript
public readonly destinationKeyPrefix: string;
```

- *Type:* string
- *Default:* "/" (unzip to root of the destination bucket)

Key prefix in the destination bucket.

Must be <=104 characters

---

##### `distribution`<sup>Optional</sup> <a name="distribution" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distribution"></a>

```typescript
public readonly distribution: IDistribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IDistribution
- *Default:* No invalidation occurs

The CloudFront distribution using the destination bucket as an origin.

Files in the distribution's edge caches will be invalidated after
files are uploaded to the destination bucket.

---

##### `distributionPaths`<sup>Optional</sup> <a name="distributionPaths" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distributionPaths"></a>

```typescript
public readonly distributionPaths: string[];
```

- *Type:* string[]
- *Default:* All files under the destination bucket key prefix will be invalidated.

The file paths to invalidate in the CloudFront distribution.

---

##### `ephemeralStorageSize`<sup>Optional</sup> <a name="ephemeralStorageSize" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.ephemeralStorageSize"></a>

```typescript
public readonly ephemeralStorageSize: Size;
```

- *Type:* aws-cdk-lib.Size
- *Default:* 512 MiB

The size of the AWS Lambda function’s /tmp directory in MiB.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.exclude"></a>

```typescript
public readonly exclude: string[];
```

- *Type:* string[]
- *Default:* No exclude filters are used

If this is set, matching files or objects will be excluded from the deployment's sync command.

This can be used to exclude a file from being pruned in the destination bucket.

If you want to just exclude files from the deployment package (which excludes these files
evaluated when invalidating the asset), you should leverage the `exclude` property of
`AssetOptions` when defining your source.

> [https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters](https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters)

---

##### `expires`<sup>Optional</sup> <a name="expires" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.expires"></a>

```typescript
public readonly expires: Expiration;
```

- *Type:* aws-cdk-lib.Expiration
- *Default:* The objects in the distribution will not expire.

System-defined expires metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `extract`<sup>Optional</sup> <a name="extract" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.extract"></a>

```typescript
public readonly extract: boolean;
```

- *Type:* boolean
- *Default:* true

If this is set, the zip file will be synced to the destination S3 bucket and extracted.

If false, the file will remain zipped in the destination bucket.

---

##### `include`<sup>Optional</sup> <a name="include" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.include"></a>

```typescript
public readonly include: string[];
```

- *Type:* string[]
- *Default:* No include filters are used and all files are included with the sync command

If this is set, matching files or objects will be included with the deployment's sync command.

Since all files from the deployment package are included by default, this property
is usually leveraged alongside an `exclude` filter.

> [https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters](https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters)

---

##### `logRetention`<sup>Optional</sup> <a name="logRetention" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.logRetention"></a>

```typescript
public readonly logRetention: RetentionDays;
```

- *Type:* aws-cdk-lib.aws_logs.RetentionDays
- *Default:* logs.RetentionDays.INFINITE

The number of days that the lambda function's log events are kept in CloudWatch Logs.

---

##### `memoryLimit`<sup>Optional</sup> <a name="memoryLimit" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.memoryLimit"></a>

```typescript
public readonly memoryLimit: number;
```

- *Type:* number
- *Default:* 128

The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.

If you are deploying large files, you will need to increase this number
accordingly.

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.metadata"></a>

```typescript
public readonly metadata: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* No user metadata is set

User-defined object metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata)

---

##### `prune`<sup>Optional</sup> <a name="prune" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.prune"></a>

```typescript
public readonly prune: boolean;
```

- *Type:* boolean
- *Default:* true

If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).

> [https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html](https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html)

---

##### `retainOnDelete`<sup>Optional</sup> <a name="retainOnDelete" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.retainOnDelete"></a>

```typescript
public readonly retainOnDelete: boolean;
```

- *Type:* boolean
- *Default:* true - when resource is deleted/updated, files are retained

If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.

NOTICE: Configuring this to "false" might have operational implications. Please
visit to the package documentation referred below to make sure you fully understand those implications.

> [https://github.com/aws/aws-cdk/tree/main/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete](https://github.com/aws/aws-cdk/tree/main/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete)

---

##### `role`<sup>Optional</sup> <a name="role" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole
- *Default:* A role is automatically created

Execution role associated with this function.

---

##### `serverSideEncryption`<sup>Optional</sup> <a name="serverSideEncryption" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryption"></a>

```typescript
public readonly serverSideEncryption: ServerSideEncryption;
```

- *Type:* aws-cdk-lib.aws_s3_deployment.ServerSideEncryption
- *Default:* Server side encryption is not used.

System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `serverSideEncryptionAwsKmsKeyId`<sup>Optional</sup> <a name="serverSideEncryptionAwsKmsKeyId" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionAwsKmsKeyId"></a>

```typescript
public readonly serverSideEncryptionAwsKmsKeyId: string;
```

- *Type:* string
- *Default:* Not set.

System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `serverSideEncryptionCustomerAlgorithm`<sup>Optional</sup> <a name="serverSideEncryptionCustomerAlgorithm" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionCustomerAlgorithm"></a>

```typescript
public readonly serverSideEncryptionCustomerAlgorithm: string;
```

- *Type:* string
- *Default:* Not set.

System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.

Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro)

---

##### `signContent`<sup>Optional</sup> <a name="signContent" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.signContent"></a>

```typescript
public readonly signContent: boolean;
```

- *Type:* boolean
- *Default:* `x-amz-content-sha256` will not be computed

If set to true, uploads will precompute the value of `x-amz-content-sha256` and include it in the signed S3 request headers.

---

##### `storageClass`<sup>Optional</sup> <a name="storageClass" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.storageClass"></a>

```typescript
public readonly storageClass: StorageClass;
```

- *Type:* aws-cdk-lib.aws_s3_deployment.StorageClass
- *Default:* Default storage-class for the bucket is used.

System-defined x-amz-storage-class metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `useEfs`<sup>Optional</sup> <a name="useEfs" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.useEfs"></a>

```typescript
public readonly useEfs: boolean;
```

- *Type:* boolean
- *Default:* No EFS. Lambda has access only to 512MB of disk space.

Mount an EFS file system.

Enable this if your assets are large and you encounter disk space errors.
Enabling this option will require a VPC to be specified.

---

##### `vpc`<sup>Optional</sup> <a name="vpc" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc
- *Default:* None

The VPC network to place the deployment lambda handler in.

This is required if `useEfs` is set.

---

##### `vpcSubnets`<sup>Optional</sup> <a name="vpcSubnets" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpcSubnets"></a>

```typescript
public readonly vpcSubnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection
- *Default:* the Vpc default strategy if not specified

Where in the VPC to place the deployment lambda handler.

Only used if 'vpc' is supplied.

---

##### `websiteRedirectLocation`<sup>Optional</sup> <a name="websiteRedirectLocation" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.websiteRedirectLocation"></a>

```typescript
public readonly websiteRedirectLocation: string;
```

- *Type:* string
- *Default:* No website redirection.

System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/static-website.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CidrAllowList.Initializer"></a>

```typescript
import { CidrAllowList } from '@aws-prototyping-sdk/static-website'

const cidrAllowList: CidrAllowList = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges">cidrRanges</a></code> | <code>string[]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType">cidrType</a></code> | <code>string</code> | Type of CIDR range. |

---

##### `cidrRanges`<sup>Required</sup> <a name="cidrRanges" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges"></a>

```typescript
public readonly cidrRanges: string[];
```

- *Type:* string[]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidrType`<sup>Required</sup> <a name="cidrType" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType"></a>

```typescript
public readonly cidrType: string;
```

- *Type:* string

Type of CIDR range.

---

### CloudFrontWebAclProps <a name="CloudFrontWebAclProps" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps"></a>

Properties to configure the web acl.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.Initializer"></a>

```typescript
import { CloudFrontWebAclProps } from '@aws-prototyping-sdk/static-website'

const cloudFrontWebAclProps: CloudFrontWebAclProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.disable">disable</a></code> | <code>boolean</code> | Set to true to prevent creation of a web acl for the static website. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules">managedRules</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>[]</code> | List of managed rules to apply to the web acl. |

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList"></a>

```typescript
public readonly cidrAllowList: CidrAllowList;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.disable"></a>

```typescript
public readonly disable: boolean;
```

- *Type:* boolean
- *Default:* false

Set to true to prevent creation of a web acl for the static website.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules"></a>

```typescript
public readonly managedRules: ManagedRule[];
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>[]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/static-website.ManagedRule"></a>

Represents a WAF V2 managed rule.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.ManagedRule.Initializer"></a>

```typescript
import { ManagedRule } from '@aws-prototyping-sdk/static-website'

const managedRule: ManagedRule = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.name">name</a></code> | <code>string</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.vendor">vendor</a></code> | <code>string</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/static-website.ManagedRule.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/static-website.ManagedRule.property.vendor"></a>

```typescript
public readonly vendor: string;
```

- *Type:* string

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### RuntimeOptions <a name="RuntimeOptions" id="@aws-prototyping-sdk/static-website.RuntimeOptions"></a>

Dynamic configuration which gets resolved only during deployment.

*Example*

```typescript
// Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
// and all resolved values.
const runtimeConfig = {jsonPayload: {bucketArn: s3Bucket.bucketArn}};
new StaticWebsite(scope, 'StaticWebsite', {websiteContentPath: 'path/to/website', runtimeConfig});
```


#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.RuntimeOptions.Initializer"></a>

```typescript
import { RuntimeOptions } from '@aws-prototyping-sdk/static-website'

const runtimeOptions: RuntimeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload">jsonPayload</a></code> | <code>any</code> | Arbitrary JSON payload containing runtime values to deploy. |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName">jsonFileName</a></code> | <code>string</code> | File name to store runtime configuration (jsonPayload). |

---

##### `jsonPayload`<sup>Required</sup> <a name="jsonPayload" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload"></a>

```typescript
public readonly jsonPayload: any;
```

- *Type:* any

Arbitrary JSON payload containing runtime values to deploy.

Typically this contains resourceArns, etc which
are only known at deploy time.

---

*Example*

```typescript
{ userPoolId: some.userPool.userPoolId, someResourceArn: some.resource.Arn }
```


##### `jsonFileName`<sup>Optional</sup> <a name="jsonFileName" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName"></a>

```typescript
public readonly jsonFileName: string;
```

- *Type:* string
- *Default:* "runtime-config.json"

File name to store runtime configuration (jsonPayload).

Must follow pattern: '*.json'

---

### StaticWebsiteProps <a name="StaticWebsiteProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps"></a>

Properties for configuring the StaticWebsite.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.Initializer"></a>

```typescript
import { StaticWebsiteProps } from '@aws-prototyping-sdk/static-website'

const staticWebsiteProps: StaticWebsiteProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath">websiteContentPath</a></code> | <code>string</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.bucketDeploymentProps">bucketDeploymentProps</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a></code> | Custom bucket deployment properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption">defaultWebsiteBucketEncryption</a></code> | <code>aws-cdk-lib.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey">defaultWebsiteBucketEncryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps">distributionProps</a></code> | <code>aws-cdk-lib.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions">runtimeOptions</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps">webAclProps</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket">websiteBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `websiteContentPath`<sup>Required</sup> <a name="websiteContentPath" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath"></a>

```typescript
public readonly websiteContentPath: string;
```

- *Type:* string

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `bucketDeploymentProps`<sup>Optional</sup> <a name="bucketDeploymentProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.bucketDeploymentProps"></a>

```typescript
public readonly bucketDeploymentProps: BucketDeploymentProps;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a>

Custom bucket deployment properties.

```

---

##### `defaultWebsiteBucketEncryption`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryption" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption"></a>

```typescript
public readonly defaultWebsiteBucketEncryption: BucketEncryption;
```

- *Type:* aws-cdk-lib.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `defaultWebsiteBucketEncryptionKey`<sup>Optional</sup> <a name="defaultWebsiteBucketEncryptionKey" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey"></a>

```typescript
public readonly defaultWebsiteBucketEncryptionKey: Key;
```

- *Type:* aws-cdk-lib.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distributionProps`<sup>Optional</sup> <a name="distributionProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps"></a>

```typescript
public readonly distributionProps: DistributionProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtimeOptions`<sup>Optional</sup> <a name="runtimeOptions" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions"></a>

```typescript
public readonly runtimeOptions: RuntimeOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `webAclProps`<sup>Optional</sup> <a name="webAclProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps"></a>

```typescript
public readonly webAclProps: CloudFrontWebAclProps;
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `websiteBucket`<sup>Optional</sup> <a name="websiteBucket" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket"></a>

```typescript
public readonly websiteBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

## Classes <a name="Classes" id="Classes"></a>

### StaticWebsiteOrigin <a name="StaticWebsiteOrigin" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin"></a>

- *Implements:* aws-cdk-lib.aws_cloudfront.IOrigin

If passing in distributionProps, the default behaviour.origin is a required parameter. An instance of this class can be passed in to make the compiler happy.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.Initializer"></a>

```typescript
import { StaticWebsiteOrigin } from '@aws-prototyping-sdk/static-website'

new StaticWebsiteOrigin()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind">bind</a></code> | The method called when a given Origin is added (for the first time) to a Distribution. |

---

##### `bind` <a name="bind" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind"></a>

```typescript
public bind(_scope: Construct, _options: OriginBindOptions): OriginBindConfig
```

The method called when a given Origin is added (for the first time) to a Distribution.

###### `_scope`<sup>Required</sup> <a name="_scope" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._scope"></a>

- *Type:* constructs.Construct

---

###### `_options`<sup>Required</sup> <a name="_options" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_cloudfront.OriginBindOptions

---





