# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### CloudfrontWebAcl <a name="CloudfrontWebAcl" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl"></a>

This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the region of the parent cdk stack.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudfrontWebAcl(
  scope: Construct,
  id: str,
  cidr_allow_list: CidrAllowList = None,
  disable: bool = None,
  managed_rules: typing.List[ManagedRule] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList">cidr_allow_list</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.disable">disable</a></code> | <code>bool</code> | Set to true to prevent creation of a web acl for the static website. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules">managed_rules</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]</code> | List of managed rules to apply to the web acl. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.id"></a>

- *Type:* str

---

##### `cidr_allow_list`<sup>Optional</sup> <a name="cidr_allow_list" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.cidrAllowList"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.disable"></a>

- *Type:* bool
- *Default:* false

Set to true to prevent creation of a web acl for the static website.

---

##### `managed_rules`<sup>Optional</sup> <a name="managed_rules" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.Initializer.parameter.managedRules"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudfrontWebAcl.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn">web_acl_arn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId">web_acl_id</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `web_acl_arn`<sup>Required</sup> <a name="web_acl_arn" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclArn"></a>

```python
web_acl_arn: str
```

- *Type:* str

---

##### `web_acl_id`<sup>Required</sup> <a name="web_acl_id" id="@aws-prototyping-sdk/static-website.CloudfrontWebAcl.property.webAclId"></a>

```python
web_acl_id: str
```

- *Type:* str

---


### StaticWebsite <a name="StaticWebsite" id="@aws-prototyping-sdk/static-website.StaticWebsite"></a>

Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.

This construct configures a webAcl containing rules that are generally applicable to web applications. This
provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsite(
  scope: Construct,
  id: str,
  website_content_path: str,
  bucket_deployment_props: BucketDeploymentProps = None,
  default_website_bucket_encryption: BucketEncryption = None,
  default_website_bucket_encryption_key: Key = None,
  distribution_props: DistributionProps = None,
  runtime_options: RuntimeOptions = None,
  web_acl_props: CloudFrontWebAclProps = None,
  website_bucket: IBucket = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath">website_content_path</a></code> | <code>str</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.bucketDeploymentProps">bucket_deployment_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a></code> | Custom bucket deployment properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption">default_website_bucket_encryption</a></code> | <code>aws_cdk.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey">default_website_bucket_encryption_key</a></code> | <code>aws_cdk.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps">distribution_props</a></code> | <code>aws_cdk.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions">runtime_options</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps">web_acl_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.id"></a>

- *Type:* str

---

##### `website_content_path`<sup>Required</sup> <a name="website_content_path" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteContentPath"></a>

- *Type:* str

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `bucket_deployment_props`<sup>Optional</sup> <a name="bucket_deployment_props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.bucketDeploymentProps"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a>

Custom bucket deployment properties.

```
```

---

##### `default_website_bucket_encryption`<sup>Optional</sup> <a name="default_website_bucket_encryption" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryption"></a>

- *Type:* aws_cdk.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `default_website_bucket_encryption_key`<sup>Optional</sup> <a name="default_website_bucket_encryption_key" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.defaultWebsiteBucketEncryptionKey"></a>

- *Type:* aws_cdk.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distribution_props`<sup>Optional</sup> <a name="distribution_props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.distributionProps"></a>

- *Type:* aws_cdk.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtime_options`<sup>Optional</sup> <a name="runtime_options" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.runtimeOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `web_acl_props`<sup>Optional</sup> <a name="web_acl_props" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.webAclProps"></a>

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `website_bucket`<sup>Optional</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.Initializer.parameter.websiteBucket"></a>

- *Type:* aws_cdk.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/static-website.StaticWebsite.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsite.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/static-website.StaticWebsite.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment">bucket_deployment</a></code> | <code>aws_cdk.aws_s3_deployment.BucketDeployment</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution">cloud_front_distribution</a></code> | <code>aws_cdk.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `bucket_deployment`<sup>Required</sup> <a name="bucket_deployment" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.bucketDeployment"></a>

```python
bucket_deployment: BucketDeployment
```

- *Type:* aws_cdk.aws_s3_deployment.BucketDeployment

---

##### `cloud_front_distribution`<sup>Required</sup> <a name="cloud_front_distribution" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.cloudFrontDistribution"></a>

```python
cloud_front_distribution: Distribution
```

- *Type:* aws_cdk.aws_cloudfront.Distribution

---

##### `website_bucket`<sup>Required</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsite.property.websiteBucket"></a>

```python
website_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---


## Structs <a name="Structs" id="Structs"></a>

### BucketDeploymentProps <a name="BucketDeploymentProps" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps"></a>

Bucket Deployment props.

NOTE: forked from aws-cdk-lib/s3-deployment without any required props.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.BucketDeploymentProps(
  access_control: BucketAccessControl = None,
  cache_control: typing.List[CacheControl] = None,
  content_disposition: str = None,
  content_encoding: str = None,
  content_language: str = None,
  content_type: str = None,
  destination_key_prefix: str = None,
  distribution: IDistribution = None,
  distribution_paths: typing.List[str] = None,
  ephemeral_storage_size: Size = None,
  exclude: typing.List[str] = None,
  expires: Expiration = None,
  extract: bool = None,
  include: typing.List[str] = None,
  log_retention: RetentionDays = None,
  memory_limit: typing.Union[int, float] = None,
  metadata: typing.Mapping[str] = None,
  prune: bool = None,
  retain_on_delete: bool = None,
  role: IRole = None,
  server_side_encryption: ServerSideEncryption = None,
  server_side_encryption_aws_kms_key_id: str = None,
  server_side_encryption_customer_algorithm: str = None,
  sign_content: bool = None,
  storage_class: StorageClass = None,
  use_efs: bool = None,
  vpc: IVpc = None,
  vpc_subnets: SubnetSelection = None,
  website_redirect_location: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.accessControl">access_control</a></code> | <code>aws_cdk.aws_s3.BucketAccessControl</code> | System-defined x-amz-acl metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.cacheControl">cache_control</a></code> | <code>typing.List[aws_cdk.aws_s3_deployment.CacheControl]</code> | System-defined cache-control metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentDisposition">content_disposition</a></code> | <code>str</code> | System-defined cache-disposition metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentEncoding">content_encoding</a></code> | <code>str</code> | System-defined content-encoding metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentLanguage">content_language</a></code> | <code>str</code> | System-defined content-language metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentType">content_type</a></code> | <code>str</code> | System-defined content-type metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.destinationKeyPrefix">destination_key_prefix</a></code> | <code>str</code> | Key prefix in the destination bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distribution">distribution</a></code> | <code>aws_cdk.aws_cloudfront.IDistribution</code> | The CloudFront distribution using the destination bucket as an origin. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distributionPaths">distribution_paths</a></code> | <code>typing.List[str]</code> | The file paths to invalidate in the CloudFront distribution. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.ephemeralStorageSize">ephemeral_storage_size</a></code> | <code>aws_cdk.Size</code> | The size of the AWS Lambda function’s /tmp directory in MiB. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.exclude">exclude</a></code> | <code>typing.List[str]</code> | If this is set, matching files or objects will be excluded from the deployment's sync command. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.expires">expires</a></code> | <code>aws_cdk.Expiration</code> | System-defined expires metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.extract">extract</a></code> | <code>bool</code> | If this is set, the zip file will be synced to the destination S3 bucket and extracted. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.include">include</a></code> | <code>typing.List[str]</code> | If this is set, matching files or objects will be included with the deployment's sync command. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.logRetention">log_retention</a></code> | <code>aws_cdk.aws_logs.RetentionDays</code> | The number of days that the lambda function's log events are kept in CloudWatch Logs. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.metadata">metadata</a></code> | <code>typing.Mapping[str]</code> | User-defined object metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.prune">prune</a></code> | <code>bool</code> | If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update). |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.retainOnDelete">retain_on_delete</a></code> | <code>bool</code> | If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.role">role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Execution role associated with this function. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryption">server_side_encryption</a></code> | <code>aws_cdk.aws_s3_deployment.ServerSideEncryption</code> | System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionAwsKmsKeyId">server_side_encryption_aws_kms_key_id</a></code> | <code>str</code> | System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionCustomerAlgorithm">server_side_encryption_customer_algorithm</a></code> | <code>str</code> | System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.signContent">sign_content</a></code> | <code>bool</code> | If set to true, uploads will precompute the value of `x-amz-content-sha256` and include it in the signed S3 request headers. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.storageClass">storage_class</a></code> | <code>aws_cdk.aws_s3_deployment.StorageClass</code> | System-defined x-amz-storage-class metadata to be set on all objects in the deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.useEfs">use_efs</a></code> | <code>bool</code> | Mount an EFS file system. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | The VPC network to place the deployment lambda handler in. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpcSubnets">vpc_subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Where in the VPC to place the deployment lambda handler. |
| <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.websiteRedirectLocation">website_redirect_location</a></code> | <code>str</code> | System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment. |

---

##### `access_control`<sup>Optional</sup> <a name="access_control" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.accessControl"></a>

```python
access_control: BucketAccessControl
```

- *Type:* aws_cdk.aws_s3.BucketAccessControl
- *Default:* Not set.

System-defined x-amz-acl metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl)

---

##### `cache_control`<sup>Optional</sup> <a name="cache_control" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.cacheControl"></a>

```python
cache_control: typing.List[CacheControl]
```

- *Type:* typing.List[aws_cdk.aws_s3_deployment.CacheControl]
- *Default:* Not set.

System-defined cache-control metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `content_disposition`<sup>Optional</sup> <a name="content_disposition" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentDisposition"></a>

```python
content_disposition: str
```

- *Type:* str
- *Default:* Not set.

System-defined cache-disposition metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `content_encoding`<sup>Optional</sup> <a name="content_encoding" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentEncoding"></a>

```python
content_encoding: str
```

- *Type:* str
- *Default:* Not set.

System-defined content-encoding metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `content_language`<sup>Optional</sup> <a name="content_language" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentLanguage"></a>

```python
content_language: str
```

- *Type:* str
- *Default:* Not set.

System-defined content-language metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `content_type`<sup>Optional</sup> <a name="content_type" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.contentType"></a>

```python
content_type: str
```

- *Type:* str
- *Default:* Not set.

System-defined content-type metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `destination_key_prefix`<sup>Optional</sup> <a name="destination_key_prefix" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.destinationKeyPrefix"></a>

```python
destination_key_prefix: str
```

- *Type:* str
- *Default:* "/" (unzip to root of the destination bucket)

Key prefix in the destination bucket.

Must be <=104 characters

---

##### `distribution`<sup>Optional</sup> <a name="distribution" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distribution"></a>

```python
distribution: IDistribution
```

- *Type:* aws_cdk.aws_cloudfront.IDistribution
- *Default:* No invalidation occurs

The CloudFront distribution using the destination bucket as an origin.

Files in the distribution's edge caches will be invalidated after
files are uploaded to the destination bucket.

---

##### `distribution_paths`<sup>Optional</sup> <a name="distribution_paths" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.distributionPaths"></a>

```python
distribution_paths: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* All files under the destination bucket key prefix will be invalidated.

The file paths to invalidate in the CloudFront distribution.

---

##### `ephemeral_storage_size`<sup>Optional</sup> <a name="ephemeral_storage_size" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.ephemeralStorageSize"></a>

```python
ephemeral_storage_size: Size
```

- *Type:* aws_cdk.Size
- *Default:* 512 MiB

The size of the AWS Lambda function’s /tmp directory in MiB.

---

##### `exclude`<sup>Optional</sup> <a name="exclude" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.exclude"></a>

```python
exclude: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* No exclude filters are used

If this is set, matching files or objects will be excluded from the deployment's sync command.

This can be used to exclude a file from being pruned in the destination bucket.

If you want to just exclude files from the deployment package (which excludes these files
evaluated when invalidating the asset), you should leverage the `exclude` property of
`AssetOptions` when defining your source.

> [https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters](https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters)

---

##### `expires`<sup>Optional</sup> <a name="expires" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.expires"></a>

```python
expires: Expiration
```

- *Type:* aws_cdk.Expiration
- *Default:* The objects in the distribution will not expire.

System-defined expires metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `extract`<sup>Optional</sup> <a name="extract" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.extract"></a>

```python
extract: bool
```

- *Type:* bool
- *Default:* true

If this is set, the zip file will be synced to the destination S3 bucket and extracted.

If false, the file will remain zipped in the destination bucket.

---

##### `include`<sup>Optional</sup> <a name="include" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.include"></a>

```python
include: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* No include filters are used and all files are included with the sync command

If this is set, matching files or objects will be included with the deployment's sync command.

Since all files from the deployment package are included by default, this property
is usually leveraged alongside an `exclude` filter.

> [https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters](https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters)

---

##### `log_retention`<sup>Optional</sup> <a name="log_retention" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.logRetention"></a>

```python
log_retention: RetentionDays
```

- *Type:* aws_cdk.aws_logs.RetentionDays
- *Default:* logs.RetentionDays.INFINITE

The number of days that the lambda function's log events are kept in CloudWatch Logs.

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 128

The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.

If you are deploying large files, you will need to increase this number
accordingly.

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.metadata"></a>

```python
metadata: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* No user metadata is set

User-defined object metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata)

---

##### `prune`<sup>Optional</sup> <a name="prune" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.prune"></a>

```python
prune: bool
```

- *Type:* bool
- *Default:* true

If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).

> [https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html](https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html)

---

##### `retain_on_delete`<sup>Optional</sup> <a name="retain_on_delete" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.retainOnDelete"></a>

```python
retain_on_delete: bool
```

- *Type:* bool
- *Default:* true - when resource is deleted/updated, files are retained

If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.

NOTICE: Configuring this to "false" might have operational implications. Please
visit to the package documentation referred below to make sure you fully understand those implications.

> [https://github.com/aws/aws-cdk/tree/main/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete](https://github.com/aws/aws-cdk/tree/main/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete)

---

##### `role`<sup>Optional</sup> <a name="role" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.role"></a>

```python
role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole
- *Default:* A role is automatically created

Execution role associated with this function.

---

##### `server_side_encryption`<sup>Optional</sup> <a name="server_side_encryption" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryption"></a>

```python
server_side_encryption: ServerSideEncryption
```

- *Type:* aws_cdk.aws_s3_deployment.ServerSideEncryption
- *Default:* Server side encryption is not used.

System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `server_side_encryption_aws_kms_key_id`<sup>Optional</sup> <a name="server_side_encryption_aws_kms_key_id" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionAwsKmsKeyId"></a>

```python
server_side_encryption_aws_kms_key_id: str
```

- *Type:* str
- *Default:* Not set.

System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `server_side_encryption_customer_algorithm`<sup>Optional</sup> <a name="server_side_encryption_customer_algorithm" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.serverSideEncryptionCustomerAlgorithm"></a>

```python
server_side_encryption_customer_algorithm: str
```

- *Type:* str
- *Default:* Not set.

System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.

Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro)

---

##### `sign_content`<sup>Optional</sup> <a name="sign_content" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.signContent"></a>

```python
sign_content: bool
```

- *Type:* bool
- *Default:* `x-amz-content-sha256` will not be computed

If set to true, uploads will precompute the value of `x-amz-content-sha256` and include it in the signed S3 request headers.

---

##### `storage_class`<sup>Optional</sup> <a name="storage_class" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.storageClass"></a>

```python
storage_class: StorageClass
```

- *Type:* aws_cdk.aws_s3_deployment.StorageClass
- *Default:* Default storage-class for the bucket is used.

System-defined x-amz-storage-class metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

##### `use_efs`<sup>Optional</sup> <a name="use_efs" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.useEfs"></a>

```python
use_efs: bool
```

- *Type:* bool
- *Default:* No EFS. Lambda has access only to 512MB of disk space.

Mount an EFS file system.

Enable this if your assets are large and you encounter disk space errors.
Enabling this option will require a VPC to be specified.

---

##### `vpc`<sup>Optional</sup> <a name="vpc" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpc"></a>

```python
vpc: IVpc
```

- *Type:* aws_cdk.aws_ec2.IVpc
- *Default:* None

The VPC network to place the deployment lambda handler in.

This is required if `useEfs` is set.

---

##### `vpc_subnets`<sup>Optional</sup> <a name="vpc_subnets" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.vpcSubnets"></a>

```python
vpc_subnets: SubnetSelection
```

- *Type:* aws_cdk.aws_ec2.SubnetSelection
- *Default:* the Vpc default strategy if not specified

Where in the VPC to place the deployment lambda handler.

Only used if 'vpc' is supplied.

---

##### `website_redirect_location`<sup>Optional</sup> <a name="website_redirect_location" id="@aws-prototyping-sdk/static-website.BucketDeploymentProps.property.websiteRedirectLocation"></a>

```python
website_redirect_location: str
```

- *Type:* str
- *Default:* No website redirection.

System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.

> [https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata)

---

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/static-website.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CidrAllowList.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CidrAllowList(
  cidr_ranges: typing.List[str],
  cidr_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges">cidr_ranges</a></code> | <code>typing.List[str]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType">cidr_type</a></code> | <code>str</code> | Type of CIDR range. |

---

##### `cidr_ranges`<sup>Required</sup> <a name="cidr_ranges" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrRanges"></a>

```python
cidr_ranges: typing.List[str]
```

- *Type:* typing.List[str]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidr_type`<sup>Required</sup> <a name="cidr_type" id="@aws-prototyping-sdk/static-website.CidrAllowList.property.cidrType"></a>

```python
cidr_type: str
```

- *Type:* str

Type of CIDR range.

---

### CloudFrontWebAclProps <a name="CloudFrontWebAclProps" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps"></a>

Properties to configure the web acl.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.CloudFrontWebAclProps(
  cidr_allow_list: CidrAllowList = None,
  disable: bool = None,
  managed_rules: typing.List[ManagedRule] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList">cidr_allow_list</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.disable">disable</a></code> | <code>bool</code> | Set to true to prevent creation of a web acl for the static website. |
| <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules">managed_rules</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]</code> | List of managed rules to apply to the web acl. |

---

##### `cidr_allow_list`<sup>Optional</sup> <a name="cidr_allow_list" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.cidrAllowList"></a>

```python
cidr_allow_list: CidrAllowList
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.disable"></a>

```python
disable: bool
```

- *Type:* bool
- *Default:* false

Set to true to prevent creation of a web acl for the static website.

---

##### `managed_rules`<sup>Optional</sup> <a name="managed_rules" id="@aws-prototyping-sdk/static-website.CloudFrontWebAclProps.property.managedRules"></a>

```python
managed_rules: typing.List[ManagedRule]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/static-website.ManagedRule">ManagedRule</a>]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/static-website.ManagedRule"></a>

Represents a WAF V2 managed rule.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.ManagedRule.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.ManagedRule(
  name: str,
  vendor: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.name">name</a></code> | <code>str</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/static-website.ManagedRule.property.vendor">vendor</a></code> | <code>str</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/static-website.ManagedRule.property.name"></a>

```python
name: str
```

- *Type:* str

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/static-website.ManagedRule.property.vendor"></a>

```python
vendor: str
```

- *Type:* str

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### RuntimeOptions <a name="RuntimeOptions" id="@aws-prototyping-sdk/static-website.RuntimeOptions"></a>

Dynamic configuration which gets resolved only during deployment.

*Example*

```python
# Example automatically generated from non-compiling source. May contain errors.
# Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
# and all resolved values.
runtime_config = {"json_payload": {"bucket_arn": s3_bucket.bucket_arn}}
StaticWebsite(scope, "StaticWebsite", website_content_path="path/to/website", runtime_config=runtime_config)
```


#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.RuntimeOptions.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.RuntimeOptions(
  json_payload: typing.Any,
  json_file_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload">json_payload</a></code> | <code>typing.Any</code> | Arbitrary JSON payload containing runtime values to deploy. |
| <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName">json_file_name</a></code> | <code>str</code> | File name to store runtime configuration (jsonPayload). |

---

##### `json_payload`<sup>Required</sup> <a name="json_payload" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonPayload"></a>

```python
json_payload: typing.Any
```

- *Type:* typing.Any

Arbitrary JSON payload containing runtime values to deploy.

Typically this contains resourceArns, etc which
are only known at deploy time.

---

*Example*

```python
# Example automatically generated from non-compiling source. May contain errors.
userPoolId: some.userPool.userPoolId, someResourceArnsome.resource.Arn
```


##### `json_file_name`<sup>Optional</sup> <a name="json_file_name" id="@aws-prototyping-sdk/static-website.RuntimeOptions.property.jsonFileName"></a>

```python
json_file_name: str
```

- *Type:* str
- *Default:* "runtime-config.json"

File name to store runtime configuration (jsonPayload).

Must follow pattern: '*.json'

---

### StaticWebsiteProps <a name="StaticWebsiteProps" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps"></a>

Properties for configuring the StaticWebsite.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsiteProps(
  website_content_path: str,
  bucket_deployment_props: BucketDeploymentProps = None,
  default_website_bucket_encryption: BucketEncryption = None,
  default_website_bucket_encryption_key: Key = None,
  distribution_props: DistributionProps = None,
  runtime_options: RuntimeOptions = None,
  web_acl_props: CloudFrontWebAclProps = None,
  website_bucket: IBucket = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath">website_content_path</a></code> | <code>str</code> | Path to the directory containing the static website files and assets. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.bucketDeploymentProps">bucket_deployment_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a></code> | Custom bucket deployment properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption">default_website_bucket_encryption</a></code> | <code>aws_cdk.aws_s3.BucketEncryption</code> | Bucket encryption to use for the default bucket. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey">default_website_bucket_encryption_key</a></code> | <code>aws_cdk.aws_kms.Key</code> | A predefined KMS customer encryption key to use for the default bucket that gets created. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps">distribution_props</a></code> | <code>aws_cdk.aws_cloudfront.DistributionProps</code> | Custom distribution properties. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions">runtime_options</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a></code> | Dynamic configuration which gets resolved only during deployment. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps">web_acl_props</a></code> | <code><a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a></code> | Limited configuration settings for the generated webAcl. |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket">website_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Predefined bucket to deploy the website into. |

---

##### `website_content_path`<sup>Required</sup> <a name="website_content_path" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteContentPath"></a>

```python
website_content_path: str
```

- *Type:* str

Path to the directory containing the static website files and assets.

This directory must contain an index.html file.

---

##### `bucket_deployment_props`<sup>Optional</sup> <a name="bucket_deployment_props" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.bucketDeploymentProps"></a>

```python
bucket_deployment_props: BucketDeploymentProps
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.BucketDeploymentProps">BucketDeploymentProps</a>

Custom bucket deployment properties.

```
```

---

##### `default_website_bucket_encryption`<sup>Optional</sup> <a name="default_website_bucket_encryption" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryption"></a>

```python
default_website_bucket_encryption: BucketEncryption
```

- *Type:* aws_cdk.aws_s3.BucketEncryption
- *Default:* "S3MANAGED"

Bucket encryption to use for the default bucket.

Supported options are KMS or S3MANAGED.

Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}

---

##### `default_website_bucket_encryption_key`<sup>Optional</sup> <a name="default_website_bucket_encryption_key" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.defaultWebsiteBucketEncryptionKey"></a>

```python
default_website_bucket_encryption_key: Key
```

- *Type:* aws_cdk.aws_kms.Key

A predefined KMS customer encryption key to use for the default bucket that gets created.

Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.

---

##### `distribution_props`<sup>Optional</sup> <a name="distribution_props" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.distributionProps"></a>

```python
distribution_props: DistributionProps
```

- *Type:* aws_cdk.aws_cloudfront.DistributionProps

Custom distribution properties.

Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.

---

##### `runtime_options`<sup>Optional</sup> <a name="runtime_options" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.runtimeOptions"></a>

```python
runtime_options: RuntimeOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.RuntimeOptions">RuntimeOptions</a>

Dynamic configuration which gets resolved only during deployment.

---

##### `web_acl_props`<sup>Optional</sup> <a name="web_acl_props" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.webAclProps"></a>

```python
web_acl_props: CloudFrontWebAclProps
```

- *Type:* <a href="#@aws-prototyping-sdk/static-website.CloudFrontWebAclProps">CloudFrontWebAclProps</a>

Limited configuration settings for the generated webAcl.

For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.

Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.

---

##### `website_bucket`<sup>Optional</sup> <a name="website_bucket" id="@aws-prototyping-sdk/static-website.StaticWebsiteProps.property.websiteBucket"></a>

```python
website_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Predefined bucket to deploy the website into.

---

## Classes <a name="Classes" id="Classes"></a>

### StaticWebsiteOrigin <a name="StaticWebsiteOrigin" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin"></a>

- *Implements:* aws_cdk.aws_cloudfront.IOrigin

If passing in distributionProps, the default behaviour.origin is a required parameter. An instance of this class can be passed in to make the compiler happy.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.Initializer"></a>

```python
import aws_prototyping_sdk.static_website

aws_prototyping_sdk.static_website.StaticWebsiteOrigin()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind">bind</a></code> | The method called when a given Origin is added (for the first time) to a Distribution. |

---

##### `bind` <a name="bind" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind"></a>

```python
def bind(
  _scope: Construct,
  origin_id: str
) -> OriginBindConfig
```

The method called when a given Origin is added (for the first time) to a Distribution.

###### `_scope`<sup>Required</sup> <a name="_scope" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter._scope"></a>

- *Type:* constructs.Construct

---

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="@aws-prototyping-sdk/static-website.StaticWebsiteOrigin.bind.parameter.originId"></a>

- *Type:* str

The identifier of this Origin, as assigned by the Distribution this Origin has been used added to.

---





