# Copyright (c) 2019 Ezybaas by Bhavik Shah.
# Susthitsoft Technologies Private Limited.
# All rights reserved.
# Please see the LICENSE.txt included as part of this package.

import os
from .import config
from django.apps import apps
from .models import MetaModel
from .import utils
from django.core import management
from django.conf import settings
import shutil
import logging
from .models import App

#Permission
from django.contrib.auth.models import User, Group, Permission
from django.contrib.contenttypes.models import ContentType

warning = "#--------------------WARNING--------------------"
warning += '\n#This File has been Generated by EzyBaaS. To make any changes, Use EzyBaaS Interface Only.'
warning += "\n#Do NOT make any changes to this file Directly, EzyBaaS is not resposible for any loss of data.\n\n"
logger = logging.getLogger(__name__)


#CHECKER FUNCTIONS
# @TODO: Move to utils.py
#Check if the File was Generated by EzyBaaS
def ezybaas_can_edit_file(file_name):
	if not os.path.isfile(file_name):
		return True
		#File Does not Exist

	file = open(file_name, 'r')
	line = file.readlines()
	file.close()

	if 'WARNING' in line[0]:
		logger.info(config.BAAS_NAME + ' can make changes to this file')
		return True

	logger.error('Invalid file, cant write to it')
	return False

def ezybaas_can_edit_models(file_name):
	if not os.path.isfile(file_name):
		return True
		#File Does not Exist

	file = open(file_name, 'r')
	line = file.readlines()
	file.close()
	
	if not 'class' in line:
		logger.info(config.BAAS_NAME + ' can make changes to this file')
		return True

	logger.error('Invalid file, cant write to it')
	return False

# Is the app added by EzyBaas
def ezybaas_can_remove_app(app_folder,settings_file,app):

	if not os.path.isdir(app_folder):
		logger.info('File Does not Exist')
		return False

	x = "INSTALLED_APPS += ['" + app + "']   # WARNING: Added by EzyBaas. Please Do Not Remove."

	file = open(settings_file, 'r')
	lines = file.readlines()
	file.close()

	for line in lines:
		if x in line:
			return True

	return False



#Returns Name of Main Project

def return_project():
	return os.environ['DJANGO_SETTINGS_MODULE'].split('.')[0]

def create_models(app):
	#Creates models.py file
	file_path = os.path.abspath(os.path.join(app, 'models.py'))

	if ezybaas_can_edit_models(file_path):
		file = open(file_path, 'w')
		file.write(warning)
		file.write('from django.db import models\n') #neccesary header file
		file.write('\n')

		all_fields = utils.get_fields(app)
		tables = []

		for obj in all_fields:
			if not obj['table'] in tables:
				tables.append(obj['table'])

		for table in tables:
			fields = utils.get_fields(app,table)
			file.write('\nclass ' + table + '(models.Model):\n')

			for field in fields:
				if field['type'] == 'CharField':
					file.write('\t' + field['name'] + " = models." + field['type'] +"(max_length=" +
						str(field['max']) + ", " +
						str(utils.check_none(field['unique'], "unique")) +
						"blank = " + str(field['blank']) + ", " +
						"null = " + str(field['null']) +
						")\n")

				elif field['type'] == 'ForeignKey':
					print('...........', field)
					print('.......field.of app.....', field['app_id'])
					file.write('\t' + field['name'] + " = models." + field['type'] +
						"('"+ field['app_id']+"." + field['foreignkeytable']+ "', on_delete=models." + field['ondelete']+
						")\n")

				elif field['type'] == 'OneToOneField':
					file.write('\t' + field['name'] + " = models." + field['type'] +
						"('"+field['app_id']+"."+ field['foreignkeytable']+ "', on_delete=models." + field['ondelete']+
						")\n")

				elif field['type'] == 'ManyToManyField':
					file.write('\t' + field['name'] + " = models." + field['type'] +
						"('"+field['app_id']+"."+ field['foreignkeytable']+
						"')\n")

				else:
					file.write('\t' + field['name'] + " = models." + field['type'] + "(" +
						str(utils.check_none(field['unique'], "unique")) +
						"blank = " + str(field['blank']) + ", " +
						"null = " + str(obj['null']) +
						")\n")
		logger.info('Models written Successfully')
		file.close()

	else:
		logger.error('Cannot Write in User-created Files!')

def make_migrations(app):
	#Make Migrations
	management.call_command('makemigrations', app)
	logger.info('Makemigrations command Ran Successfully')

def migrate_changes():
	management.call_command('migrate')
	logger.info('Migrate command Ran Successfully')

def append_function(app,table,request,n):
	MetaModel.objects.filter(app=app,table=table).delete()
	for i in range(1,n+1):
		q, created = MetaModel.objects.get_or_create(
			app = app,
			table = table,
			name = request.POST['tblAppendGrid_field_' + str(i)],
			type = request.POST['tblAppendGrid_type_' + str(i)],
			null = request.POST['tblAppendGrid_null_' + str(i)],
			blank = request.POST['tblAppendGrid_blank_' + str(i)],
			# Default = "none",
			min = request.POST['tblAppendGrid_min_' + str(i)],
			max = request.POST['tblAppendGrid_max_' + str(i)],
			unique = request.POST['tblAppendGrid_unique_' + str(i)],
			primary_key = request.POST['tblAppendGrid_primary_key_' + str(i)],
		)

def create_app(app):
	if str(app) in settings.INSTALLED_APPS:
		print('..........app present........')
		return True
	else:
		print('.................else...........')
		settings_file = os.path.abspath(os.path.join(return_project(), 'settings.py'))
		management.call_command('startapp', app)



def delete_app(app):
	app_folder = os.path.abspath(os.path.join(return_project(), '..', app))
	settings_file = os.path.abspath(os.path.join(return_project(), 'settings.py'))

	if ezybaas_can_remove_app(app_folder,settings_file,app):
		logger.info('We can Delete this')

		# Commented as this is part of RESTAPI Call and not related to file system
		# 1. Migrate to Remove Models
		management.call_command('migrate', app, 'zero')
		logger.info('Migrations Appiled to Remove Fields')

		# 2. Remove from Installed Apps in Settings.py
		x = "INSTALLED_APPS += ['" + app + "']   # WARNING: Added by EzyBaas. Please Do Not Remove."

		file = open(settings_file, 'r')
		lines = file.readlines()
		file.close()

		file = open(settings_file, 'w')
		for line in lines:
			if x in line:
				continue
			else:
				file.write(line)

		file.close()
		logger.info('Removed from INSTALLED APPS array')

		#3. Remove included app.urls
		# @TODO: Make sure to change path according to STANDALONE or not, i.e. ezybaas/ should be excluded or not
		urls_file = os.path.abspath(os.path.join(return_project(), 'urls.py'))
		x = "urlpatterns.append(path('" + config.BAAS_NAME + "/api/" +app+ "/', include('" +app+ ".urls'), name='"+app +"'))   # WARNING: Added by EzyBaas. Please Do Not Remove."

		file = open(urls_file, 'r')
		lines = file.readlines()
		file.close()

		file = open(urls_file, 'w')
		for line in lines:
			if x in line:
				continue
			else:
				file.write(line)

		file.close()
		logger.info('Removed from mainproject/urls.py')

		#4. Remove App Folder
		shutil.rmtree(app_folder)
		logger.info('Removed App Folder.')

		"""
		ADDITIONAL REQUIREMENTS(not must have):
		5. If the app stored media files, cache files, or other temporary files somewhere, delete those as well.
		6. Also be wary of lingering session data that might be leftover from the app.
		7. Also remove any stale content types.
		8. Remove Groups with permissions and associcated Users
		"""

	else:
		logger.error('Unable to Delete App')


#Create Views/Serializer 'api.py' for respective App
def create_api(app):
	file_path = os.path.abspath(os.path.join(app, config.VIEWS_FILE_NAME))
	file_path = file_path + '.py'

	# @TODO:
	# owner = self.user check in generated model

	if ezybaas_can_edit_file(file_path):
		file = open(file_path, 'w')
		file.write(warning)
		file.write('from rest_framework import serializers\n') #neccesary header file
		file.write('from rest_framework import viewsets\n') #neccesary header file
		file.write('from rest_framework.permissions import IsAuthenticated\n')#For Authentication

		models = utils.get_tables(app)
		print('Models fetched Successfully')
		print(models)
		for model in models:
			file.write('from .models import ' + model + '\n')
			#Won't work for Camel Case. (Eg. SpaceStation will be treated as Spacestation)
		file.write('\n')

		for model in models:
			fields = MetaModel.objects.filter(app=app, table=model).values()
			all_fields = True

			#Serializer:
			file.write('class '+ model +'Serializer(serializers.ModelSerializer):\n')
			#Won't work for Camel Case.
			file.write('\tclass Meta:\n')
			file.write('\t\tmodel = ' + model+ '\n')
			exclude = []
			for field in fields:
				if field['inapi']== False:
					exclude.append(field['name'])

			if exclude:
				file.write("\t\texclude = ")
				for e in exclude:
					file.write("('" + e + "',) ")
				file.write("\n")

			else: #Exclude array Empty
				file.write("\t\tfields = '__all__'"+ '\n')
			file.write('\n')

			#View:
			file.write('class '+model+'ViewSet(viewsets.ModelViewSet):\n')
			file.write('\tpermission_classes = (IsAuthenticated,)\n')
			file.write('\tserializer_class = '+model+'Serializer\n\n')
			file.write('\tdef get_queryset(self):\n')
			file.write('\t\tqueryset = []\n')
			file.write("\t\tif self.request.user.has_perm('"+app+".delete_"+model.lower()+"') and self.request.user.has_perm('"+app+".view_"+model.lower()+"'):\n")
			file.write("\t\t\tif self.request.user.has_perm('"+app+".change_"+model.lower()+"') and self.request.user.has_perm('"+app+".add_"+model.lower()+"'):\n")
			file.write('\t\t\t\tqueryset = '+model+'.objects.all()\n')
			file.write('\t\treturn queryset\n\n\n')

		logger.info('Api.py file created successfully')
		file.close()

	else:
		logger.error('Cannot Write in User-created Files!')


def isUrlPresent(line, file):
	root = return_root_urlconf()
	file_path = os.path.abspath(os.path.join(root[0],root[1]))
	
	with open(file_path+'.py') as file:
		if line in file.read():
			print("Found it!")
			return True
		else:
			print("Not found.")
			return False


def append_url(app):
	#Append to project/urls.py
	root = return_root_urlconf()
	file_path = os.path.abspath(os.path.join(root[0],root[1]))
	line = str("\nurlpatterns.append(path('" + config.BAAS_NAME + "/api/" + app + "/', include('" +app+ ".urls'), name='"+app +"'))   # WARNING: Added by EzyBaas. Please Do Not Remove.\n")
	if isUrlPresent(line,file_path):
		return False
	else:
		file = open(file_path+'.py', 'a')

		file.write("\nurlpatterns.append(path('" + config.BAAS_NAME + "/api/" + app + "/', include('" +app+ ".urls'), name='"+app +"'))   # WARNING: Added by EzyBaas. Please Do Not Remove.\n")

		file.close()


def create_url(app):
	#Append to app/urls.py
	view_serializer = config.VIEWS_FILE_NAME
	models = utils.get_tables(app)

	file_path = os.path.abspath(os.path.join(app, config.URLS_FILE_NAME + '.py'))
	if ezybaas_can_edit_file(file_path):
		file = open(file_path, 'w')
		file.write(warning)
		file.write("from . import " + view_serializer + "\n")
		file.write('from rest_framework.routers import DefaultRouter\n\n')
		file.write('router = DefaultRouter()\n')
		for model in models:
			file.write("router.register(r'"+model.lower()+"', "+view_serializer+"."+model+"ViewSet, base_name='"+model.lower()+"')\n")
		file.write("\nurlpatterns = router.urls\n")
		logger.info('urls.py created for the app '+ app)
		file.close()
	else:
		logger.error('Cannot Write in User-created Files!')

#Returns Value of Project/ROOT_URLCONF
def return_root_urlconf():
	file_path = os.path.abspath(os.path.join(return_project(), 'settings'))
	file = open(file_path+'.py', 'r')
	lines = file.readlines()
	for line in lines:
		if 'ROOT_URLCONF' in line:
			root_urlconf = line
			root_urlconf = root_urlconf[:-2]# Remove extra \n
			root_urlconf = root_urlconf.split('=')[1].split('.')
			root_urlconf[0] = root_urlconf[0][2:]# Remove extra quote and space
			return root_urlconf



def create_group_permission_specific(app,model):
	group_name = config.BAAS_NAME + '_' + app + '_' + model

	my_group, created = Group.objects.get_or_create(name=group_name)
	ct = ContentType.objects.get(app_label__iexact=app, model__iexact=model)
	features  = ['view','add','delete','change']

	for feature in features:
		permission = Permission.objects.get(codename=feature + '_' + model.lower(),
										name='Can '+feature + ' '+ model.lower(),
										content_type=ct)

		my_group.permissions.add(permission)

def add_user_to_group(self,username,group):
	user = User.objects.get(username=username)
	group = Group.objects.get(name=group)
	user.groups.add(group)

def auth_func(self,func_type,permissions):
	myArray = []
	for p in permissions:
		part = p.partition('.')

		app = part[0]	#partition based on '.', gives app name
		table = part[2].partition('_')[2]	#partition based on '_', gives table name
		type = part[2].partition('_')[0]	#partition based on '_', gives type

		dict = {
			"app" : app,
			"table" : table,
		}

		if func_type==type:
			myArray.append(dict)

	return myArray

def update_settings(app):
	settings_file = os.path.abspath(os.path.join(return_project(), 'settings.py'))
	if str(app) in settings.INSTALLED_APPS:
		return True
	else:
		file = open(settings_file, 'a')
		file.write("\nINSTALLED_APPS += ['" + app + "']   # WARNING: Added by EzyBaas. Please Do Not Remove.")
		file.close()


def update_settings_apps(apps):
	settings_file = os.path.abspath(os.path.join(return_project(), 'settings.py'))
	file = open(settings_file, 'a')

	file.write("\nINSTALLED_APPS += ['" + app + "']   # WARNING: Added by EzyBaas. Please Do Not Remove.")
	file.close()

def go_live(app):
	fields = utils.get_fields(app)
	tables = utils.get_tables(app)
	create_app(app)
	create_models(app)
	create_api(app)
	create_url(app)
	append_url(app)
	update_settings(app)
	obj = App.objects.get(name=app)
	obj.active = True
	obj.save()
