# StripeSubscription


## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**djstripe_id** | **int** |  | [readonly] 
**plan** | [**StripePlan**](StripePlan.md) |  | 
**default_payment_method** | [**StripePaymentMethod**](StripePaymentMethod.md) |  | 
**schedule** | [**StripeSubscriptionSchedule**](StripeSubscriptionSchedule.md) |  | 
**is_period_current** | **bool** |  | 
**is_status_current** | **bool** |  | 
**is_status_temporarily_current** | **bool** |  | 
**is_valid** | **bool** |  | 
**djstripe_created** | **datetime** |  | [readonly] 
**djstripe_updated** | **datetime** |  | [readonly] 
**id** | **str** |  | 
**livemode** | **bool** | Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation. | [optional] 
**created** | **datetime** | The datetime this object was created in stripe. | [optional] 
**metadata** | **dict(str, object)** | A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format. | [optional] 
**description** | **str** | A description of this object. | [optional] 
**application_fee_percent** | **str** | A positive decimal that represents the fee percentage of the subscription invoice amount that will be transferred to the application owner&#39;s Stripe account each billing period. | [optional] 
**billing_cycle_anchor** | **datetime** | Determines the date of the first full invoice, and, for plans with &#x60;month&#x60; or &#x60;year&#x60; intervals, the day of the month for subsequent invoices. | [optional] 
**billing_thresholds** | **dict(str, object)** | Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period. | [optional] 
**cancel_at** | **datetime** | A date in the future at which the subscription will automatically get canceled. | [optional] 
**cancel_at_period_end** | **bool** | If the subscription has been canceled with the &#x60;&#x60;at_period_end&#x60;&#x60; flag set to true, &#x60;&#x60;cancel_at_period_end&#x60;&#x60; on the subscription will be true. You can use this attribute to determine whether a subscription that has a status of active is scheduled to be canceled at the end of the current period. | [optional] 
**canceled_at** | **datetime** | If the subscription has been canceled, the date of that cancellation. If the subscription was canceled with &#x60;&#x60;cancel_at_period_end&#x60;&#x60;, canceled_at will still reflect the date of the initial cancellation request, not the end of the subscription period when the subscription is automatically moved to a canceled state. | [optional] 
**collection_method** | [**CollectionMethodEnum**](CollectionMethodEnum.md) | Either &#x60;charge_automatically&#x60;, or &#x60;send_invoice&#x60;. When charging automatically, Stripe will attempt to pay this subscription at the end of the cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions. | 
**current_period_end** | **datetime** | End of the current period for which the subscription has been invoiced. At the end of this period, a new invoice will be created. | 
**current_period_start** | **datetime** | Start of the current period for which the subscription has been invoiced. | 
**days_until_due** | **int** | Number of days a customer has to pay invoices generated by this subscription. This value will be &#x60;null&#x60; for subscriptions where &#x60;billing&#x3D;charge_automatically&#x60;. | [optional] 
**discount** | **dict(str, object)** |  | [optional] 
**ended_at** | **datetime** | If the subscription has ended (either because it was canceled or because the customer was switched to a subscription to a new plan), the date the subscription ended. | [optional] 
**next_pending_invoice_item_invoice** | **datetime** | Specifies the approximate timestamp on which any pending invoice items will be billed according to the schedule provided at pending_invoice_item_interval. | [optional] 
**pending_invoice_item_interval** | **dict(str, object)** | Specifies an interval for how often to bill for any pending invoice items. It is analogous to calling Create an invoice for the given subscription at the specified interval. | [optional] 
**pending_update** | **dict(str, object)** | If specified, pending updates that will be applied to the subscription once the latest_invoice has been paid. | [optional] 
**quantity** | **int** | The quantity applied to this subscription. This value will be &#x60;null&#x60; for multi-plan subscriptions | [optional] 
**start_date** | **datetime** | Date when the subscription was first created. The date might differ from the created date due to backdating. | [optional] 
**status** | [**StripeSubscriptionStatusEnum**](StripeSubscriptionStatusEnum.md) | The status of this subscription. | 
**trial_end** | **datetime** | If the subscription has a trial, the end of that trial. | [optional] 
**trial_start** | **datetime** | If the subscription has a trial, the beginning of that trial. | [optional] 
**djstripe_owner_account** | **str** | The Stripe Account this object belongs to. | [optional] 
**customer** | **str** | The customer associated with this subscription. | 
**default_source** | **str** | The default payment source for the subscription. It must belong to the customer associated with the subscription and be in a chargeable state. If not set, defaults to the customer&#39;s default source. | [optional] 
**latest_invoice** | **str** | The most recent invoice this subscription has generated. | [optional] 
**pending_setup_intent** | **str** | We can use this SetupIntent to collect user authentication when creating a subscription without immediate payment or updating a subscription&#39;s payment method, allowing you to optimize for off-session payments. | [optional] 
**default_tax_rates** | **list[int]** | The tax rates that will apply to any subscription item that does not have tax_rates set. Invoices created will have their default_tax_rates populated from the subscription. | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


