# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'NetworkSegmentArgs',
    'PortAllowedAddressPairArgs',
    'PortBindingArgs',
    'PortExtraDhcpOptionArgs',
    'PortFixedIpArgs',
    'RouterExternalFixedIpArgs',
    'RouterVendorOptionsArgs',
    'SubnetAllocationPoolArgs',
    'SubnetAllocationPoolsCollectionArgs',
    'SubnetHostRouteArgs',
    'TrunkSubPortArgs',
]

@pulumi.input_type
class NetworkSegmentArgs:
    def __init__(__self__, *,
                 network_type: Optional[pulumi.Input[str]] = None,
                 physical_network: Optional[pulumi.Input[str]] = None,
                 segmentation_id: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] network_type: The type of physical network.
        :param pulumi.Input[str] physical_network: The physical network where this network is implemented.
        :param pulumi.Input[float] segmentation_id: An isolated segment on the physical network.
        """
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if physical_network is not None:
            pulumi.set(__self__, "physical_network", physical_network)
        if segmentation_id is not None:
            pulumi.set(__self__, "segmentation_id", segmentation_id)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of physical network.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="physicalNetwork")
    def physical_network(self) -> Optional[pulumi.Input[str]]:
        """
        The physical network where this network is implemented.
        """
        return pulumi.get(self, "physical_network")

    @physical_network.setter
    def physical_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_network", value)

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> Optional[pulumi.Input[float]]:
        """
        An isolated segment on the physical network.
        """
        return pulumi.get(self, "segmentation_id")

    @segmentation_id.setter
    def segmentation_id(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "segmentation_id", value)


@pulumi.input_type
class PortAllowedAddressPairArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 mac_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The additional IP address.
        :param pulumi.Input[str] mac_address: The additional MAC address.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The additional IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The additional MAC address.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)


@pulumi.input_type
class PortBindingArgs:
    def __init__(__self__, *,
                 host_id: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 vif_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vif_type: Optional[pulumi.Input[str]] = None,
                 vnic_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_id: The ID of the host to allocate port on.
        :param pulumi.Input[str] profile: Custom data to be passed as `binding:profile`. Data
               must be passed as JSON.
        :param pulumi.Input[Mapping[str, Any]] vif_details: A map of JSON strings containing additional
               details for this specific binding.
        :param pulumi.Input[str] vif_type: The VNIC type of the port binding.
        :param pulumi.Input[str] vnic_type: VNIC type for the port. Can either be `direct`,
               `direct-physical`, `macvtap`, `normal`, `baremetal` or `virtio-forwarder`.
               Default value is `normal`.
        """
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if vif_details is not None:
            pulumi.set(__self__, "vif_details", vif_details)
        if vif_type is not None:
            pulumi.set(__self__, "vif_type", vif_type)
        if vnic_type is not None:
            pulumi.set(__self__, "vnic_type", vnic_type)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host to allocate port on.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Custom data to be passed as `binding:profile`. Data
        must be passed as JSON.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="vifDetails")
    def vif_details(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of JSON strings containing additional
        details for this specific binding.
        """
        return pulumi.get(self, "vif_details")

    @vif_details.setter
    def vif_details(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "vif_details", value)

    @property
    @pulumi.getter(name="vifType")
    def vif_type(self) -> Optional[pulumi.Input[str]]:
        """
        The VNIC type of the port binding.
        """
        return pulumi.get(self, "vif_type")

    @vif_type.setter
    def vif_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vif_type", value)

    @property
    @pulumi.getter(name="vnicType")
    def vnic_type(self) -> Optional[pulumi.Input[str]]:
        """
        VNIC type for the port. Can either be `direct`,
        `direct-physical`, `macvtap`, `normal`, `baremetal` or `virtio-forwarder`.
        Default value is `normal`.
        """
        return pulumi.get(self, "vnic_type")

    @vnic_type.setter
    def vnic_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_type", value)


@pulumi.input_type
class PortExtraDhcpOptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 ip_version: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] name: Name of the DHCP option.
        :param pulumi.Input[str] value: Value of the DHCP option.
        :param pulumi.Input[float] ip_version: IP protocol version. Defaults to 4.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the DHCP option.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the DHCP option.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[float]]:
        """
        IP protocol version. Defaults to 4.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ip_version", value)


@pulumi.input_type
class PortFixedIpArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subnet_id: Subnet in which to allocate IP address for
               this port.
        :param pulumi.Input[str] ip_address: The additional IP address.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet in which to allocate IP address for
        this port.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The additional IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class RouterExternalFixedIpArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address to set on the router.
        :param pulumi.Input[str] subnet_id: Subnet in which the fixed IP belongs to.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address to set on the router.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet in which the fixed IP belongs to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class RouterVendorOptionsArgs:
    def __init__(__self__, *,
                 set_router_gateway_after_create: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] set_router_gateway_after_create: Boolean to control whether
               the Router gateway is assigned during creation or updated after creation.
        """
        if set_router_gateway_after_create is not None:
            pulumi.set(__self__, "set_router_gateway_after_create", set_router_gateway_after_create)

    @property
    @pulumi.getter(name="setRouterGatewayAfterCreate")
    def set_router_gateway_after_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to control whether
        the Router gateway is assigned during creation or updated after creation.
        """
        return pulumi.get(self, "set_router_gateway_after_create")

    @set_router_gateway_after_create.setter
    def set_router_gateway_after_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_router_gateway_after_create", value)


@pulumi.input_type
class SubnetAllocationPoolArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end: The ending address.
        :param pulumi.Input[str] start: The starting address.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        The ending address.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The starting address.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class SubnetAllocationPoolsCollectionArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end: The ending address.
        :param pulumi.Input[str] start: The starting address.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        The ending address.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The starting address.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class SubnetHostRouteArgs:
    def __init__(__self__, *,
                 destination_cidr: pulumi.Input[str],
                 next_hop: pulumi.Input[str]):
        """
        :param pulumi.Input[str] destination_cidr: The destination CIDR.
        :param pulumi.Input[str] next_hop: The next hop in the route.
        """
        pulumi.set(__self__, "destination_cidr", destination_cidr)
        pulumi.set(__self__, "next_hop", next_hop)

    @property
    @pulumi.getter(name="destinationCidr")
    def destination_cidr(self) -> pulumi.Input[str]:
        """
        The destination CIDR.
        """
        return pulumi.get(self, "destination_cidr")

    @destination_cidr.setter
    def destination_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_cidr", value)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[str]:
        """
        The next hop in the route.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop", value)


@pulumi.input_type
class TrunkSubPortArgs:
    def __init__(__self__, *,
                 port_id: pulumi.Input[str],
                 segmentation_id: pulumi.Input[float],
                 segmentation_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] port_id: The ID of the port to be made a subport of the trunk.
        :param pulumi.Input[float] segmentation_id: The numeric id of the subport segment.
        :param pulumi.Input[str] segmentation_type: The segmentation technology to use, e.g., "vlan".
        """
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "segmentation_id", segmentation_id)
        pulumi.set(__self__, "segmentation_type", segmentation_type)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[str]:
        """
        The ID of the port to be made a subport of the trunk.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> pulumi.Input[float]:
        """
        The numeric id of the subport segment.
        """
        return pulumi.get(self, "segmentation_id")

    @segmentation_id.setter
    def segmentation_id(self, value: pulumi.Input[float]):
        pulumi.set(self, "segmentation_id", value)

    @property
    @pulumi.getter(name="segmentationType")
    def segmentation_type(self) -> pulumi.Input[str]:
        """
        The segmentation technology to use, e.g., "vlan".
        """
        return pulumi.get(self, "segmentation_type")

    @segmentation_type.setter
    def segmentation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "segmentation_type", value)


