# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, audited=None, description=None, id=None, name=None, policy_id=None, region=None, rules=None, shared=None, tenant_id=None):
        if audited and not isinstance(audited, bool):
            raise TypeError("Expected argument 'audited' to be a bool")
        pulumi.set(__self__, "audited", audited)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if shared and not isinstance(shared, bool):
            raise TypeError("Expected argument 'shared' to be a bool")
        pulumi.set(__self__, "shared", shared)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def audited(self) -> bool:
        """
        The audit status of the firewall policy.
        """
        return pulumi.get(self, "audited")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the firewall policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def rules(self) -> List[str]:
        """
        The array of one or more firewall rules that comprise the policy.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def shared(self) -> bool:
        """
        The sharing status of the firewall policy.
        """
        return pulumi.get(self, "shared")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            audited=self.audited,
            description=self.description,
            id=self.id,
            name=self.name,
            policy_id=self.policy_id,
            region=self.region,
            rules=self.rules,
            shared=self.shared,
            tenant_id=self.tenant_id)


def get_policy(name: Optional[str] = None,
               policy_id: Optional[str] = None,
               region: Optional[str] = None,
               tenant_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Use this data source to get firewall policy information of an available OpenStack firewall policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    policy = openstack.firewall.get_policy(name="tf_test_policy")
    ```


    :param str name: The name of the firewall policy.
    :param str policy_id: The ID of the firewall policy.
    :param str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve firewall policy ids. If omitted, the
           `region` argument of the provider is used.
    :param str tenant_id: The owner of the firewall policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['region'] = region
    __args__['tenantId'] = tenant_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('openstack:firewall/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        audited=__ret__.audited,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        policy_id=__ret__.policy_id,
        region=__ret__.region,
        rules=__ret__.rules,
        shared=__ret__.shared,
        tenant_id=__ret__.tenant_id)
