"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        // ------------------------------------------------------------------------
        // General
        const siteId = options.siteId ?? 'Plone';
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        const backendPort = 8080;
        // Probing
        const backendActionHttpGet = {
            path: '/',
            port: k8s_1.IntOrString.fromNumber(backendPort),
        };
        const backendLivenessProbe = {
            httpGet: backendActionHttpGet,
            initialDelaySeconds: backend.livenessInitialDelaySeconds ?? 30,
            timeoutSeconds: backend.livenessIimeoutSeconds ?? 5,
            periodSeconds: backend.livenessPeriodSeconds ?? 10,
            successThreshold: backend.livenessSuccessThreshold ?? 1,
            failureThreshold: backend.livenessFailureThreshold ?? 3,
        };
        const backendReadinessProbe = {
            initialDelaySeconds: backend.readinessInitialDelaySeconds ?? 10,
            timeoutSeconds: backend.readinessIimeoutSeconds ?? 15,
            periodSeconds: backend.readinessPeriodSeconds ?? 10,
            successThreshold: backend.readinessSuccessThreshold ?? 1,
            failureThreshold: backend.readinessFailureThreshold ?? 3,
        };
        // Deployment
        const backendDeployment = new deployment_1.PloneDeployment(this, 'backend', {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? '500m',
            limitMemory: backend.limitMemory ?? '512Mi',
            requestCpu: backend.requestCpu ?? '200m',
            requestMemory: backend.requestMemory ?? '256Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
            livenessProbe: backendLivenessProbe,
            readinessProbe: backendReadinessProbe,
        });
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        const frontend = options.frontend ?? {};
        const frontendPort = 3000;
        const frontendLabels = {
            'app.kubernetes.io/name': 'plone-frontend',
            'app.kubernetes.io/component': 'frontend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        // Probing
        const frontendActionHttpGet = {
            path: '/',
            port: k8s_1.IntOrString.fromNumber(frontendPort),
        };
        const frontendLivenessProbe = {
            httpGet: frontendActionHttpGet,
            initialDelaySeconds: frontend.livenessInitialDelaySeconds ?? 30,
            timeoutSeconds: frontend.livenessIimeoutSeconds ?? 5,
            periodSeconds: frontend.livenessPeriodSeconds ?? 10,
            successThreshold: frontend.livenessSuccessThreshold ?? 1,
            failureThreshold: frontend.livenessFailureThreshold ?? 3,
        };
        const frontendReadinessProbe = {
            httpGet: frontendActionHttpGet,
            initialDelaySeconds: frontend.readinessInitialDelaySeconds ?? 10,
            timeoutSeconds: frontend.readinessIimeoutSeconds ?? 15,
            periodSeconds: frontend.readinessPeriodSeconds ?? 10,
            successThreshold: frontend.readinessSuccessThreshold ?? 1,
            failureThreshold: frontend.readinessFailureThreshold ?? 3,
        };
        // Environment for RAZZLE
        var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
        if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
            // connect with backend service
            frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:${backendPort}/${siteId}`));
        }
        // Deployment
        const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', {
            labels: frontendLabels,
            image: {
                image: frontend.image ?? 'plone/plone-frontend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: frontend.replicas,
            limitCpu: frontend.limitCpu ?? '500m',
            limitMemory: frontend.limitMemory ?? '1Gi',
            requestCpu: backend.requestCpu ?? '200m',
            requestMemory: backend.requestMemory ?? '256Mi',
            pdb: {
                maxUnavailable: frontend.maxUnavailable ?? undefined,
                minAvailable: frontend.minAvailable ?? undefined,
            },
            port: frontendPort,
            environment: frontendEnvironment,
            livenessProbe: frontendLivenessProbe,
            readinessProbe: frontendReadinessProbe,
        });
        // Service
        const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-frontend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: frontendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
        });
        this.frontendServiceName = frontendService.name;
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGxvbmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGxvbmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpQ0FBOEI7QUFDOUIsdUNBQXVDO0FBQ3ZDLDJDQUF1QztBQUN2Qyw2Q0FBK0M7QUFDL0MsdUNBQW1EO0FBRW5ELHVDQUF5QztBQXNDekMsTUFBYSxLQUFNLFNBQVEsc0JBQVM7SUFLbEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxVQUF3QixFQUFFO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsMkVBQTJFO1FBQzNFLFVBQVU7UUFDVixNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxJQUFJLE9BQU8sQ0FBQztRQUV6QywyRUFBMkU7UUFDM0UsVUFBVTtRQUNWLE1BQU0sT0FBTyxHQUFHLE9BQU8sQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFDO1FBQ3RDLE1BQU0sYUFBYSxHQUFHO1lBQ3BCLHdCQUF3QixFQUFFLGVBQWU7WUFDekMsNkJBQTZCLEVBQUUsU0FBUztZQUN4QywyQkFBMkIsRUFBRSxPQUFPLENBQUMsT0FBTyxJQUFJLFdBQVc7U0FDNUQsQ0FBQztRQUNGLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQztRQUV6QixVQUFVO1FBQ1YsTUFBTSxvQkFBb0IsR0FBc0I7WUFDOUMsSUFBSSxFQUFFLEdBQUc7WUFDVCxJQUFJLEVBQUUsaUJBQVcsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1NBQzFDLENBQUM7UUFFRixNQUFNLG9CQUFvQixHQUFVO1lBQ2xDLE9BQU8sRUFBRSxvQkFBb0I7WUFDN0IsbUJBQW1CLEVBQUUsT0FBTyxDQUFDLDJCQUEyQixJQUFJLEVBQUU7WUFDOUQsY0FBYyxFQUFFLE9BQU8sQ0FBQyxzQkFBc0IsSUFBSSxDQUFDO1lBQ25ELGFBQWEsRUFBRSxPQUFPLENBQUMscUJBQXFCLElBQUksRUFBRTtZQUNsRCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsd0JBQXdCLElBQUksQ0FBQztZQUN2RCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsd0JBQXdCLElBQUksQ0FBQztTQUN4RCxDQUFDO1FBQ0YsTUFBTSxxQkFBcUIsR0FBVTtZQUNuQyxtQkFBbUIsRUFBRSxPQUFPLENBQUMsNEJBQTRCLElBQUksRUFBRTtZQUMvRCxjQUFjLEVBQUUsT0FBTyxDQUFDLHVCQUF1QixJQUFJLEVBQUU7WUFDckQsYUFBYSxFQUFFLE9BQU8sQ0FBQyxzQkFBc0IsSUFBSSxFQUFFO1lBQ25ELGdCQUFnQixFQUFFLE9BQU8sQ0FBQyx5QkFBeUIsSUFBSSxDQUFDO1lBQ3hELGdCQUFnQixFQUFFLE9BQU8sQ0FBQyx5QkFBeUIsSUFBSSxDQUFDO1NBQ3pELENBQUM7UUFFRixhQUFhO1FBQ2IsTUFBTSxpQkFBaUIsR0FBRyxJQUFJLDRCQUFlLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUM3RCxNQUFNLEVBQUUsYUFBYTtZQUNyQixLQUFLLEVBQUU7Z0JBQ0wsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFLLElBQUksNEJBQTRCO2dCQUNwRCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLElBQUksRUFBRTtnQkFDaEQsZUFBZSxFQUFFLE9BQU8sQ0FBQyxlQUFlLElBQUksY0FBYzthQUMzRDtZQUNELFFBQVEsRUFBRSxPQUFPLENBQUMsUUFBUTtZQUMxQixRQUFRLEVBQUUsT0FBTyxDQUFDLFFBQVEsSUFBSSxNQUFNO1lBQ3BDLFdBQVcsRUFBRSxPQUFPLENBQUMsV0FBVyxJQUFJLE9BQU87WUFDM0MsVUFBVSxFQUFFLE9BQU8sQ0FBQyxVQUFVLElBQUksTUFBTTtZQUN4QyxhQUFhLEVBQUUsT0FBTyxDQUFDLGFBQWEsSUFBSSxPQUFPO1lBQy9DLEdBQUcsRUFBRTtnQkFDSCxjQUFjLEVBQUUsT0FBTyxDQUFDLGNBQWMsSUFBSSxTQUFTO2dCQUNuRCxZQUFZLEVBQUUsT0FBTyxDQUFDLFlBQVksSUFBSSxTQUFTO2FBQ2hEO1lBQ0QsSUFBSSxFQUFFLFdBQVc7WUFDakIsV0FBVyxFQUFFLE9BQU8sQ0FBQyxXQUFXO1lBQ2hDLGFBQWEsRUFBRSxvQkFBb0I7WUFDbkMsY0FBYyxFQUFFLHFCQUFxQjtTQUN0QyxDQUFDLENBQUM7UUFFSCxVQUFVO1FBQ1YsTUFBTSxjQUFjLEdBQUcsSUFBSSxzQkFBWSxDQUFDLGlCQUFpQixFQUFFLFNBQVMsRUFBRTtZQUNwRSxNQUFNLEVBQUU7Z0JBQ04sd0JBQXdCLEVBQUUsdUJBQXVCO2dCQUNqRCw2QkFBNkIsRUFBRSxTQUFTO2FBQ3pDO1lBQ0QsVUFBVSxFQUFFLFdBQVc7WUFDdkIsYUFBYSxFQUFFLEVBQUUsR0FBRyxFQUFFLGFBQUssQ0FBQyxZQUFZLENBQUMsaUJBQWlCLENBQUMsRUFBRTtTQUM5RCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsY0FBYyxDQUFDLElBQUksQ0FBQztRQUU5QywyRUFBMkU7UUFDM0UsV0FBVztRQUNYLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLElBQUksRUFBRSxDQUFDO1FBQ3hDLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQztRQUMxQixNQUFNLGNBQWMsR0FBRztZQUNyQix3QkFBd0IsRUFBRSxnQkFBZ0I7WUFDMUMsNkJBQTZCLEVBQUUsVUFBVTtZQUN6QywyQkFBMkIsRUFBRSxPQUFPLENBQUMsT0FBTyxJQUFJLFdBQVc7U0FDNUQsQ0FBQztRQUVGLFVBQVU7UUFDVixNQUFNLHFCQUFxQixHQUFzQjtZQUMvQyxJQUFJLEVBQUUsR0FBRztZQUNULElBQUksRUFBRSxpQkFBVyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7U0FDM0MsQ0FBQztRQUNGLE1BQU0scUJBQXFCLEdBQVU7WUFDbkMsT0FBTyxFQUFFLHFCQUFxQjtZQUM5QixtQkFBbUIsRUFBRSxRQUFRLENBQUMsMkJBQTJCLElBQUksRUFBRTtZQUMvRCxjQUFjLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixJQUFJLENBQUM7WUFDcEQsYUFBYSxFQUFFLFFBQVEsQ0FBQyxxQkFBcUIsSUFBSSxFQUFFO1lBQ25ELGdCQUFnQixFQUFFLFFBQVEsQ0FBQyx3QkFBd0IsSUFBSSxDQUFDO1lBQ3hELGdCQUFnQixFQUFFLFFBQVEsQ0FBQyx3QkFBd0IsSUFBSSxDQUFDO1NBQ3pELENBQUM7UUFDRixNQUFNLHNCQUFzQixHQUFVO1lBQ3BDLE9BQU8sRUFBRSxxQkFBcUI7WUFDOUIsbUJBQW1CLEVBQUUsUUFBUSxDQUFDLDRCQUE0QixJQUFJLEVBQUU7WUFDaEUsY0FBYyxFQUFFLFFBQVEsQ0FBQyx1QkFBdUIsSUFBSSxFQUFFO1lBQ3RELGFBQWEsRUFBRSxRQUFRLENBQUMsc0JBQXNCLElBQUksRUFBRTtZQUNwRCxnQkFBZ0IsRUFBRSxRQUFRLENBQUMseUJBQXlCLElBQUksQ0FBQztZQUN6RCxnQkFBZ0IsRUFBRSxRQUFRLENBQUMseUJBQXlCLElBQUksQ0FBQztTQUMxRCxDQUFDO1FBRUYseUJBQXlCO1FBQ3pCLElBQUksbUJBQW1CLEdBQUcsUUFBUSxDQUFDLFdBQVcsSUFBSSxJQUFJLEtBQUssQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3hFLElBQUksbUJBQW1CLENBQUMsU0FBUyxDQUFDLHdCQUF3QixLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ3pFLCtCQUErQjtZQUMvQixtQkFBbUIsRUFBRSxXQUFXLENBQUMsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsVUFBVSxjQUFjLENBQUMsSUFBSSxJQUFJLFdBQVcsSUFBSSxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDbkosQ0FBQztRQUVELGFBQWE7UUFDYixNQUFNLGtCQUFrQixHQUFHLElBQUksNEJBQWUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQy9ELE1BQU0sRUFBRSxjQUFjO1lBQ3RCLEtBQUssRUFBRTtnQkFDTCxLQUFLLEVBQUUsUUFBUSxDQUFDLEtBQUssSUFBSSw2QkFBNkI7Z0JBQ3RELGdCQUFnQixFQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsSUFBSSxFQUFFO2dCQUNoRCxlQUFlLEVBQUUsUUFBUSxDQUFDLGVBQWUsSUFBSSxjQUFjO2FBQzVEO1lBQ0QsUUFBUSxFQUFFLFFBQVEsQ0FBQyxRQUFRO1lBQzNCLFFBQVEsRUFBRSxRQUFRLENBQUMsUUFBUSxJQUFJLE1BQU07WUFDckMsV0FBVyxFQUFFLFFBQVEsQ0FBQyxXQUFXLElBQUksS0FBSztZQUMxQyxVQUFVLEVBQUUsT0FBTyxDQUFDLFVBQVUsSUFBSSxNQUFNO1lBQ3hDLGFBQWEsRUFBRSxPQUFPLENBQUMsYUFBYSxJQUFJLE9BQU87WUFFL0MsR0FBRyxFQUFFO2dCQUNILGNBQWMsRUFBRSxRQUFRLENBQUMsY0FBYyxJQUFJLFNBQVM7Z0JBQ3BELFlBQVksRUFBRSxRQUFRLENBQUMsWUFBWSxJQUFJLFNBQVM7YUFDakQ7WUFDRCxJQUFJLEVBQUUsWUFBWTtZQUNsQixXQUFXLEVBQUUsbUJBQW1CO1lBQ2hDLGFBQWEsRUFBRSxxQkFBcUI7WUFDcEMsY0FBYyxFQUFFLHNCQUFzQjtTQUN2QyxDQUFDLENBQUM7UUFFSCxVQUFVO1FBQ1YsTUFBTSxlQUFlLEdBQUcsSUFBSSxzQkFBWSxDQUFDLGtCQUFrQixFQUFFLFNBQVMsRUFBRTtZQUN0RSxNQUFNLEVBQUU7Z0JBQ04sd0JBQXdCLEVBQUUsd0JBQXdCO2dCQUNsRCw2QkFBNkIsRUFBRSxTQUFTO2FBQ3pDO1lBQ0QsVUFBVSxFQUFFLFlBQVk7WUFDeEIsYUFBYSxFQUFFLEVBQUUsR0FBRyxFQUFFLGFBQUssQ0FBQyxZQUFZLENBQUMsa0JBQWtCLENBQUMsRUFBRTtTQUMvRCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FBQztJQUNsRCxDQUFDOztBQXZKSCxzQkF3SkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBOYW1lcyB9IGZyb20gJ2NkazhzJztcbmltcG9ydCAqIGFzIGtwbHVzIGZyb20gJ2NkazhzLXBsdXMtMjQnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBQbG9uZURlcGxveW1lbnQgfSBmcm9tICcuL2RlcGxveW1lbnQnO1xuaW1wb3J0IHsgUHJvYmUsIEludE9yU3RyaW5nIH0gZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5pbXBvcnQgKiBhcyBrOHMgZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5pbXBvcnQgeyBQbG9uZVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2UnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFBsb25lQmFzZU9wdGlvbnMge1xuICAvLyBpbWFnZVxuICByZWFkb25seSBpbWFnZT86IHN0cmluZztcbiAgcmVhZG9ubHkgaW1hZ2VQdWxsUG9saWN5Pzogc3RyaW5nO1xuICAvLyByZXBsaWNhc1xuICByZWFkb25seSByZXBsaWNhcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgbWF4VW5hdmFpbGFibGU/OiBudW1iZXIgfCBzdHJpbmc7XG4gIHJlYWRvbmx5IG1pbkF2YWlsYWJsZT86IG51bWJlciB8IHN0cmluZztcbiAgLy8gcmVzb3VyY2VzXG4gIHJlYWRvbmx5IGxpbWl0Q3B1Pzogc3RyaW5nO1xuICByZWFkb25seSBsaW1pdE1lbW9yeT86IHN0cmluZztcbiAgcmVhZG9ubHkgcmVxdWVzdENwdT86IHN0cmluZztcbiAgcmVhZG9ubHkgcmVxdWVzdE1lbW9yeT86IHN0cmluZztcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnQ/OiBrcGx1cy5FbnY7XG4gIC8vIHJlYWRpbmVzcyBQcm9iZVxuICByZWFkb25seSByZWFkaW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSByZWFkaW5lc3NJaW1lb3V0U2Vjb25kcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzUGVyaW9kU2Vjb25kcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzU3VjY2Vzc1RocmVzaG9sZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzRmFpbHVyZVRocmVzaG9sZD86IG51bWJlcjtcbiAgLy8gbGl2ZW5lc3MgUHJvYmVcbiAgcmVhZG9ubHkgbGl2ZW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSBsaXZlbmVzc0lpbWVvdXRTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSBsaXZlbmVzc1BlcmlvZFNlY29uZHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGxpdmVuZXNzU3VjY2Vzc1RocmVzaG9sZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgbGl2ZW5lc3NGYWlsdXJlVGhyZXNob2xkPzogbnVtYmVyO1xufVxuZXhwb3J0IGludGVyZmFjZSBQbG9uZU9wdGlvbnMge1xuICByZWFkb25seSB2ZXJzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBzaXRlSWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGJhY2tlbmQ/OiBQbG9uZUJhc2VPcHRpb25zO1xuICByZWFkb25seSBmcm9udGVuZD86IFBsb25lQmFzZU9wdGlvbnM7XG4gIHJlYWRvbmx5IGltYWdlUHVsbFNlY3JldHM/OiBzdHJpbmdbXTtcblxufVxuXG5leHBvcnQgY2xhc3MgUGxvbmUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIHB1YmxpYyByZWFkb25seSBiYWNrZW5kU2VydmljZU5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGZyb250ZW5kU2VydmljZU5hbWU6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBvcHRpb25zOiBQbG9uZU9wdGlvbnMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiAgICAvLyBHZW5lcmFsXG4gICAgY29uc3Qgc2l0ZUlkID0gb3B0aW9ucy5zaXRlSWQgPz8gJ1Bsb25lJztcblxuICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuICAgIC8vIEJhY2tlbmRcbiAgICBjb25zdCBiYWNrZW5kID0gb3B0aW9ucy5iYWNrZW5kID8/IHt9O1xuICAgIGNvbnN0IGJhY2tlbmRMYWJlbHMgPSB7XG4gICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6ICdwbG9uZS1iYWNrZW5kJyxcbiAgICAgICdhcHAua3ViZXJuZXRlcy5pby9jb21wb25lbnQnOiAnYmFja2VuZCcsXG4gICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vdmVyc2lvbic6IG9wdGlvbnMudmVyc2lvbiA/PyAndW5kZWZpbmVkJyxcbiAgICB9O1xuICAgIGNvbnN0IGJhY2tlbmRQb3J0ID0gODA4MDtcblxuICAgIC8vIFByb2JpbmdcbiAgICBjb25zdCBiYWNrZW5kQWN0aW9uSHR0cEdldDogazhzLkh0dHBHZXRBY3Rpb24gPSB7XG4gICAgICBwYXRoOiAnLycsXG4gICAgICBwb3J0OiBJbnRPclN0cmluZy5mcm9tTnVtYmVyKGJhY2tlbmRQb3J0KSxcbiAgICB9O1xuXG4gICAgY29uc3QgYmFja2VuZExpdmVuZXNzUHJvYmU6IFByb2JlID0ge1xuICAgICAgaHR0cEdldDogYmFja2VuZEFjdGlvbkh0dHBHZXQsXG4gICAgICBpbml0aWFsRGVsYXlTZWNvbmRzOiBiYWNrZW5kLmxpdmVuZXNzSW5pdGlhbERlbGF5U2Vjb25kcyA/PyAzMCxcbiAgICAgIHRpbWVvdXRTZWNvbmRzOiBiYWNrZW5kLmxpdmVuZXNzSWltZW91dFNlY29uZHMgPz8gNSxcbiAgICAgIHBlcmlvZFNlY29uZHM6IGJhY2tlbmQubGl2ZW5lc3NQZXJpb2RTZWNvbmRzID8/IDEwLFxuICAgICAgc3VjY2Vzc1RocmVzaG9sZDogYmFja2VuZC5saXZlbmVzc1N1Y2Nlc3NUaHJlc2hvbGQgPz8gMSxcbiAgICAgIGZhaWx1cmVUaHJlc2hvbGQ6IGJhY2tlbmQubGl2ZW5lc3NGYWlsdXJlVGhyZXNob2xkID8/IDMsXG4gICAgfTtcbiAgICBjb25zdCBiYWNrZW5kUmVhZGluZXNzUHJvYmU6IFByb2JlID0ge1xuICAgICAgaW5pdGlhbERlbGF5U2Vjb25kczogYmFja2VuZC5yZWFkaW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzID8/IDEwLFxuICAgICAgdGltZW91dFNlY29uZHM6IGJhY2tlbmQucmVhZGluZXNzSWltZW91dFNlY29uZHMgPz8gMTUsXG4gICAgICBwZXJpb2RTZWNvbmRzOiBiYWNrZW5kLnJlYWRpbmVzc1BlcmlvZFNlY29uZHMgPz8gMTAsXG4gICAgICBzdWNjZXNzVGhyZXNob2xkOiBiYWNrZW5kLnJlYWRpbmVzc1N1Y2Nlc3NUaHJlc2hvbGQgPz8gMSxcbiAgICAgIGZhaWx1cmVUaHJlc2hvbGQ6IGJhY2tlbmQucmVhZGluZXNzRmFpbHVyZVRocmVzaG9sZCA/PyAzLFxuICAgIH07XG5cbiAgICAvLyBEZXBsb3ltZW50XG4gICAgY29uc3QgYmFja2VuZERlcGxveW1lbnQgPSBuZXcgUGxvbmVEZXBsb3ltZW50KHRoaXMsICdiYWNrZW5kJywge1xuICAgICAgbGFiZWxzOiBiYWNrZW5kTGFiZWxzLFxuICAgICAgaW1hZ2U6IHtcbiAgICAgICAgaW1hZ2U6IGJhY2tlbmQuaW1hZ2UgPz8gJ3Bsb25lL3Bsb25lLWJhY2tlbmQ6bGF0ZXN0JyxcbiAgICAgICAgaW1hZ2VQdWxsU2VjcmV0czogb3B0aW9ucy5pbWFnZVB1bGxTZWNyZXRzID8/IFtdLFxuICAgICAgICBpbWFnZVB1bGxQb2xpY3k6IGJhY2tlbmQuaW1hZ2VQdWxsUG9saWN5ID8/ICdJZk5vdFByZXNlbnQnLFxuICAgICAgfSxcbiAgICAgIHJlcGxpY2FzOiBiYWNrZW5kLnJlcGxpY2FzLFxuICAgICAgbGltaXRDcHU6IGJhY2tlbmQubGltaXRDcHUgPz8gJzUwMG0nLFxuICAgICAgbGltaXRNZW1vcnk6IGJhY2tlbmQubGltaXRNZW1vcnkgPz8gJzUxMk1pJyxcbiAgICAgIHJlcXVlc3RDcHU6IGJhY2tlbmQucmVxdWVzdENwdSA/PyAnMjAwbScsXG4gICAgICByZXF1ZXN0TWVtb3J5OiBiYWNrZW5kLnJlcXVlc3RNZW1vcnkgPz8gJzI1Nk1pJyxcbiAgICAgIHBkYjoge1xuICAgICAgICBtYXhVbmF2YWlsYWJsZTogYmFja2VuZC5tYXhVbmF2YWlsYWJsZSA/PyB1bmRlZmluZWQsXG4gICAgICAgIG1pbkF2YWlsYWJsZTogYmFja2VuZC5taW5BdmFpbGFibGUgPz8gdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICAgIHBvcnQ6IGJhY2tlbmRQb3J0LFxuICAgICAgZW52aXJvbm1lbnQ6IGJhY2tlbmQuZW52aXJvbm1lbnQsXG4gICAgICBsaXZlbmVzc1Byb2JlOiBiYWNrZW5kTGl2ZW5lc3NQcm9iZSxcbiAgICAgIHJlYWRpbmVzc1Byb2JlOiBiYWNrZW5kUmVhZGluZXNzUHJvYmUsXG4gICAgfSk7XG5cbiAgICAvLyBTZXJ2aWNlXG4gICAgY29uc3QgYmFja2VuZFNlcnZpY2UgPSBuZXcgUGxvbmVTZXJ2aWNlKGJhY2tlbmREZXBsb3ltZW50LCAnc2VydmljZScsIHtcbiAgICAgIGxhYmVsczoge1xuICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6ICdwbG9uZS1iYWNrZW5kLXNlcnZpY2UnLFxuICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ3NlcnZpY2UnLFxuICAgICAgfSxcbiAgICAgIHRhcmdldFBvcnQ6IGJhY2tlbmRQb3J0LFxuICAgICAgc2VsZWN0b3JMYWJlbDogeyBhcHA6IE5hbWVzLnRvTGFiZWxWYWx1ZShiYWNrZW5kRGVwbG95bWVudCkgfSxcbiAgICB9KTtcbiAgICB0aGlzLmJhY2tlbmRTZXJ2aWNlTmFtZSA9IGJhY2tlbmRTZXJ2aWNlLm5hbWU7XG5cbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiAgICAvLyBGcm9udGVuZFxuICAgIGNvbnN0IGZyb250ZW5kID0gb3B0aW9ucy5mcm9udGVuZCA/PyB7fTtcbiAgICBjb25zdCBmcm9udGVuZFBvcnQgPSAzMDAwO1xuICAgIGNvbnN0IGZyb250ZW5kTGFiZWxzID0ge1xuICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiAncGxvbmUtZnJvbnRlbmQnLFxuICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdmcm9udGVuZCcsXG4gICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vdmVyc2lvbic6IG9wdGlvbnMudmVyc2lvbiA/PyAndW5kZWZpbmVkJyxcbiAgICB9O1xuXG4gICAgLy8gUHJvYmluZ1xuICAgIGNvbnN0IGZyb250ZW5kQWN0aW9uSHR0cEdldDogazhzLkh0dHBHZXRBY3Rpb24gPSB7XG4gICAgICBwYXRoOiAnLycsXG4gICAgICBwb3J0OiBJbnRPclN0cmluZy5mcm9tTnVtYmVyKGZyb250ZW5kUG9ydCksXG4gICAgfTtcbiAgICBjb25zdCBmcm9udGVuZExpdmVuZXNzUHJvYmU6IFByb2JlID0ge1xuICAgICAgaHR0cEdldDogZnJvbnRlbmRBY3Rpb25IdHRwR2V0LFxuICAgICAgaW5pdGlhbERlbGF5U2Vjb25kczogZnJvbnRlbmQubGl2ZW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzID8/IDMwLFxuICAgICAgdGltZW91dFNlY29uZHM6IGZyb250ZW5kLmxpdmVuZXNzSWltZW91dFNlY29uZHMgPz8gNSxcbiAgICAgIHBlcmlvZFNlY29uZHM6IGZyb250ZW5kLmxpdmVuZXNzUGVyaW9kU2Vjb25kcyA/PyAxMCxcbiAgICAgIHN1Y2Nlc3NUaHJlc2hvbGQ6IGZyb250ZW5kLmxpdmVuZXNzU3VjY2Vzc1RocmVzaG9sZCA/PyAxLFxuICAgICAgZmFpbHVyZVRocmVzaG9sZDogZnJvbnRlbmQubGl2ZW5lc3NGYWlsdXJlVGhyZXNob2xkID8/IDMsXG4gICAgfTtcbiAgICBjb25zdCBmcm9udGVuZFJlYWRpbmVzc1Byb2JlOiBQcm9iZSA9IHtcbiAgICAgIGh0dHBHZXQ6IGZyb250ZW5kQWN0aW9uSHR0cEdldCxcbiAgICAgIGluaXRpYWxEZWxheVNlY29uZHM6IGZyb250ZW5kLnJlYWRpbmVzc0luaXRpYWxEZWxheVNlY29uZHMgPz8gMTAsXG4gICAgICB0aW1lb3V0U2Vjb25kczogZnJvbnRlbmQucmVhZGluZXNzSWltZW91dFNlY29uZHMgPz8gMTUsXG4gICAgICBwZXJpb2RTZWNvbmRzOiBmcm9udGVuZC5yZWFkaW5lc3NQZXJpb2RTZWNvbmRzID8/IDEwLFxuICAgICAgc3VjY2Vzc1RocmVzaG9sZDogZnJvbnRlbmQucmVhZGluZXNzU3VjY2Vzc1RocmVzaG9sZCA/PyAxLFxuICAgICAgZmFpbHVyZVRocmVzaG9sZDogZnJvbnRlbmQucmVhZGluZXNzRmFpbHVyZVRocmVzaG9sZCA/PyAzLFxuICAgIH07XG5cbiAgICAvLyBFbnZpcm9ubWVudCBmb3IgUkFaWkxFXG4gICAgdmFyIGZyb250ZW5kRW52aXJvbm1lbnQgPSBmcm9udGVuZC5lbnZpcm9ubWVudCA/PyBuZXcga3BsdXMuRW52KFtdLCB7fSk7XG4gICAgaWYgKGZyb250ZW5kRW52aXJvbm1lbnQudmFyaWFibGVzLlJBWlpMRV9JTlRFUk5BTF9BUElfUEFUSCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAvLyBjb25uZWN0IHdpdGggYmFja2VuZCBzZXJ2aWNlXG4gICAgICBmcm9udGVuZEVudmlyb25tZW50Py5hZGRWYXJpYWJsZSgnUkFaWkxFX0lOVEVSTkFMX0FQSV9QQVRIJywga3BsdXMuRW52VmFsdWUuZnJvbVZhbHVlKGBodHRwOi8vJHtiYWNrZW5kU2VydmljZS5uYW1lfToke2JhY2tlbmRQb3J0fS8ke3NpdGVJZH1gKSk7XG4gICAgfVxuXG4gICAgLy8gRGVwbG95bWVudFxuICAgIGNvbnN0IGZyb250ZW5kRGVwbG95bWVudCA9IG5ldyBQbG9uZURlcGxveW1lbnQodGhpcywgJ2Zyb250ZW5kJywge1xuICAgICAgbGFiZWxzOiBmcm9udGVuZExhYmVscyxcbiAgICAgIGltYWdlOiB7XG4gICAgICAgIGltYWdlOiBmcm9udGVuZC5pbWFnZSA/PyAncGxvbmUvcGxvbmUtZnJvbnRlbmQ6bGF0ZXN0JyxcbiAgICAgICAgaW1hZ2VQdWxsU2VjcmV0czogb3B0aW9ucy5pbWFnZVB1bGxTZWNyZXRzID8/IFtdLFxuICAgICAgICBpbWFnZVB1bGxQb2xpY3k6IGZyb250ZW5kLmltYWdlUHVsbFBvbGljeSA/PyAnSWZOb3RQcmVzZW50JyxcbiAgICAgIH0sXG4gICAgICByZXBsaWNhczogZnJvbnRlbmQucmVwbGljYXMsXG4gICAgICBsaW1pdENwdTogZnJvbnRlbmQubGltaXRDcHUgPz8gJzUwMG0nLFxuICAgICAgbGltaXRNZW1vcnk6IGZyb250ZW5kLmxpbWl0TWVtb3J5ID8/ICcxR2knLFxuICAgICAgcmVxdWVzdENwdTogYmFja2VuZC5yZXF1ZXN0Q3B1ID8/ICcyMDBtJyxcbiAgICAgIHJlcXVlc3RNZW1vcnk6IGJhY2tlbmQucmVxdWVzdE1lbW9yeSA/PyAnMjU2TWknLFxuXG4gICAgICBwZGI6IHtcbiAgICAgICAgbWF4VW5hdmFpbGFibGU6IGZyb250ZW5kLm1heFVuYXZhaWxhYmxlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgbWluQXZhaWxhYmxlOiBmcm9udGVuZC5taW5BdmFpbGFibGUgPz8gdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICAgIHBvcnQ6IGZyb250ZW5kUG9ydCxcbiAgICAgIGVudmlyb25tZW50OiBmcm9udGVuZEVudmlyb25tZW50LFxuICAgICAgbGl2ZW5lc3NQcm9iZTogZnJvbnRlbmRMaXZlbmVzc1Byb2JlLFxuICAgICAgcmVhZGluZXNzUHJvYmU6IGZyb250ZW5kUmVhZGluZXNzUHJvYmUsXG4gICAgfSk7XG5cbiAgICAvLyBTZXJ2aWNlXG4gICAgY29uc3QgZnJvbnRlbmRTZXJ2aWNlID0gbmV3IFBsb25lU2VydmljZShmcm9udGVuZERlcGxveW1lbnQsICdzZXJ2aWNlJywge1xuICAgICAgbGFiZWxzOiB7XG4gICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogJ3Bsb25lLWZyb250ZW5kLXNlcnZpY2UnLFxuICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ3NlcnZpY2UnLFxuICAgICAgfSxcbiAgICAgIHRhcmdldFBvcnQ6IGZyb250ZW5kUG9ydCxcbiAgICAgIHNlbGVjdG9yTGFiZWw6IHsgYXBwOiBOYW1lcy50b0xhYmVsVmFsdWUoZnJvbnRlbmREZXBsb3ltZW50KSB9LFxuICAgIH0pO1xuICAgIHRoaXMuZnJvbnRlbmRTZXJ2aWNlTmFtZSA9IGZyb250ZW5kU2VydmljZS5uYW1lO1xuICB9XG59Il19