# Generated by Django 5.2.7 on 2025-11-01 05:22

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("django_forms_workflows", "0003_postsubmissionaction"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="FormTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Template name (e.g., 'Contact Form', 'Travel Request')",
                        max_length=200,
                    ),
                ),
                (
                    "slug",
                    models.SlugField(help_text="URL-friendly identifier", unique=True),
                ),
                (
                    "description",
                    models.TextField(
                        help_text="Description of what this template is for"
                    ),
                ),
                (
                    "category",
                    models.CharField(
                        choices=[
                            ("general", "General"),
                            ("hr", "Human Resources"),
                            ("it", "IT & Technology"),
                            ("finance", "Finance"),
                            ("facilities", "Facilities"),
                            ("survey", "Survey"),
                            ("request", "Request"),
                            ("feedback", "Feedback"),
                            ("other", "Other"),
                        ],
                        default="general",
                        help_text="Template category for organization",
                        max_length=50,
                    ),
                ),
                (
                    "template_data",
                    models.JSONField(
                        help_text="JSON structure containing form definition and fields"
                    ),
                ),
                (
                    "preview_url",
                    models.URLField(
                        blank=True,
                        help_text="Optional URL to preview image or screenshot",
                        max_length=500,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Inactive templates are hidden from users",
                    ),
                ),
                (
                    "is_system",
                    models.BooleanField(
                        default=False, help_text="System templates cannot be deleted"
                    ),
                ),
                (
                    "usage_count",
                    models.IntegerField(
                        default=0,
                        help_text="Number of times this template has been used",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who created this template",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Form Template",
                "verbose_name_plural": "Form Templates",
                "ordering": ["category", "name"],
            },
        ),
    ]
