"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this, { stack: props.assertionStack });
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.node.path,
            assertionStackName: this._assert.scope.stackName,
            stacks: props.stacks.map(s => s.node.path),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.72.1-alpha.0" };
exports.IntegTestCase = IntegTestCase;
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends aws_cdk_lib_1.Stack {
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
}
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.72.1-alpha.0" };
exports.IntegTestCaseStack = IntegTestCaseStack;
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        this.enableLookups = props.enableLookups;
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
            assertionStack: props.assertionStack,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                (0, aws_cdk_lib_1.attachCustomSynthesis)(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases, this.enableLookups);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.72.1-alpha.0" };
exports.IntegTest = IntegTest;
//# sourceMappingURL=data:application/json;base64,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