"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Match = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Partial and special matching during assertions.
 */
class Match {
    /**
     * Matches the specified pattern with the array found in the same relative path of the target.
     * The set of elements (or matchers) must be in the same order as would be found.
     * @param pattern the pattern to match
     */
    static arrayWith(pattern) {
        return { $ArrayWith: pattern };
    }
    /**
     * Matches the specified pattern to an object found in the same relative path of the target.
     * The keys and their values (or matchers) must be present in the target but the target can be a superset.
     * @param pattern the pattern to match
     */
    static objectLike(pattern) {
        return { $ObjectLike: pattern };
    }
    /**
     * Matches targets according to a regular expression
     */
    static stringLikeRegexp(pattern) {
        return { $StringLike: pattern };
    }
    /**
     * Matches any string-encoded JSON and applies the specified pattern after parsing it.
     * @param pattern the pattern to match after parsing the encoded JSON.
     */
    static serializedJson(pattern) {
        return { $SerializedJson: pattern };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Match[_a] = { fqn: "@aws-cdk/integ-tests-alpha.Match", version: "2.72.1-alpha.0" };
exports.Match = Match;
//# sourceMappingURL=data:application/json;base64,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