"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ActualResult[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ActualResult", version: "2.72.1-alpha.0" };
exports.ActualResult = ActualResult;
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     * });
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
ExpectedResult[_b] = { fqn: "@aws-cdk/integ-tests-alpha.ExpectedResult", version: "2.72.1-alpha.0" };
exports.ExpectedResult = ExpectedResult;
//# sourceMappingURL=data:application/json;base64,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