"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCallBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for an ApiCall
 */
class ApiCallBase extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.flattenResponse = 'false';
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        this.expectedResult = expected.result;
        return this;
    }
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        next.node.addDependency(this);
        return next;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiCallBase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ApiCallBase", version: "2.72.1-alpha.0" };
exports.ApiCallBase = ApiCallBase;
//# sourceMappingURL=data:application/json;base64,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