"""This Python module is a collection of jokes from multiple websites. I do not own any of these jokes and am not the
rightful owner. The websites used for this package are listed below:
https://www.skiptomylou.org/funny-jokes/#h-over-50-funny-jokes https://bayart.org/funny-clever-short-jokes-laugh/
https://www.skiptomylou.org/dad-jokes/
https://www.skiptomylou.org/free-printable-halloween-lunch-box-jokes/"""

import random

funny_jokes = [
    "I'm not a vegetarian because I love animals, it's because I hate plants.",
    "A plateau is the highest form of flattery.",
    "I used to think the brain was the most important organ. Then I thought, look what’s telling me that.",
    "It’s hard to explain puns to kleptomaniacs because they always take things literally.",
    "Time flies like an arrow, fruit flies like a banana.",
    "The midget fortune teller who kills his customers is a small medium at large.",
    "A soldier survived mustard gas in battle, and then pepper spray by the police. He’s now a seasoned veteran.",
    "A farmer in the field with his cows counted 196 of them, but when he rounded them up he had 200.",
    "What’s the best thing about Switzerland? I don’t know, but their flag is a huge plus.",
    "A Buddhist walks up to a hotdog stand and says, “Make me one with everything.”",
    "What does a nosey pepper do? Get jalapeño business.",
    "I’m addicted to brake fluid, but I can stop whenever I want.",
    "What is Bruce Lee’s favorite drink? Wataaaaah!",
    "What’s the difference between my ex and the titanic? The titanic only went down on 1,000 people",
    "The dyslexic devil worshipper sold his soul to Santa.",
    "Why is 6 afraid of 7? Because 7 is a registered 6 offender.",
    "You kill vegetarian vampires with a steak to the heart.",
    "Two fish are sitting in a tank. One looks over at the other and says: “Hey, do you know how to drive this thing?”",
    "“This is your captain speaking, AND THIS IS YOUR CAPTAIN SHOUTING.”",
    "There was a prison break and I saw a midget climb up the fence. As he jumped down her sneered at me and I thought, well that’s a little condescending.",
    "I told my doctor that I broke my arm in two places. He told me to stop going to those places.",
    "Atheism is a non-prophet organization",
    "If you want to catch a squirrel just climb a tree and act like a nut.",
    "What do you call it when Batman skips church? Christian Bale.",
    "funny short jokes from Bill Cosby",
    "A magician was walking down the street and turned into a grocery store.",
    "What’s orange and sounds like a parrot? A carrot.",
    "Why don’t you ever see hippopotamus hiding in trees? Because they’re really good at it.",
    "Did you hear about the Mexican train killer? He had locomotives.",
    "How do you keep an idiot in suspense?",
    "Two whales walk into a bar. The first one says, “Weeeeeooooouuuhhhh”. The next whale says, “Shut up, Steve. You’re drunk.”",
    "How does NASA organize their company parties? They planet.",
    "Why can’t you hear a pterodactyl go to the bathroom? Because the “P” is silent.",
    "What kind of shoes do ninjas wear? Sneakers.",
    "I hate Russian dolls…so full of themselves",
    "What’s E.T. short for? Because he’s only got little legs.",
    "“I stand corrected,” said the man in the orthopedic shoes.",
    "Why does Snoop Dogg carry an umbrella? Fo’ drizzle.",
    "Did you hear about the new corduroy pillows? They’re making headlines everywhere!",
    "Wanna hear a joke about Potassium? (whether they say ‘yes’ or ‘no’): K.",
    "What’s the difference between a golfer and a skydiver? A golfer goes *whack* “damn” and a skydiver goes “damn” *whack*",
    "What time is it when you have to go to the dentist? Tooth-hurtie.",
    "A baby seal walks into a club.",
    "My grandad has the heart of a lion and a life time ban from the San Diego Zoo.",
    "My friend recently got crushed by a pile of books, but he’s only got his shelf to blame.",
    "I went on a once in a lifetime holiday. Never again.",
    "What did Jay-Z call his girlfriend before they got married? Feyoncé.",
    "Rick Astley will let you borrow any movie from his Pixar collection, except one. He’s never gonna give you Up.",
    "It takes a lot of balls to golf like me.",
    "There is no doubt that funny birthday wishes will put a smile on someone’s face on their birthday.",
    "I asked my North Korean friend how it was there, he said he couldn’t complain.",
    "There’s no “I” in Denial.",
    "Last night me and my girlfriend watched three DVDs back to back. Luckily I was the one facing the telly.",
    "What do you call dangerous precipitation? A rain of terror.",
    "What’s the best part about living in Switzerland? Not sure, but the flag is a big plus.",
    "Exaggerations went up by a million percent last year.",
    "Two fish are in a tank. One turns to the other and asks “How do you drive this thing?”",
    "Why can’t a bike stand on its own? It’s two tired.",
    "They all laughed when I said I wanted to be a comedian. Well, they’re not laughing now.",
    "Why didn’t the lifeguard save the hippie? Because he was too far out man!",
    "Last night I almost had a threesome, I only needed two more people!",
    "I used to be addicted to soap, but I’m clean now.",
    "What do you call a big pile of kittens? A meowntain.",
    "I wondered why the baseball was getting bigger. Then it hit me.",
    "Two penguins walk into a bar… which is stupid because the second one should have seen it.",
    "You want to hear a pizza joke? Never mind, it’s pretty cheesy.",
    "Let funny nicknames will bring joy and help you show how much they mean to you.",
    "What is the difference between ignorance and apathy? I don’t know, and I don’t care.",
    "Dry erase boards are remarkable.",
    "What do you call a magic dog? A Labracadabrador.",
    "Dwarfs and midgets have very little in common.",
    "How do you make Holy water? Boil the hell out of it.",
    "I was wondering why does a frisbee appear larger the closer it gets…. then it hit me.",
    "PMS should just be called ovary-acting.",
    "Have I told you this deja vu joke before?",
    "Pampered cows produce spoiled milk.",
    "Learn sign language, it’s very handy.",
    "I started a band called 999 Megabytes — we haven’t gotten a gig yet.",
    "Where do you find a cow with no legs? Right where you left it.",
    "Just went to an emotional wedding. Even the cake was in tiers.",
    "When you get a bladder infection, urine trouble.",
    "Nostalgia isn’t what it used to be…",
    "I wrote a song about a tortilla. Well actually, it’s more of a wrap.",
    "What do you call a dinosaur with an extensive vocabulary? A thesaurus.",
    "How did the hipster burn his tongue? He drank his coffee before it was cool.",
    "I didn’t know my dad was a construction site thief, but when I got home all the signs were there.",
    "Why did the scarecrow win an award? Because he was outstanding in his field.",
    "Why did the melon jump into the lake? It wanted to be a water-melon.",
    "What did the duck say when it bought lipstick? “Put it on my bill.”",
    "What do you call a pig that does karate? A pork chop.",
    "What has a bed that you can’t sleep in? A river.",
    "Why were the teacher’s eyes crossed? She couldn’t control her pupils.",
    "What starts with E, ends with E, and has only 1 letter in it? An Envelope.",
    "How does the ocean say hello? It waves.",
    "What lights up a soccer stadium? A soccer match.",
    "What creature is smarter than a talking parrot? A spelling bee.",
    "Which U.S. state has the smallest soft drinks? Minnesota (as in, “mini-soda”).",
    "Why couldn’t the leopard play hide and seek? Because he was always spotted.",
    "Apparently, you can’t use “beef stew” as a password. It’s not stroganoff.",
    "Why did the drum take a nap? It was beat.",
    "Where do hamburgers go dancing?  They go to the meat-ball.",
    "Why did the tomato turn red?  It saw the salad dressing.",
    "Why shouldn’t you write with a broken pencil? Because it’s pointless.",
    "What do you call two monkeys that share an Amazon account? Prime mates.",
    "Why are teddy bears never hungry? Because they’re always stuffed!",
    "Why did the tree go to the dentist? It needed a root canal.",
    "If athletes get athlete’s foot, what do elves get? Mistle-toes.",
    "Why couldn’t the pony sing? Because she was a little hoarse.",
    "Where do cows go for entertainment? The mooooo-vies!",
    "What do you call a pig that does karate? A pork chop.",
    "How does NASA organize a party? They planet.",
    "Why did Adele cross the road?  To sing, “Hello from the other side!",
    "What runs around a yard without actually moving? A fence.",
    "What’s an astronaut’s favorite candy? A Mars bar.",
    "Where do sheep go to get their hair cut?  The baa-baa shop.",
    "Why are there gates around cemeteries? Because people are dying to get in.",
    "What do you get when you cross a snake with a pie? A pie-thon!",
    "Why is Peter Pan always flying? He neverlands.",
    "What’s the most musical part of the chicken? The drumstick.",
    "Why do seagulls fly over the sea? Because if they flew over a bay, they would be bagels.",
    "How do you know when the moon has had enough to eat? When it’s full.",
    "What kind of music do planets like? Neptunes.",
    "Why can’t you trust an atom? Because they make up everything.",
    "What do you call a group of disorganized cats? A cat-tastrophe.",
    "Why do bees have sticky hair? Because they use honeycombs.",
    "Where do you learn to make banana splits? At sundae school.",
    "How do you tell if a vampire is sick? By how much he is coffin.",
    "Why are ghosts good cheerleaders?  Because they have a lot of spirit!",
    "What happens to a frog’s car when it breaks down? It gets toad away.",
    "Why did the witches’ team lose the baseball game?  Their bats flew away.",
    "Why did the school kids eat their homework? Because their teacher told them it was a piece of cake.",
    "Why are hairdressers never late for work?  Because they know all the short cuts!",
    "What is the difference between a teacher and a train? One says, “Spit out your gum,” and the other says, “Choo choo choo!”",
    "Why does Humpty Dumpty love autumn?  Because Humpty Dumpty had a great fall.",
    "How do you make a tissue dance? Put a little boogie in it.",
    "What is the tallest building in the entire world?  The library, because it has so many stories.",
    "How do trees access the internet? They log in.",
    "What do you get when you cross a fish and an elephant?  Swimming trunks.",
    "Why did the painting go to jail?  It was framed.",
    "Why did Cinderella get kicked off the soccer team? Because she ran away from the ball.",
    "Why do we tell actors to break a leg?  Because every play has a cast.",
    "Helvetica and Times New Roman walk into a bar. The bartender says, “We don’t serve your type.”",
    "Why wouldn’t the shrimp share his treasure? Because he was a little shellfish.",
    "Why should you knock on the refrigerator before opening the door? In case there is a salad dressing",
    "When is a door not a door? When it is ajar",
    "Why did the bee get married? He found his honey.",
    "Did you hear the rumor about the butter? Never mind, I shouldn’t spread it!",
    "I’m really good at sleeping. I can do it with my eyes closed.",
    "What do you call a fake noodle? An impasta",
    "Why can’t a bicycle stand on it’s own? It is two tired.",
    "What is the opposite of a croissant? A happy uncle.",
    "What does it make you if you see a robbery at an Apple Store? An iwitness.",
    "What is an astronaut’s favorite key on a keyboard? The space bar.",
    "What is brown and sticky? A stick",
    "Can February March? No but April May"
]
clever_jokes = [
    "What kind of exercise do lazy people do? Diddly-squats.",
    "What do you call a pony with a cough? A little horse!",
    "What is Forrest Gump’s password? 1Forrest1.",
    "Why did the M&M go to school? He wanted to be a Smartie.",
    "What did one traffic light say to the other? Stop looking at me, I’m changing!",
    "What do you call bears with no ears? B.",
    "What’s a foot long and slippery? A slipper!",
    "Why do French people eat snails? They don’t like fast food!",
    "What’s red and moves up and down? A tomato in an elevator!",
    "I invented a new word today: Plagiarism.",
    "What is sticky and brown? A stick!",
    "How does a rabbi make coffee? Hebrews it!",
    "Rest in peace boiling water. You will be mist!",
    "How do you throw a space party? You planet!",
    "Want to hear a construction joke? Oh never mind, I’m still working on that one.",
    "Why don’t scientists trust atoms? Because they make up everything!",
    "I hate Russian dolls… they’re so full of themselves!",
    "Talk is cheap? Have you ever talked to a lawyer?",
    "Why did the gym close down? It just didn’t work out!",
    "Two artists had an art contest. It ended in a draw!",
    "I have a fear of speed bumps. But I am slowly getting over it.",
    "You can only get spoiled milk from a pampered cow.",
    "What do you call a boomerang that doesn’t come back? A stick!",
    "You know what I saw today? Everything I looked at.",
    "What are a shark’s two most favorite words? Man overboard!",
    "If we shouldn’t eat at night, why do they put a light in the fridge?",
    "Have you ever tried eating a clock? It’s really time-consuming, especially if you go for seconds.",
    "Why are ghosts such bad liars? Because they are easy to see through.",
    "It’s cleaning day so naturally, I’ve already polished off a whole chocolate bar.",
    "What did the buffalo say when his son left for college? Bison!",
    "Here, I bought you a calendar. Your days are numbered now.",
    "Where do fish sleep? In the riverbed.",
    "What did one plate say to his friend? Tonight, dinner’s on me!",
    "Where are average things manufactured? The satisfactory.",
    "I tried to sure the airport for misplacing my luggage. I lost my case.",
    "Why doesn’t the sun go to college? Because it has a million degrees!",
    "I was wondering why the frisbee was getting bigger, then it hit me.",
    "I have many jokes about rich kids—sadly none of them work.",
    "What do you call a singing laptop? A Dell!",
    "Why was six afraid of seven? Because seven ate nine.",
    "Why are skeletons so calm? Because nothing gets under their skin.",
    "How do trees get online? They just log on!",
    "Some people think prison is one word…but to robbers it’s the whole sentence.",
    "My girlfriend treats me like a god. She ignores my existence and only talks to me when she needs something.",
    "Where does the sheep get his hair cut? The baa baa shop!",
    "Why did the orange stop? It ran out of juice!",
    "I never make mistakes. …I thought I did once, but I was wrong.",
    "What does the man in the moon do when his hair gets too long? Eclipse it!",
    "What did 0 say to 8? Nice belt!",
    "I’m addicted to brake fluid, but I can stop whenever I want.",
    "“This is your captain speaking, AND THIS IS YOUR CAPTAIN SHOUTING.”",
    "What’s orange and sounds like a parrot? A carrot.",
    "What’s E.T. short for? Because he’s only got little legs.",
    "I was wondering, why does a frisbee appear larger the closer it gets… then it hit me.",
    "“I stand corrected,” said the man in the orthopedic shoes.",
    "Why should you worry about the math teacher holding graph paper?",
    "She’s definitely plotting something.",
    "Why is it sad that parallel lines have so much in common?",
    "Because they’ll never meet.",
    "Are monsters good at math?",
    "Not unless you Count Dracula.",
    "Why are obtuse angles so depressed?",
    "Because they’re never right.",
    "What’s the best way to woo a math teacher?",
    "Use acute angle.",
    "How do you stay warm in any room?",
    "Sit in the corner, where it’s always 90 degrees.",
    "Why should the number 288 never be mentioned? It’s two gross.",
    "Why was the math book sad? Because it had so many problems.",
    "Why was six scared of seven? Because seven “ate” nine."
]
dad_jokes = [
    "What do you call a mac ‘n’ cheese that gets all up in your face? …Too close for comfort food!",
    "Why did the scarecrow win an award?… Because he was outfield.",
    "Why couldn’t the bicycle stand up by itself?… It was two tired!",
    "I’ll call you later… Don’t call me later, call me Dad!",
    "Why do melons have weddings?… Because of they cantaloupe!",
    "When you see a cemetery …”Look we are in the dead center of town”.",
    "You’re American when you go into the bathroom, and you’re American when you come out, but do you know what you are while you’re in there?… European.",
    "What’s brown and sticky? A Stick",
    "A woman is on trial for beating her husband to death with his guitar collection… The judge asks her, “First offender?” She says, “No, first a Gibson! Then a Fender!”",
    "So a vowel saves another vowel’s life…The other vowel says, “Aye E! I owe you!”",
    "How many apples grow on a tree? All of them!",
    "Spring is here! I got so excited … … I wet my plants!",
    "When the grocery store clerk asks me if I want the milk in a bag, I always tell him… “No, I’d rather drink it out of the carton!”",
    "My wife told me I had to stop acting like a flamingo. So I had to put my foot down!",
    "I tell dad jokes but I have no kids… I’m a faux pa!",
    "How does a penguin build its house? Igloos it together!",
    "If you see a robbery at an Apple Store does that make you… … an iWitness?!",
    "Why did the invisible man turn down the job offer?… He couldn’t see himself doing it!",
    "The difference between a numerator and a denominator is a short line… Only a fraction of people will understand this!",
    "What’s the longest word in the dictionary?… Smiles. Because there’s a mile between the two S’s.",
    "I can’t tell if I like my new blender… It keeps giving me mixed results.",
    "I love having a short son… Because he is always willing to look up to me.",
    "A horse walks into a bar… The bartender says “hey”… The horse replies “sure”",
    "My wife is so negative. I remembered the car seat, the stroller, AND the diaper bag. Yet all she can talk about is how I forgot the baby.",
    "What do you call a fish with no eyes? … A fsh.",
    "A Ham sandwich walks into a bar and orders a drink. The bartender says, “Sorry we don’t serve food.”",
    "After a few drinks, the giraffe falls over and dies. The man begins to walk out when the bartender stops him."
    "“Hey, you can’t leave that lyin’ there!” The bartender yells out. The man turns around: “It’s not a lion. It’s a giraffe.”",
    "I’m reading a book about antigravity… It’s impossible to put down!",
    "What do you call a cow that can cut the grass?…  Mulan.",
    "What do you call a cow with no legs? Ground beef!"
    "What do you call a cow with 3 legs? Lean beef!",
    "What do you call a lazy bull? A bulldozer",
    "Why don’t trees use the train? They can never decide on a root",
    "How can hurricanes see? They have eyes",
    "What type of brief packs a punch? A boxer brief",
    "What type of store do apes own? Monkey business",
    "What 3 letters hold a lot of data? USB",
    "What type of bug has good etiquette? A lady bug",
    "Why do bananas like gymnastics? They like doing the splits",
    "How should you greet women’s shoes? Hi, heels",
    "What’s a top you can’t wear? A laptop",
    "What did the Brittish umpire say to the batter? Europe",
    "What bow cannot be tied? A rainbow",
    "How is a bad joke like a broken pencil? They have no point",
    "What button can’t unbutton? Your belly button",
    "What toons do cows enjoy? Moo-sic",
    "What type of check has no money? spell-check",
    "What is a good spot for a taste bud? I forgot… it is on the tip of my tongue",
    "What do you call the King’s rabbit? The hare to the throne",
    "What did one eye say to the other? Between us, something smells",
    "Which sport involves the most chewing? Gumball",
    "What does a cold stereo play? Cool music",
    "What type of doctor can work in an auto body shop? A dent-ist",
    "What kind of tree grows in your hand? A palm tree",
    "When are rip tides dangerous? Current-ly What can open doors and is full of letters? Keys",
    "What do people and trees each have? Roots",
    "What kind of tree survives without water? A family tree",
    "How does a tree go home when it is ready? It leaves",
    "Why do hamburgers fly south for the winter? So they don’t freeze their buns!",
    "What Do You Get When You Have A Cat That Eats Lemons? A sour puss",
    "When do you stop at green and go at red? When you’re eating a watermelon!"
    "Why was the cat afraid of the tree? Because of its bark!",
    "What did the cheerleaders say to the ghost? Show your spirit!",
    "What foods are good for young people? The pro-teens!",
    "Why couldn’t the leopard go on vacation? He couldn’t find the right spot!",
    "Why couldn’t the shoes go out and play? They were all tied up",
    "What room can no one enter? A mushroom",
    "What has no legs but can do a split? A banana",
    "What did one campfire say to the other? Let’s go out one of these days!",
    "How do you communicate with a fish? You drop it a line",
    "Where does a penguin keep his money? A snow bank",
    "What do you get if you cross a stereo and a refrigerator? Very cool music!",
    "What do you call a car that never stops? Cargo!"
    "How did dinosaurs decorate their bedrooms? With rep-tiles! ",
    "Where did the kittens go on the class trip? To the meowseum",
    "What falls down but never gets hurt? Snow!",
    "What planet is like a circus? Saturn, it has three rings!",
    "What’s a parasite? A site you see in Paris",
    "What do you call a lease of false teeth? A dental rental",
    "Why do phones ring? Because they can’t talk!",
    "What did the finger say to the thumb? I’m totally in glove with you dear",
    "Why did the man throw his margarine? He wanted to see the butter fly",
    "Where can you find an ocean without water? On a map",
    "Why did the ghost float across the road? Because he couldn’t walk",
    "How do you mend a broken jack o’ lantern? With a pumpkin patch",
    "What happens when you cross a singer and a rocking chair? You rock to the beat",
    "What do you get when you cross a grape with a lion? A grape nobody picks on",
    "What kind of star could hurt you? A shooting star",
    "What has four legs and goes booo? A cow with a cold",
    "What is a caterpillar afraid of? A dogerpillar! Who has the strongest underwear? Arnold Short-sineger",
    "Why did the elephant decide not to move? Because he couldn’t lift his trunk",
    "What is yellow, has wheels and lies on its back? A dead school bus",
    "What do you get when you cross a shark and ‘flipper’? A fat shark",
    "What did the lamp say to the other lamp? You turn me on",
    "Why did the chicken go to the library? To check out a bawk, bawk, bawk,bawk",
    "If a woodchuck had a name, what would it be? Chuck Wood",
    "Which are the stronger days of the week? Saturday and Sunday, the rest are weekdays",
    "Which runs faster, hot or cold? Hot, everyone can catch a cold",
    "What’s yellow and writes? A ballpoint banana",
    "Why did the turkey cross the road? To get to the chicken",
    "What did the man say when the picture fell on his head? I’ve been framed!",
    "Did you hear about the mummies who went to the theater? They gave the actors’ stage fright",
    "What did the sink say to the water faucet? You’re a real drip",
    "where do pigs park their cars? In a porking lot",
    "Why do winners always win? It beats me",
    "What moth is really huge? A mam-moth How do potatoes solve fights? They hash it out",
    "How is a USB like an elephant? They both have memory skills",
    "Why did the traffic light turn red? It was embarrassed to change in the street",
    "What did the miner think about this joke? He dug it"
]
christmas_jokes = [
    "What do you call Santa Claus when he stops moving? Santa Pause",
    "How do sheep say Merry Christmas in Mexico? Fleece Navidad",
    "What’s red, white and blue on Christmas? A sad candy cane",
    "What comes at the end of Christmas Day? The letter “Y”",
    "What do wild animals sing at Christmastime? Jungle bells, jungle bells, jungle all the way",
    "Why did Santa’s helper go to a therapist? Because he had low elf esteem",
    "Why did the ornament say he was addicted to Christmas? He was hooked on trees his whole life",
    "What’s the difference between the Christmas alphabet and the ordinary alphabet? The Christmas alphabet has Noel",
    "hat do you get if you cross Santa with a duck? Christmas Quacker",
    "What do sheep say to each other at Christmas? Merry Christmas to ewe",
    "What do you get if you cross Santa with a detective? Santa Clues",
    "What did one snowman say to the other? Do you smell carrots?",
    "What do you call an elf who steals gift wrap from the rich and gives it to the poor? Ribbon Hood",
    "What breakfast cereal does Frosty the Snowman eat? Snowflakes",
    "What would a reindeer do if it lost its tail? They would go to a “re-tail” shop for a new one",
    "Why is a reindeer always wet? Because he’s a ‘rain’ deer",
    "What do you call a dog who works for Santa Claus? Santa Paws",
    "What is a parents favorite Christmas carol? Silent night",
    "What do angry mice send to each other at Christmas? Cross Mouse Cards",
    "What did one Christmas light say to the other Christmas light? You light me up",
    "Why do Mummies like Christmas so much? Because of all the wrapping",
    "What falls at the North Pole but never gets hurt? Snow",
    "What does the Gingerbread Man use to make his bed? Cookie sheets",
    "What do reindeer say before they tell a joke? This will sleigh you",
    "Why are Christmas trees so bad at sewing? They always drop their needles",
    "How do you know Santa is good at karate? He has a black belt",
    "How much did Santa pay for his sleigh? Nothing, it was on the house",
    "What says, ‘Oh Oh Oh’? Santa walking backward",
    "Which of Santa’s reindeer has bad manners? Rude-alph",
    "Why does Santa have three gardens? So he can ho, ho, ho",
    "Where does Santa keep his money? A Snow Bank",
    "What do you get if you cross a Christmas tree with an iPad? A Pineapple",
    "Why did Rudolph get a bad report card? Because he went down in history",
    "Why is it so cold at Christmas? Because it’s in Decembrrrr"
]
halloween_jokes = [
    "Why is a ghost a messy eater? He is always gobblin",
    "Why don’t mummies take vacations? They are afraid they will relax and unwind",
    "Why didn’t the skeleton cross the street? He didn’t have any guts",
    "How can you tell a vampire likes baseball? At night he turns into a bat",
    "What is a witch’s favorite subject in school? Spelling",
    "Why are ghosts bad at telling lies? You can see right through them",
    "What kind of mistakes do ghosts make? Boo Boos",
    "What is a ghost’s favorite street? A dead end",
    "Why are graveyards so noisy? Because of all the coffin! What do spiders like to do? Fly fishing",
    "What is a mummy’s favorite kind of music? Wrap music",
    "What do you call a witch at the beach? A sand witch!"
    "What happens when two vampire bats meet? Love at first bite",
    "Why did the skeleton cross the road? To get to the body shop",
    "What does Count Dracula use to cross the sea? A blood vessel",
    "Why did the Headless Horseman go into business? To get ahead in life",
    "What do you call witches who live together? Broom mates",
    "Why don’t mummies take the day off? They don’t want to unwind",
    "Why is it so unpleasant to hang out with Dracula? He’s a pain in the neck",
    "What does the ghost call his sweetheart? His ghoul friend",
    "What does a ghost need to go spook forest creatures? A haunting license",
    "Why do they put fences around the graveyard? People are dying to get in",
    "Where does a vampire keep his money? A blood bank",
    "What does a ghost do to stay safe in a car? Puts on his sheet belt",
    "What’s a little ghost’s favorite dessert? I-scream"
    "What room is left out of a ghost’s house? The living room",
    "Where do ghosts go on vacation? Lake Erie",
    "What do skeletons order at restaurants?  Spare ribs",
    "What Would you find on a haunted beach? A Sand-witch",
    "Why don’t mummies have friends? Because they are too wrapped up in themselves"
]
easter_jokes = [
    "How does the Easter Bunny stay fit? Egg-ercise",
    "Where does a bunny go if you give it a pair of socks? A sock hop",
    "What happened to the Easter Bunny when he misbehaved at school? He was eggspelled",
    "What does the Easter Bunny get for making a basket? Two points, just like anyone else",
    "Why did the Easter Bunny cross the road? Because the chicken had his eggs",
    "Did you hear about the lady whose house was infested with Easter eggs? She had to call an eggs-terminator",
    "What sport are the eggs good at? Running",
    "What do you get if you pour boiling hot water down a rabbit hole? Hot cross bunnies",
    "How does the Easter Bunny keep his fur neat? With a hare brush",
    "Why shouldn’t you tell an Easter Egg a joke? Because it might crack up",
    "What do you get if you cross a bee and a bunny? A honey bunny",
    "Where does the Easter bunny eat breakfast? IHOP",
    "How does the Easter Bunny keep his fur in place? With hare spray",
    "What day does an Easter egg hate the most? Fry-days",
    "What do you call a forgetful rabbit? A hare-brain",
    "What happened when the Easter Bunny met the rabbit of his dreams? They lived hoppily ever after",
    "What is the Easter Bunny’s favorite type of music? Hip-Hop",
    "Why is the bunny the luckiest animal? Because they have four rabbit’s feet",
    "How does the Easter Bunny travel? By Hare-Plane",
    "What is the best way to send a letter to the Easter Bunny? Hare-mail",
    "What did the rabbit say to the carrot? It’s been nice gnawing you",
    "What kind of bunny can’t hop? A chocolate one",
    "What do you call ten rabbits marching backward? A receding hare-line",
    "Why did the Easter egg hide? He was a chicken",
    "How do you know that carrots are good for your eyes? Have you ever seen a rabbit wearing glasses?",
    "What did the Easter bunny say about the Easter parade? It was eggs-cellent",
    "How does the Easter Bunny dry his fur? With a hare dryer",
    "How can you tell where the Easter Bunny has been? Eggs mark the spot",
    "What are the Easter Bunny’s favorite stories? Ones with Hoppy Endings",
    "What do you call a mischievous egg? A practical yolker What do you call a rabbit with fleas? Bugs Bunny",
    "Where does the Easter Bunny get the eggs from? Eggplants",
    "Why was the little girl sad after the race? Because an egg beater",
    "What kind of jewelry does the Easter Bunny wear? 18 carrot gold",
    "How can you tell which rabbits are the oldest in a group? Just look for the gray hares",
    "Why can’t a bunny’s nose be 12 inches long? Because then it would be a foot",
    "What do you get if you cross a hen with a dog? Pooched eggs",
    "What did the Easter Egg say to the other Easter Egg? Have you heard any good yolks today?",
    "Why Couldn’t the Easter Egg Family Watch Cable? Because their TV was scrambled",
    "Why was the Easter Bunny so upset? Because he was having a bad hare day",
    "How does a rabbit make gold soup? He begins with 24 carrots",
    "Why did the Easter Bunny have to fire the duck? He kept quacking the eggs",
    "What is the Easter Bunny’s favorite dance? The bunny hop",
    "What is The Easter Bunny’s favorite state capital? Albunny,New York",
    "Did you hear about the lady whose house was infested with Easter Eggs? She had to call an eggs-terminator",
    "How do you know when you’re eating rabbit stew? When it has hares in it",
    "Why did the egg go to the baseball game? For the egg-stra innings",
    "How does a rabbit throw a tantrum? He gets hopping mad",
    "How many Easter eggs can you put in an empty basket? Only one – after that it’s not empty anymore",
    "What do you call a sleepy bunny? Egg-zausted",
    "What do you call a bunny who tells jokes? A funny bunny"
]

all_jokes = dad_jokes+clever_jokes+funny_jokes+easter_jokes+christmas_jokes+halloween_jokes

def get_joke_from(type):
    """returns one joke from a specified type. Check joke_types() for a list of jokes."""
    return random.choice(type)

def get_joke():
    """returns one random joke selected from all joke types"""
    return random.choice(all_jokes)

def joke_types():
    """returns and prints all joke types"""
    print("dad_jokes, clever_jokes, funny_jokes, easter_jokes, christmas_jokes, halloween_jokes")
    return all_jokes

def get_jokelist(n):
    """returns a list of a specified number of jokes from a collection of all types"""
    joke_list = []
    for i in range(n):
        joke = random.choice(all_jokes)
        if joke not in joke_list:
            joke_list.append(joke)
        else:
            i -= 1
    return joke_list

def get_jokelist_from(n, type):
    """returns a list of a specified number of jokes from a specified joke type"""
    joke_list = []
    for i in range(n):
        joke = random.choice(type)
        if joke not in joke_list:
            joke_list.append(joke)
        else:
            i -= 1
    return joke_list
