# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['Ec2CredentialV3Args', 'Ec2CredentialV3']

@pulumi.input_type
class Ec2CredentialV3Args:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Ec2CredentialV3 resource.
        :param pulumi.Input[str] project_id: The ID of the project the EC2 credential is created
               for and that authentication requests using this EC2 credential will
               be scoped to.
        :param pulumi.Input[str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new EC2 credential.
        :param pulumi.Input[str] user_id: The ID of the user the EC2 credential is created for.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project the EC2 credential is created
        for and that authentication requests using this EC2 credential will
        be scoped to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new EC2 credential.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user the EC2 credential is created for.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _Ec2CredentialV3State:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 trust_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Ec2CredentialV3 resources.
        :param pulumi.Input[str] access: contains an EC2 credential access UUID
        :param pulumi.Input[str] project_id: The ID of the project the EC2 credential is created
               for and that authentication requests using this EC2 credential will
               be scoped to.
        :param pulumi.Input[str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new EC2 credential.
        :param pulumi.Input[str] secret: contains an EC2 credential secret UUID
        :param pulumi.Input[str] trust_id: contains an EC2 credential trust ID scope
        :param pulumi.Input[str] user_id: The ID of the user the EC2 credential is created for.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if trust_id is not None:
            pulumi.set(__self__, "trust_id", trust_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        contains an EC2 credential access UUID
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project the EC2 credential is created
        for and that authentication requests using this EC2 credential will
        be scoped to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new EC2 credential.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        contains an EC2 credential secret UUID
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="trustId")
    def trust_id(self) -> Optional[pulumi.Input[str]]:
        """
        contains an EC2 credential trust ID scope
        """
        return pulumi.get(self, "trust_id")

    @trust_id.setter
    def trust_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user the EC2 credential is created for.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class Ec2CredentialV3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### EC2 credential in current project scope

        ```python
        import pulumi
        import pulumi_openstack as openstack

        ec2_key1 = openstack.identity.Ec2CredentialV3("ec2Key1")
        ```
        ### EC2 credential in pre-defined project scope

        ```python
        import pulumi
        import pulumi_openstack as openstack

        ec2_key1 = openstack.identity.Ec2CredentialV3("ec2Key1", project_id="f7ac731cc11f40efbc03a9f9e1d1d21f")
        ```

        ## Import

        EC2 Credentials can be imported using the `access`, e.g.

        ```sh
         $ pulumi import openstack:identity/ec2CredentialV3:Ec2CredentialV3 ec2_cred_1 2d0ac4a2f81b4b0f9513ee49e780647d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project_id: The ID of the project the EC2 credential is created
               for and that authentication requests using this EC2 credential will
               be scoped to.
        :param pulumi.Input[str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new EC2 credential.
        :param pulumi.Input[str] user_id: The ID of the user the EC2 credential is created for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[Ec2CredentialV3Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### EC2 credential in current project scope

        ```python
        import pulumi
        import pulumi_openstack as openstack

        ec2_key1 = openstack.identity.Ec2CredentialV3("ec2Key1")
        ```
        ### EC2 credential in pre-defined project scope

        ```python
        import pulumi
        import pulumi_openstack as openstack

        ec2_key1 = openstack.identity.Ec2CredentialV3("ec2Key1", project_id="f7ac731cc11f40efbc03a9f9e1d1d21f")
        ```

        ## Import

        EC2 Credentials can be imported using the `access`, e.g.

        ```sh
         $ pulumi import openstack:identity/ec2CredentialV3:Ec2CredentialV3 ec2_cred_1 2d0ac4a2f81b4b0f9513ee49e780647d
        ```

        :param str resource_name: The name of the resource.
        :param Ec2CredentialV3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ec2CredentialV3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ec2CredentialV3Args.__new__(Ec2CredentialV3Args)

            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["access"] = None
            __props__.__dict__["secret"] = None
            __props__.__dict__["trust_id"] = None
        super(Ec2CredentialV3, __self__).__init__(
            'openstack:identity/ec2CredentialV3:Ec2CredentialV3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            trust_id: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'Ec2CredentialV3':
        """
        Get an existing Ec2CredentialV3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: contains an EC2 credential access UUID
        :param pulumi.Input[str] project_id: The ID of the project the EC2 credential is created
               for and that authentication requests using this EC2 credential will
               be scoped to.
        :param pulumi.Input[str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new EC2 credential.
        :param pulumi.Input[str] secret: contains an EC2 credential secret UUID
        :param pulumi.Input[str] trust_id: contains an EC2 credential trust ID scope
        :param pulumi.Input[str] user_id: The ID of the user the EC2 credential is created for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ec2CredentialV3State.__new__(_Ec2CredentialV3State)

        __props__.__dict__["access"] = access
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret"] = secret
        __props__.__dict__["trust_id"] = trust_id
        __props__.__dict__["user_id"] = user_id
        return Ec2CredentialV3(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[str]:
        """
        contains an EC2 credential access UUID
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project the EC2 credential is created
        for and that authentication requests using this EC2 credential will
        be scoped to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new EC2 credential.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        contains an EC2 credential secret UUID
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="trustId")
    def trust_id(self) -> pulumi.Output[str]:
        """
        contains an EC2 credential trust ID scope
        """
        return pulumi.get(self, "trust_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The ID of the user the EC2 credential is created for.
        """
        return pulumi.get(self, "user_id")

