__all__ = ('BAD_KEYS', )
# spell-checker: disable
BAD_KEYS = {
    '-globalDomain': {
        'AKLastEmailListRequestDateKey',
        'AppleInterfaceStyle',
        'NSLinguisticDataAssetsRequestTime',
        'NSNavRecentPlaces',
        'NavPanelFileListModeForPanelerMode',
        r're:^AKLast',
        # Devices get added to global domain with -string 1
        r're:^(Amazon|Apple|Canon|Generic|HP|HuiJia) '
    },
    'SSHKeychain': {'Authentication Socket Path'},
    'com.apple.accountsd': {'AuthenticationPluginCache', 'LastSystemVersion'},
    'com.apple.ServicesMenu.Services': {'NSServices'},
    'com.apple.dt.Xcode': {
        'DVTTextCompletionRecentCompletions',
        'DeveloperAccountForProject',
        'IDESourceControlKnownSSHHostsDefaultsKey',
        're:lastRecordedRefresh$',
    },
    'com.apple.TelephonyUtilities': {'registeredProviders'},
    'org.videolan.vlc': {r're:^recentlyPlayed'},
    'com.apple.amp.mediasharingd': {r're:.*\-id$'},
    'com.apple.AddressBook':
    {'ABDefaultSourceID', 'ABMetaDataChangeCount', 'ABMetadataLastOilChange'},
    'com.apple.appstored': {
        'ArcadeDeviceID',
        'ArcadePayoutDeviceID',
        'LastUpdatesCheck',
        r're:^Arcade.*Date$',
        r're:^TargetDate',
    },
    'com.apple.assistant.backedup': {'Cloud Sync User ID'},
    'com.apple.AppStore': {
        'JE.MediaAPIToken',
        'MetricsSamplingLotteryWindowStart_pageRender',
        r're:^lastBootstrap',
    },
    'com.apple.AppleMediaServices': {'AMSMetricsTimingWindowStartTime'},
    'com.apple.bird': {r're:^icloud\-drive\.account\-migration\-status'},
    'com.apple.calculateframework': {'currencyCache'},
    'com.apple.cloudd':
    {'com.apple.private.cloudkit.shouldUseGeneratedDeviceID'},
    'com.apple.cloudpaird':
    {'PreviousToken', 'UploadedHSA2KeysForLocalDevice'},
    'com.apple.commerce': {
        'AvailableUpdatesAtLastNotification',
        'LastUpdateNotificationOSMajorVersion',
        r'^re:PrivacyConsent\:',
    },
    'com.apple.CallHistorySyncHelper': {
        'CallHistoryDeviceCount',
        'ChangeToken',
        r're:.*Date$',
        r're:^/Users/',
    },
    'com.apple.Console': {'ConsoleSearch'},
    'com.apple.configurator': {'Storefront'},
    'com.apple.configurator.ui': {'LastAcceptedConfiguratorLicenseVersion'},
    'com.apple.configurator.ui.commerce':
    {'re:^PrimaryAccount', 're:^Storefront'},
    'com.apple.coreservices.useractivityd':
    {'re:k(?:Local|Remote)PasteboardBlobName'},
    'com.apple.dock': {'mod-count'},
    'com.apple.driver.AppleBluetoothMultitouch.trackpad': {'version'},
    'com.apple.dt.Instruments': {
        'DTDKLastLSRegisterHashes',
        'DTWirelessUniqueShortTypeLocationID',
        'RecentTemplates.array',
    },
    'com.apple.FaceTime': {'AccountSortOrder'},
    'com.apple.finder': {
        'CopyProgressWindowLocation',
        'EmptyTrashProgressWindowLocation',
        'FXConnectToBounds',
        'FXConnectToLastURL',
        'FXPreferencesWindow.Location',
        'GoToField',
        'GoToFieldHistory',
        'MountProgressWindowLocation',
        'RecentMoveAndCopyDestinations',
        'TagsCloudSerialNumber',
    },
    'com.apple.iBooksX': {
        r're:^BKBookViewerPlugInInstanceDescriptor',
        r're:^MZBookKeeper\.LastDsid',
    },
    'com.apple.iBooksX.commerce': {'Storefront'},
    'com.apple.iCal': {
        'AccountDisplayOrder',
        'CalAgentNS_Preference_DefaultReminderCalendar',
        'CalFirstVisibleDate',
        'LastCheckForIgnoredPseudoEvents',
        'first shown minute of day',
        'iCal version',
        'last selected calendar list item',
        'lastViewsTimeZone',
    },
    'com.apple.iChat': {
        'AccountSortOrder',
        'ChatWindowControllerUnifiedFrame',
        'KeepMessagesVersionID',
        'LastFailedMessageIMDNotificationPostedDate',
        'LastIMDNotificationPostedDate',
        'UnifiedChatWindowControllerSelectionGUIDSet',
        r're:^messageTracer',
    },
    'com.apple.iTunes': {
        'Store Apple ID',
        'Store DSID',
        'WirelessBuddyID',
        'storefront',
    },
    'com.apple.iWork.Numbers': {
        'TSAICloudAuthorNameKey',
        'TSKRemoteStringsETag',
        'TSURemoteDefaultsETag',
    },
    'com.apple.iWork.Pages': {
        'TSAICloudAuthorNameKey',
        'TSKRemoteStringsETag',
        'TSURemoteDefaultsETag',
        're:^TSAICloudDocumentPreferencePrefix',
    },
    'com.apple.internetconnect': {'ServiceID'},
    'com.apple.iphonesimulator': {'CurrentDeviceUDID'},
    'com.apple.keychainaccess': {'Last Selected Keychain'},
    'com.apple.logic10': {
        'lastSelectedKeyCommandsPath',
        r're:^DefaultDir',
    },
    'com.apple.languageassetd': {'LastSystemVersion'},
    'com.apple.mail': {
        'AccountInfoLastSelectedAccountId',
        'AccountOrdering',
        'CurrentTransferMailboxURLString',
        'LastAttachedDir',
        'LastChatSyncTime',
        'LastMessageTracingDate',
        'MailSections',
        'MailUpgraderPrePersistenceVersion',
        'MailUpgraderVersion',
        'MailVisibleSections',
        'NumberOfMessagesMarkedAsJunk',
        'NumberOfMessagesMarkedAsNotJunk',
        'SignatureSelectionMethods',
        'SignaturesSelected',
        'com.apple.mail.searchableIndex.lastProcessedAttachmentIDKey',
    },
    'com.apple.PhotoBooth': {'LibraryBookmark'},
    'com.apple.Preferences': {r're:^UserDictionary'},
    'com.apple.print.PrinterProxy':
    {'IK_Scanner_downloadURL', 'IK_Scanner_selectedTag'},
    'com.apple.searchd': {r're:^engagementCount'},
    'com.apple.Spotlight': {
        'GEOUsageSessionID',
        'engagementCount-com.apple.Spotlight',
        'startTime',
        'version',
        r're:.*Count$',
    },
    'com.apple.SystemProfiler': {
        'CPU Names',
        r're:^SPLast',
    },
    'com.apple.Terminal': {'CommandHistory'},
    'com.apple.Safari.SafeBrowsing': {r're:.*Date$'},
    'com.apple.sms': {'hasBeenApprovedForSMSRelay'},
    'com.apple.stocks': {'lastModified'},
    'com.apple.systempreferences': {
        'ThirdPartyCount',
        'com.apple.SecurityPref.Privacy.LastSourceSelected',
    },
    'com.apple.talagent': {'LastKeyChange'},
    'cx.c3.theunarchiver': {
        'DM_SID',
        '_sid',
    },
    'com.parallels.Parallels Desktop': {
        r'[0-9a-f]{12}\}\.', r're:^Guest OS Sources',
        r're:{[0-9a-f]{8}\-[0-9a-f]{4}]\-[0-9a-f]{4}\-[0-9a-f]{4}\-'
    },
    'com.monosnap.monosnap': {
        'last online time',
        'mono_pref_time',
        r're:^[0-9a-f]{24}\&0$',
    },
    'com.googlecode.iterm2': {
        'Default Bookmark Guid',
        'NoSyncInstallationId',
        r're:^NeverWarnAboutShortLivedSessions',
    },
    'com.etresoft.EtreCheckMAS': {'asset'},
    'com.etresoft.EtreCheck4': {'asset'},
    'org.quassel-irc.quasselclient': {
        r're:^CoreAccounts\.\d+\.General\.JumpKeyMap',
        r're:^CoreAccounts\.\d+\.Password',
    },
    'ThnkDev.QuickRes': {
        'DM_SID',
        'DevMateLaunchCount',
        'matchedIds',
    },
    'ch.tripmode.TripMode': {
        'Networks',
        r're:^ActivationOverrides?',
    },
    'com.apple.ActivityMonitor': {'cacheTableSortDescriptors'},
    'com.vmware.fusion': {'DUISettingsItemCDROM_recentItems'},
}
