"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'construct an AWS::Serverless::Application'(test) {
        const stack = new cdk.Stack();
        new lib_1.CfnApplication(stack, 'App', {
            location: {
                applicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
                semanticVersion: '2.0.0'
            },
            parameters: {
                SearchText: '#serverless -filter:nativeretweets',
                TweetProcessorFunctionName: 'test'
            }
        });
        assert_1.expect(stack).toMatch({
            Transform: 'AWS::Serverless-2016-10-31',
            Resources: {
                App: {
                    Type: 'AWS::Serverless::Application',
                    Properties: {
                        Location: {
                            ApplicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
                            SemanticVersion: '2.0.0'
                        },
                        Parameters: {
                            SearchText: '#serverless -filter:nativeretweets',
                            TweetProcessorFunctionName: 'test'
                        }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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