import pyneb as pn

ELEM_LIST = ['Ag', 'Al', 'Ar', 'Au', 'B', 'Ba', 'C', 'Ca', 'Cl', 'Co', 'Cr', 'Cu', 'F', 'Fe', 'H', 'He', 'K',
             'Kr', 'Mg', 'N', 'Na', 'Ne', 'Ni', 'O', 'P', 'S', 'Si', 'Xe', 'Zn']
SPEC_LIST = ['1', '2', '3', '4', '5', '6']

def _print_LINE_LABEL_LIST(*args, **kwargs):
    """
    The parameters are passed to getAtomDict. May be the fits directory.
    """
    ##
    # @todo we have to check what are the differences in LINE_LABEL_LIST when changing the fits files
    all_atoms = pn.getAtomDict(*args, **kwargs)
    print "LINE_LABEL_LIST = {}"
    for atom in all_atoms:
        wave = all_atoms[atom].lineList
        opt = (wave < 10000.)
        ir = (wave >= 10000.)
        lines_opt = ["'%.0fA'" % line for line in wave[opt]]
        lines_ir = ["'%.1fm'" % line for line in wave[ir] / 1.e4]
        lines = lines_opt + lines_ir
        print "LINE_LABEL_LIST['" + atom + "'] = [" + ', '.join(lines) + "]"


LINE_LABEL_LIST = {}
LINE_LABEL_LIST['H1'] = ['3750', '3771', '3889A', '4102A', '4340A', '4861A', '6563A', '9015A', '9229A']
LINE_LABEL_LIST['He1'] = ['5876A', '2945A', '3188A', '3614A', '3889A', '3965A', '4026A', '4121A', '4388A',
                          '4438A', '4472A', '4713A', '4922A', '5016A', '5048A', '5876A', '6678A', '7065A',
                          '7281A', '9464A', '10830A', '11013A', '11969A', '12527A', '12756A', '12785A',
                          '12790A', '12846A', '12968A', '12985A', '13412A', '15084A', '17003A', '18556A',
                          '18685A', '18697A', '19089A', '19543A', '20425A', '20581A', '20602A', '21120A',
                          '21132A', '21608A', '21617A']
LINE_LABEL_LIST['He2'] = ['4686A', '5876A']
LINE_LABEL_LIST['S3'] = ['8829A', '9069A', '9531A', '3681A', '3722A', '3798A', '6312A', '33.6m', '12.0m', '18.7m']
LINE_LABEL_LIST['S2'] = ['6731A', '6716A', '4076A', '4069A', '1260A', '1549A', '1550A', '1823A', '1824A', '1254A', '1541A', '1542A', '1811A', '1812A', '1251A', '1536A', '1537A', '1804A', '1806A', '314.5m', '1.0m', '214.0m', '27.7m', '17.6m', '48.6m']
LINE_LABEL_LIST['Ca5'] = ['5311A', '6087A', '6428A', '2280A', '2414A', '2464A', '3999A', '4.2m', '3.0m', '11.5m']
LINE_LABEL_LIST['S4'] = ['1405A', '1424A', '1398A', '1417A', '1387A', '1406A', '10.5m', '29.2m', '11.2m', '18.3m']
LINE_LABEL_LIST['Ne6'] = ['1005A', '1017A', '999A', '1011A', '993A', '1006A', '567A', '572A', '1309A', '1316A', '1324A', '567A', '572A', '1305A', '1313A', '1324A', '7.6m', '22.4m', '9.2m', '15.6m', '909.1m']
LINE_LABEL_LIST['K5'] = ['4163A', '4123A', '2514A', '6349A', '6446A', '2495A', '6223A', '6316A', '42.2m', '31.4m']
LINE_LABEL_LIST['K4'] = ['6102A', '6796A', '7110A', '2594A', '2711A', '2760A', '4511A', '6.0m', '4.3m', '15.4m']
LINE_LABEL_LIST['O5'] = ['1220A', '1218A', '1214A', '630A', '1301A', '1303A', '1309A', '71.6m', '22.6m', '33.0m']
LINE_LABEL_LIST['O4'] = ['1400A', '1407A', '1397A', '1405A', '1394A', '1401A', '788A', '791A', '1804A', '1808A', '1814A', '788A', '790A', '1803A', '1808A', '1814A', '609A', '610A', '1077A', '1079A', '1081A', '2673A', '2674A', '25.9m', '76.0m', '31.7m', '54.3m', '588.2m']
LINE_LABEL_LIST['O3'] = ['4931A', '4959A', '5007A', '2315A', '2321A', '2331A', '4363A', '1658A', '1661A', '1666A', '2497A', '5839A', '87.6m', '32.5m', '51.8m']
LINE_LABEL_LIST['O2'] = ['3729A', '3726A', '2470A', '7319A', '7330A', '2470A', '7318A', '7329A', '834A', '1075A', '1260A', '833A', '1073A', '1258A', '833A', '1072A', '1256A', '505.3m', '5076.1m', '61.3m', '40.8m', '121.8m']
LINE_LABEL_LIST['O1'] = ['6300A', '6364A', '6392A', '2959A', '2973A', '2979A', '5579A', '63.2m', '44.1m', '145.5m']
LINE_LABEL_LIST['Ar2'] = ['7.0m']
LINE_LABEL_LIST['Ar3'] = ['7136A', '7751A', '8036A', '3005A', '3109A', '3157A', '5192A', '9.0m', '6.4m', '21.8m']
LINE_LABEL_LIST['Ar4'] = ['4740A', '4711A', '2868A', '7263A', '7331A', '2854A', '7170A', '7237A', '77.4m', '56.4m']
LINE_LABEL_LIST['Ar5'] = ['6133A', '6435A', '7005A', '2637A', '2692A', '2786A', '4626A', '13.1m', '4.9m', '7.9m']
LINE_LABEL_LIST['Ne5'] = ['3300A', '3346A', '3426A', '1565A', '1575A', '1592A', '2975A', '1132A', '1137A', '1146A', '1722A', '4090A', '24.2m', '9.0m', '14.3m']
LINE_LABEL_LIST['N4'] = ['1488A', '1487A', '1483A', '765A', '1574A', '1576A', '1580A', '158.7m', '48.3m', '69.4m']
LINE_LABEL_LIST['C3'] = ['1910A', '1909A', '1907A', '977A', '2001A', '2002A', '2004A', '416.7m', '125.0m', '178.6m']
LINE_LABEL_LIST['C2'] = ['2325A', '2328A', '2324A', '2327A', '2323A', '2326A', '1335A', '1336A', '3132A', '3134A', '3136A', '1324A', '1326A', '3078A', '3080A', '3081A', '1036A', '1037A', '1870A', '1871A', '4638A', '4763A', '157.8m', '540.2m', '270.1m', '540.0m', '17.6m']
LINE_LABEL_LIST['C1'] = ['9807A', '9823A', '9849A', '4618A', '4621A', '4627A', '8728A', '609.7m', '230.0m', '369.3m']
LINE_LABEL_LIST['Al2'] = ['2674A', '2670A', '2661A', '1671A', '4453A', '4465A', '4490A', '162.3m', '53.9m', '80.7m']
LINE_LABEL_LIST['Si3'] = ['1897A', '1892A', '1883A', '1206A', '3316A', '3330A', '3359A', '78.0m', '25.7m', '38.3m']
LINE_LABEL_LIST['Si2'] = ['2335A', '2351A', '2329A', '2345A', '2320A', '2335A', '1808A', '1817A', '8009A', '8080A', '8196A', '1808A', '1817A', '7999A', '8070A', '8185A', '34.8m', '91.7m', '35.2m', '57.1m', '646.8m']
LINE_LABEL_LIST['Na6'] = ['2815A', '2871A', '2970A', '1343A', '1356A', '1377A', '2569A', '14.3m', '5.4m', '8.6m']
LINE_LABEL_LIST['Na4'] = ['3242A', '3362A', '3416A', '1504A', '1529A', '1540A', '2805A', '9.0m', '6.3m', '21.3m']
LINE_LABEL_LIST['Cl4'] = ['7261A', '7531A', '8046A', '3071A', '3119A', '3204A', '5323A', '20.4m', '7.5m', '11.8m']
LINE_LABEL_LIST['N1'] = ['5200A', '5198A', '3467A', '3466A', '1094.1m', '1.0m', '27777.8m']
LINE_LABEL_LIST['N2'] = ['6527A', '6548A', '6584A', '3058A', '3063A', '3071A', '5755A', '2142A', '2144A', '2148A', '3188A', '7147A', '205.4m', '76.3m', '121.5m']
LINE_LABEL_LIST['N3'] = ['1749A', '1754A', '1747A', '1752A', '1744A', '1750A', '990A', '992A', '2284A', '2287A', '2291A', '990A', '992A', '2283A', '2287A', '2291A', '764A', '765A', '1356A', '1357A', '1359A', '3338A', '3340A', '57.4m', '167.5m', '71.2m', '123.8m', '909.1m']
LINE_LABEL_LIST['Ne2'] = ['12.8m']
LINE_LABEL_LIST['Ne3'] = ['3869A', '3968A', '4012A', '1794A', '1815A', '1824A', '3343A', '15.6m', '10.9m', '36.0m']
LINE_LABEL_LIST['Ne4'] = ['2425A', '2422A', '1602A', '4716A', '4726A', '1601A', '4714A', '4724A', '221.2m', '1587.3m']
LINE_LABEL_LIST['Cl2'] = ['8579A', '9124A', '9356A', '3588A', '3678A', '3717A', '6165A', '14.4m', '10.4m', '37.2m']
LINE_LABEL_LIST['Cl3'] = ['5538A', '5518A', '3353A', '8500A', '8548A', '3343A', '8434A', '8481A', '153.2m', '107.5m']
LINE_LABEL_LIST['Mg5'] = ['2783A', '2929A', '2994A', '1294A', '1325A', '1338A', '2418A', '5.6m', '4.0m', '13.5m']
LINE_LABEL_LIST['Fe3'] = ['4009A', '4659A', '4668A', '4703A', '4735A', '4756A', '5013A', '5086A', '5272A', '4882A', '4926A', '4932A', '5413A', '4987A', '4989A', '8731A', '8840A']
LINE_LABEL_LIST['C4'] = ['1548A', '1551A']

BLEND_LIST = {}
BLEND_LIST['C2_2325A+'] = 'I(3,1)+I(3,2)+I(4,1)+I(4,2)+I(5,1)+I(5,2)'
BLEND_LIST['C3_1909A+'] = 'I(4,1)+I(3,1)+I(2,1)'
BLEND_LIST['C4_1550A+'] = 'I(2,1)+I(3,1)'
BLEND_LIST['N1_5199A+'] = 'I(2,1)+I(3,1)'
BLEND_LIST['N4_1485A+'] = 'I(4,1)+I(3,1)'
BLEND_LIST['O2_3727A+'] = 'L(3726)+L(3729)'
BLEND_LIST['O2_1075A+'] = 'I(6,2)+I(6,3)'
BLEND_LIST['O2_7330A+'] = 'I(4,3)+I(5,3)'
BLEND_LIST['O2_7319A+'] = 'I(4,2)+I(5,2)'
BLEND_LIST['O2_7325A+'] = 'I(4,2)+I(5,2)+I(4,3)+I(5,3)'
BLEND_LIST['O3_1664A+'] = 'L(1660)+L(1666)'
BLEND_LIST['O4_1400A+'] = 'I(3,1)+I(3,2)+I(4,1)+I(4,2)+I(5,1)+I(5,2)'
BLEND_LIST['N3_1751A+'] = 'I(3,1)+I(3,2)+I(4,1)+I(4,2)+I(5,1)+I(5,2)'
BLEND_LIST['Ne4_4726A+'] = 'L(4725)+L(4727)'
BLEND_LIST['Ne4_2423A+'] = 'I(2,1)+I(3,1)'
BLEND_LIST['S2_6725A+'] = 'L(6716)+L(6731)'
BLEND_LIST['S2_4072A+'] = 'L(4076)+L(4069)'


