emoji_map = {
    'A': '😒😔', 'B': '🥰💕', 'C': '♥🔥', 'D': '🤣😎', 'E': '🤖🐱', 'F': '🌟🪐',
    'G': '🍕🥶', 'H': '😱🙃', 'I': '🦋✨', 'J': '👽🚀', 'K': '🧠💀', 'L': '🧸👑',
    'M': '🌈🐸', 'N': '🍭🧃', 'O': '🎃🦄', 'P': '🍔🍟', 'Q': '🐼💫', 'R': '⚡🌀',
    'S': '🎲🧩', 'T': '🐥🧸', 'U': '💎🍓', 'V': '🎯🏹', 'W': '🍉🍇', 'X': '🚨🧨',
    'Y': '🧃🦋', 'Z': '🐙🌊',
    'ا': '🕌🌙', 'ب': '🐫🌵', 'ت': '🧕🌸', 'ث': '🌞🎉', 'ج': '🧱🐘', 'ح': '🧂🧺',
    'خ': '🌊🐬', 'د': '📿🕋', 'ذ': '💡🗺', 'ر': '🪔🌹', 'ز': '🥀🍁', 'س': '🧞‍♂️🧿',
    'ش': '🎼💃', 'ص': '🪓🛡', 'ض': '🧨🔮', 'ط': '🦁🦅', 'ظ': '🕊⚖', 'ع': '📖🪶',
    'غ': '🌌🦢', 'ف': '🕋📿', 'ق': '🎁🛍', 'ك': '🧵🧶', 'ل': '🛏🧕', 'م': '📚📝',
    'ن': '🔔🕯', 'هـ': '🎀🕸', 'و': '🎊📯', 'ي': '🕰🧭',
    '0': '🥇🎖', '1': '🪙🔋', '2': '🎡🛴', '3': '🎂🍦', '4': '📱🎧',
    '5': '🧃🧊', '6': '📷🖼', '7': '🧼🧽', '8': '🏮🧯', '9': '🏁🔋',
    '@': '💼🧭', '#': '🔓🪪', '$': '💰🧾', '_': '🛠📌', '&': '🖇🔧',
    '-': '📎🪛', '+': '➕🧮', ')': '📞🎤', '(': '📟🎬', '/': '🍴🥄',
    '*': '🧿📿', '"': '🎨🪞', "'": '🔐🪤', ':': '🖋🖊', ';': '🪒🧼',
    '!': '🔊📣', '؟': '🫥🫢', '~': '🌀🪄', '«': '🪷💮', '»': '🪷💮',
    '•': '🪙🔸', '%': '💹📈', '√': '🧮🧠', 'π': '📐🧲', '÷': '📏🔢',
    '×': '❎❌', '=': '📊📎', '|': '🧱🪵', '\\': '🛞🪚', '<': '🪤🫙',
    '>': '🧲📡', '[': '🧰🔩', ']': '🗜🧲', '{': '🧳🛢', '}': '🧯🪠',
    '°': '🌡🛰', '^': '🎇🎆', '✓': '✅🟢', '§': '🧾📜', '¶': '📖🔖',
    '™': '™🪪', '®': '®🏷', '©': '©📇', '£': '💷🏦', '€': '💶🏤',
    '`': '🖱⌨️', 'ع.د': '🏛💴'
}

reverse_map = {v: k for k, v in emoji_map.items()}

def encrypt(text):
    result = ''
    for char in text:
        emoji = emoji_map.get(char.upper(), char)
        result += emoji
    return result

def decrypt(emoji_text):
    result = ''
    i = 0
    while i < len(emoji_text):
        pair = emoji_text[i:i+4]
        if pair in reverse_map:
            result += reverse_map[pair]
            i += 4
        else:
            result += emoji_text[i]
            i += 1
    return result