# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class QuotaV2(pulumi.CustomResource):
    floatingip: pulumi.Output[float]
    """
    Quota value for floating IPs. Changing this updates the
    existing quota.
    """
    network: pulumi.Output[float]
    """
    Quota value for networks. Changing this updates the
    existing quota.
    """
    port: pulumi.Output[float]
    """
    Quota value for ports. Changing this updates the
    existing quota.
    """
    project_id: pulumi.Output[str]
    """
    ID of the project to manage quota. Changing this
    creates new quota.
    """
    rbac_policy: pulumi.Output[float]
    """
    Quota value for RBAC policies.
    Changing this updates the existing quota.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the quota. If
    omitted, the `region` argument of the provider is used. Changing this
    creates new quota.
    """
    router: pulumi.Output[float]
    """
    Quota value for routers. Changing this updates the
    existing quota.
    """
    security_group: pulumi.Output[float]
    """
    Quota value for security groups. Changing
    this updates the existing quota.
    """
    security_group_rule: pulumi.Output[float]
    """
    Quota value for security group rules.
    Changing this updates the existing quota.
    """
    subnet: pulumi.Output[float]
    """
    Quota value for subnets. Changing
    this updates the existing quota.
    """
    subnetpool: pulumi.Output[float]
    """
    Quota value for subnetpools.
    Changing this updates the existing quota.
    """
    def __init__(__self__, resource_name, opts=None, floatingip=None, network=None, port=None, project_id=None, rbac_policy=None, region=None, router=None, security_group=None, security_group_rule=None, subnet=None, subnetpool=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V2 networking quota resource within OpenStack.

        > **Note:** This usually requires admin privileges.

        > **Note:** This resource has a no-op deletion so no actual actions will be done against the OpenStack API 
            in case of delete call.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/networking_quota_v2.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] floatingip: Quota value for floating IPs. Changing this updates the
               existing quota.
        :param pulumi.Input[float] network: Quota value for networks. Changing this updates the
               existing quota.
        :param pulumi.Input[float] port: Quota value for ports. Changing this updates the
               existing quota.
        :param pulumi.Input[str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[float] rbac_policy: Quota value for RBAC policies.
               Changing this updates the existing quota.
        :param pulumi.Input[str] region: The region in which to create the quota. If
               omitted, the `region` argument of the provider is used. Changing this
               creates new quota.
        :param pulumi.Input[float] router: Quota value for routers. Changing this updates the
               existing quota.
        :param pulumi.Input[float] security_group: Quota value for security groups. Changing
               this updates the existing quota.
        :param pulumi.Input[float] security_group_rule: Quota value for security group rules.
               Changing this updates the existing quota.
        :param pulumi.Input[float] subnet: Quota value for subnets. Changing
               this updates the existing quota.
        :param pulumi.Input[float] subnetpool: Quota value for subnetpools.
               Changing this updates the existing quota.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['floatingip'] = floatingip
            __props__['network'] = network
            __props__['port'] = port
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['rbac_policy'] = rbac_policy
            __props__['region'] = region
            __props__['router'] = router
            __props__['security_group'] = security_group
            __props__['security_group_rule'] = security_group_rule
            __props__['subnet'] = subnet
            __props__['subnetpool'] = subnetpool
        super(QuotaV2, __self__).__init__(
            'openstack:networking/quotaV2:QuotaV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, floatingip=None, network=None, port=None, project_id=None, rbac_policy=None, region=None, router=None, security_group=None, security_group_rule=None, subnet=None, subnetpool=None):
        """
        Get an existing QuotaV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] floatingip: Quota value for floating IPs. Changing this updates the
               existing quota.
        :param pulumi.Input[float] network: Quota value for networks. Changing this updates the
               existing quota.
        :param pulumi.Input[float] port: Quota value for ports. Changing this updates the
               existing quota.
        :param pulumi.Input[str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[float] rbac_policy: Quota value for RBAC policies.
               Changing this updates the existing quota.
        :param pulumi.Input[str] region: The region in which to create the quota. If
               omitted, the `region` argument of the provider is used. Changing this
               creates new quota.
        :param pulumi.Input[float] router: Quota value for routers. Changing this updates the
               existing quota.
        :param pulumi.Input[float] security_group: Quota value for security groups. Changing
               this updates the existing quota.
        :param pulumi.Input[float] security_group_rule: Quota value for security group rules.
               Changing this updates the existing quota.
        :param pulumi.Input[float] subnet: Quota value for subnets. Changing
               this updates the existing quota.
        :param pulumi.Input[float] subnetpool: Quota value for subnetpools.
               Changing this updates the existing quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["floatingip"] = floatingip
        __props__["network"] = network
        __props__["port"] = port
        __props__["project_id"] = project_id
        __props__["rbac_policy"] = rbac_policy
        __props__["region"] = region
        __props__["router"] = router
        __props__["security_group"] = security_group
        __props__["security_group_rule"] = security_group_rule
        __props__["subnet"] = subnet
        __props__["subnetpool"] = subnetpool
        return QuotaV2(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

