# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Configuration(pulumi.CustomResource):
    configurations: pulumi.Output[list]
    """
    An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.

      * `name` (`str`) - Configuration parameter name. Changing this creates a new resource.
      * `value` (`str`) - Configuration parameter value. Changing this creates a new resource.
    """
    datastore: pulumi.Output[dict]
    """
    An array of database engine type and version. The datastore
    object structure is documented below. Changing this creates resource.

      * `type` (`str`) - Database engine type to be used with this configuration. Changing this creates a new resource.
      * `version` (`str`) - Version of database engine type to be used with this configuration. Changing this creates a new resource.
    """
    description: pulumi.Output[str]
    """
    Description of the resource.
    """
    name: pulumi.Output[str]
    """
    Configuration parameter name. Changing this creates a new resource.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the db instance. Changing this
    creates a new instance.
    """
    def __init__(__self__, resource_name, opts=None, configurations=None, datastore=None, description=None, name=None, region=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V1 DB configuration resource within OpenStack.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/db_configuration_v1.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] configurations: An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        :param pulumi.Input[dict] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: Configuration parameter name. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.

        The **configurations** object supports the following:

          * `name` (`pulumi.Input[str]`) - Configuration parameter name. Changing this creates a new resource.
          * `value` (`pulumi.Input[str]`) - Configuration parameter value. Changing this creates a new resource.

        The **datastore** object supports the following:

          * `type` (`pulumi.Input[str]`) - Database engine type to be used with this configuration. Changing this creates a new resource.
          * `version` (`pulumi.Input[str]`) - Version of database engine type to be used with this configuration. Changing this creates a new resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['configurations'] = configurations
            if datastore is None:
                raise TypeError("Missing required property 'datastore'")
            __props__['datastore'] = datastore
            if description is None:
                raise TypeError("Missing required property 'description'")
            __props__['description'] = description
            __props__['name'] = name
            __props__['region'] = region
        super(Configuration, __self__).__init__(
            'openstack:database/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, configurations=None, datastore=None, description=None, name=None, region=None):
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] configurations: An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        :param pulumi.Input[dict] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: Configuration parameter name. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.

        The **configurations** object supports the following:

          * `name` (`pulumi.Input[str]`) - Configuration parameter name. Changing this creates a new resource.
          * `value` (`pulumi.Input[str]`) - Configuration parameter value. Changing this creates a new resource.

        The **datastore** object supports the following:

          * `type` (`pulumi.Input[str]`) - Database engine type to be used with this configuration. Changing this creates a new resource.
          * `version` (`pulumi.Input[str]`) - Version of database engine type to be used with this configuration. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["configurations"] = configurations
        __props__["datastore"] = datastore
        __props__["description"] = description
        __props__["name"] = name
        __props__["region"] = region
        return Configuration(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

