# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Cluster(pulumi.CustomResource):
    api_address: pulumi.Output[str]
    cluster_template_id: pulumi.Output[str]
    coe_version: pulumi.Output[str]
    container_version: pulumi.Output[str]
    create_timeout: pulumi.Output[float]
    created_at: pulumi.Output[str]
    discovery_url: pulumi.Output[str]
    docker_volume_size: pulumi.Output[float]
    fixed_network: pulumi.Output[str]
    fixed_subnet: pulumi.Output[str]
    flavor: pulumi.Output[str]
    keypair: pulumi.Output[str]
    labels: pulumi.Output[dict]
    master_addresses: pulumi.Output[str]
    master_count: pulumi.Output[float]
    master_flavor: pulumi.Output[str]
    name: pulumi.Output[str]
    node_addresses: pulumi.Output[str]
    node_count: pulumi.Output[float]
    project_id: pulumi.Output[str]
    region: pulumi.Output[str]
    stack_id: pulumi.Output[str]
    updated_at: pulumi.Output[str]
    user_id: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, cluster_template_id=None, create_timeout=None, discovery_url=None, docker_volume_size=None, fixed_network=None, fixed_subnet=None, flavor=None, keypair=None, labels=None, master_count=None, master_flavor=None, name=None, node_count=None, region=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V1 Magnum cluster resource within OpenStack.

        ## Argument reference

        The following arguments are supported:

        * `region` - (Optional) The region in which to obtain the V1 Container Infra
            client. A Container Infra client is needed to create a cluster. If omitted,
            the `region` argument of the provider is used. Changing this creates a new
            cluster.

        * `name` - (Required) The name of the cluster. Changing this updates the name
            of the existing cluster template.

        * `project_id` - (Optional) The project of the cluster. Required if admin wants
            to create a cluster in another project. Changing this creates a new
            cluster.

        * `user_id` - (Optional) The user of the cluster. Required if admin wants to
            create a cluster template for another user. Changing this creates a new
            cluster.

        * `cluster_template_id` - (Required) The UUID of the V1 Container Infra cluster
            template. Changing this creates a new cluster.

        * `create_timeout` - (Optional) The timeout (in minutes) for creating the
            cluster. Changing this creates a new cluster.

        * `discovery_url` - (Optional) The URL used for cluster node discovery.
            Changing this creates a new cluster.

        * `docker_volume_size` - (Optional) The size (in GB) of the Docker volume.
            Changing this creates a new cluster.

        * `flavor` - (Optional) The flavor for the nodes of the cluster. Can be set via
            the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
            cluster.

        * `master_flavor` - (Optional) The flavor for the master nodes. Can be set via
            the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
            new cluster.

        * `keypair` - (Optional) The name of the Compute service SSH keypair. Changing
            this creates a new cluster.

        * `labels` - (Optional) The list of key value pairs representing additional
            properties of the cluster. Changing this creates a new cluster.

        * `master_count` - (Optional) The number of master nodes for the cluster.
            Changing this creates a new cluster.

        * `node_count` - (Optional) The number of nodes for the cluster. Changing this
            creates a new cluster.
            
        * `fixed_network` - (Optional) The fixed network that will be attached to the
            cluster. Changing this creates a new cluster.

        * `fixed_subnet` - (Optional) The fixed subnet that will be attached to the
            cluster. Changing this creates a new cluster.

        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which cluster was created.
        * `updated_at` - The time at which cluster was created.
        * `api_address` - COE API address.
        * `coe_version` - COE software version.
        * `cluster_template_id` - See Argument Reference above.
        * `container_version` - Container software version.
        * `create_timeout` - See Argument Reference above.
        * `discovery_url` - See Argument Reference above.
        * `docker_volume_size` - See Argument Reference above.
        * `flavor` - See Argument Reference above.
        * `master_flavor` - See Argument Reference above.
        * `keypair` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `master_count` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `fixed_network` - See Argument Reference above.
        * `fixed_subnet` - See Argument Reference above.
        * `master_addresses` - IP addresses of the master node of the cluster.
        * `node_addresses` - IP addresses of the node of the cluster.
        * `stack_id` - UUID of the Orchestration service stack.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/containerinfra_cluster_v1.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if cluster_template_id is None:
                raise TypeError("Missing required property 'cluster_template_id'")
            __props__['cluster_template_id'] = cluster_template_id
            __props__['create_timeout'] = create_timeout
            __props__['discovery_url'] = discovery_url
            __props__['docker_volume_size'] = docker_volume_size
            __props__['fixed_network'] = fixed_network
            __props__['fixed_subnet'] = fixed_subnet
            __props__['flavor'] = flavor
            __props__['keypair'] = keypair
            __props__['labels'] = labels
            __props__['master_count'] = master_count
            __props__['master_flavor'] = master_flavor
            __props__['name'] = name
            __props__['node_count'] = node_count
            __props__['region'] = region
            __props__['api_address'] = None
            __props__['coe_version'] = None
            __props__['container_version'] = None
            __props__['created_at'] = None
            __props__['master_addresses'] = None
            __props__['node_addresses'] = None
            __props__['project_id'] = None
            __props__['stack_id'] = None
            __props__['updated_at'] = None
            __props__['user_id'] = None
        super(Cluster, __self__).__init__(
            'openstack:containerinfra/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, api_address=None, cluster_template_id=None, coe_version=None, container_version=None, create_timeout=None, created_at=None, discovery_url=None, docker_volume_size=None, fixed_network=None, fixed_subnet=None, flavor=None, keypair=None, labels=None, master_addresses=None, master_count=None, master_flavor=None, name=None, node_addresses=None, node_count=None, project_id=None, region=None, stack_id=None, updated_at=None, user_id=None):
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["api_address"] = api_address
        __props__["cluster_template_id"] = cluster_template_id
        __props__["coe_version"] = coe_version
        __props__["container_version"] = container_version
        __props__["create_timeout"] = create_timeout
        __props__["created_at"] = created_at
        __props__["discovery_url"] = discovery_url
        __props__["docker_volume_size"] = docker_volume_size
        __props__["fixed_network"] = fixed_network
        __props__["fixed_subnet"] = fixed_subnet
        __props__["flavor"] = flavor
        __props__["keypair"] = keypair
        __props__["labels"] = labels
        __props__["master_addresses"] = master_addresses
        __props__["master_count"] = master_count
        __props__["master_flavor"] = master_flavor
        __props__["name"] = name
        __props__["node_addresses"] = node_addresses
        __props__["node_count"] = node_count
        __props__["project_id"] = project_id
        __props__["region"] = region
        __props__["stack_id"] = stack_id
        __props__["updated_at"] = updated_at
        __props__["user_id"] = user_id
        return Cluster(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

