from hackingtools.core import Logger, Utils, Config
if Utils.amIdjango(__name__):
	from .library.core import hackingtools as ht
else:
	import hackingtools as ht
import os

import urllib.parse
import requests
from bs4 import BeautifulSoup

config = Config.getConfig(parentKey='modules', key='ht_router')
output_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), 'output'))

class StartModule():

	def __init__(self):
		self._main_gui_func_ = 'getDefaultLogin'
		self._funcArgFromFunc_ = {
			'getDefaultLogin' : {
				'routerBrand' : {
					'router' : 'getBrands' 
				}
			}
		}
		self.brands = [ "2Wire, Inc.","3M","360 Systems","3COM","Accelerated Networks","ACCTON","Acer","Actiontec","Adaptec","ADC Kentrox", "AdComplete.com", "AddPac Technology", "Adobe", "ADT", "Adtech", "Adtran", "Advanced Integration", "AIRAYA Corp", "Airlink", "AirLink Plus", "Aironet", "Airway", "Aladdin", "Alcatel", "Alien Technology", "Allied Telesyn", "Allnet", "Allot", "Alteon", "Ambit", "AMI", "Amino", "AmpJuke", "Amptron", "AMX", "Apache", "Apache Project", "APC", "Apple", "Apple Computer", "Arris", "Arrowpoint", "Aruba", "Asante", "Ascend", "Ascom", "AST", "Asus", "AT&T", "Atlassian", "Attachmate", "Audioactive", "Autodesk", "Avaya", "Avenger News System (ANS)", "AWARD", "Axis", "Axis Communications", "Axway", "Barco, Inc.", "Barracuda", "Bay Networks", "Best Practical Solutions", "BestPractical", "Bewan", "Billion", "Bintec", "Biodata", "Biostar", "Biscom", "BizDesign", "Black Duck Software, Inc.", "Black Widow Web Design Ltd", "Blitzz Technologies", "BMC Software", "Bomgar", "Borland", "Breezecom", "Brocade", "Brother", "Brother Industries Ltd.", "BT", "Buffalo/MELCO", "Busybox", "Cabletron", "Capricorn Infotech India", "CareStream Health", "Carsten Schmitz", "Cayman", "Cellit", "Ceragon Networks", "CGI World", "Chase Research", "Check Point", "Chuming Chen", "Ciphertrust", "Cisco", "Cisco-Arrowpoint", "Citrix Systems, Inc.", "Claris", "ClearOne Communications", "Cobalt", "Colubris Networks", "Comcast SMC", "Comersus", "Comodo Group, Inc", "Compaq", "Compualynx", "Conceptronic", "Concord", "Conexant", "Control4", "CoronaMatrix", "Covertix", "Crystalview", "CTX International", "Cyberguard", "CyberMax", "Cyberoam", "Cyclades", "Daewoo", "Dallas Semiconductors", "Dassault Systemes", "Data General", "Datacom", "DataWizard Technologies Inc.", "Davolink", "Daytek", "Debian", "Deerfield", "Dell", "Develcon", "Dictaphone", "Digicorp", "Digicraft Software", "Digital Equipment", "Digium, Inc.", "Divar", "Dlink", "D-Link", "DotNetNuke Corporation", "Draytek", "Draytek Corp", "Ducati Motor Holding", "DuPont", "DVB", "Dynalink", "Dynix Library Systems", "Eaton", "Echelon Corporation", "Edimax", "Efficient", "Ektron, Inc.", "Elron", "Elsa", "EMC", "Eminent", "Enhydra", "Enox", "Enterasys", "Entrust", "EPiServer AB", "Epox", "eQ-3", "Ericsson", "eSeSIX Computer GmbH", "Exabyte", "Exacq Technologies", "Exinda Networks", "Extended Systems", "Extreme Networks", "eZ Systems", "EZPhotoSales", "F5", "Fastream Technologies", "Fastwire", "FatWire", "Firebird Project", "Flowpoint", "Fortinet", "Foscam", "Foundry Networks", "Freetech", "FrontRange Solutions", "Funk Software", "Galacticomm", "Gandalf", "Gateway", "GE Security, Inc.", "Geeklog", "General Instruments", "glFtpD", "Globespan Virata", "Google", "Gossamer Threads Inc.", "GrandStream", "Grandstream Networks, Inc", "Groupee, Inc.", "GuardOne", "H2O Project", "Hayes", "Hemoco Software", "Hewlett-Packard", "HighPOint", "Honeynet Project", "Horizon DataSys", "Hosting Controller", "HP", "Huawei Technologies Co", "Hyperic, Inc.", "IBM", "Inedo", "Informix", "Infrant", "Innovaphone", "Inova", "Integrated Networks", "Intel", "IntelliTouch", "Interbase", "iNTERFACEWARE Inc.", "Intermec", "Internet Archive", "Intersystems", "Inventel Wanadoo", "Ipswitch", "IQinVision", "IRC", "IronPort", "Iwill", "JAMF Software", "Janitza", "Jaspersoft Corporation", "JD Edwards", "Jean-Philippe Lang", "Jeebles Technology", "Jetform", "JetWay", "Johnson Controls", "Joss Technology", "Juniper", "Justin Hagstrom", "Kentico Software", "Kethinov", "Kodak", "Konica Minolta", "Kronos", "Kyocera", "LaCie", "LANSA", "Lantronics", "Lantronix", "Leading Edge", "Lenel", "Level1", "LGIC", "Liebert", "Lindsay Electronics", "Linksys", "Linux", "Liquidware Labs, Inc.", "Livingston", "Loglogic", "Longshine", "Lucent", "Luxon Communications", "M Technology", "MachSpeed", "Macsense", "Magento", "Magic-Pro", "Mambo", "ManageEngine", "Mandarin Library Automation", "Mantis", "Megastar", "Mentec", "Mercury Interactive", "Michiel", "Microcom", "Micron", "Micronet", "Micronics", "Microplex", "Microsoft", "Mike Peters", "MikroTik", "Mintel", "Mitel Networks", "mklencke", "Mole", "Motive", "Motorola", "MP3Mystic", "Muze", "MyioSoft", "MySQL", "Nanoteq", "NCR", "NEC", "NetApp", "Netasq", "NetBotz", "Netcomm", "Netcordia", "Netgear", "NetGenesis", "Netopia", "Netscape", "Netscreen", "Netstar", "NetworkICE", "NewMedia-NET GmbH", "Nexsan", "NeXT", "NICE Systems Ltd.", "Niksun", "Nimble", "Nokia", "Nortel", "Novell", "NSI", "Nurit", "ODS", "Oleg Khabarov", "Openlink", "OpenMarket", "Open-Xchange Inc.", "Optivision", "Oracle", "Osicom", "OTRS Inc.", "Overland Storage", "OvisLink Canada Inc.", "Packard Bell", "Packeteer", "Panasonic", "Pandatel", "Parallels", "Parrot", "Patton", "PBX", "phpLiteAdmin", "phpMyAdmin", "PHPReactor", "phpTest", "Pikatel", "Pirelli", "Pivotal Software, Inc.", "PlainTree", "PLANET Technology Corp.", "PokerTracker Software", "Pollsafe", "Polycom", "PostgreSQL", "Powerchute", "POWERLOGIC", "Prestige", "Prime", "PrimeBase", "Promise Technology, Inc.", "Proxicast", "Proxim", "PRTG", "QDI", "Q-Tec", "QualiTeam", "Quantex", "Quest Software", "Questra Corporation", "Radvision", "Raidzone", "Rainbow", "Rainer Wichmann", "Ramp Networks", "RapidStream", "Raritan", "Raritan Inc.", "RayTalk", "RCA", "Red Hat, Inc", "Redcreek Communications", "Remedy", "remote-exploit", "Research", "Research Machines", "Resumix", "Ricoh", "Rizen", "RM", "RNN", "Rodopi", "rPath", "RSA", "Saba", "Safecom", "Samba", "Sambar Technologies", "Samsung", "Samuel Abels", "SAP", "Schneider Electric", "Seagull Scientific", "Seclore", "Securicor3NET", "Semaphore", "Seyeon Technology Co., Ltd", "Shiva", "Shuttle", "Siemens", "Siemens Corp", "Sierra Wireless", "Silex Technology", "Silicon Graphics", "Site Interactive", "Sitecom", "Sitecore Corporation", "Skybox Security", "SMA America", "SMC", "Smith & Bentzen", "Snap Appliance", "Snom", "Software AG", "SolarWinds", "Sonicwall", "Sony", "Sony Ericsson", "Sourcefire", "Sovereign Hill", "Spider Systems", "Splunk", "Ssangyoung", "Stan Ozier", "Sun", "Super Micro Computer, Inc.", "SuperMicro", "Surecom", "Sweex", "Sybase", "Symantec", "Symbol Technologies, Inc", "Synology Inc", "SysKonnect", "Tandberg", "Tasman", "Tegile", "Telappliant", "Telebit", "Telelec", "Teletronics", "Telewell", "Telus", "Terayon", "test", "TexBox", "TextPortal", "Thecus Tech", "TIBCO", "Tim Schaab", "TimeTools", "Tiny", "Tinys", "TMC", "TopLayer", "Toshiba", "TOTOLINK", "Trend Micro", "Trintech", "Triumph-Adler", "Tumbleweed", "TYPO3", "Typo3 Association", "U.S. Robotics", "Unex", "Unidesk", "Unify", "United Technologies Corporation", "UNIX", "Unknown", "USRobotics", "UT Lexar", "UTStarcom", "VBrick Systems", "Verifone", "Veritas", "Verity", "Verizon", "vertex", "Vextrec Technology", "VieNuke", "Vina Technologies", "Virtual Programming", "Visa VAP", "Vobis", "VoiceGenie Technologies", "VoiceObjects Germany", "Vonage", "VPASP", "Wanco, Inc.", "WatchGuard", "Web Wiz", "Webmin", "Webramp", "Westell", "Wim Bervoets", "Wireless, Inc.", "WWWBoard", "Xavi", "Xerox", "Xinit Systems Ltd.", "X-Micro", "Xylan", "Xyplex", "Yakumo", "Yuxin", "Zcomax", "Zebra Technologies", "Zenith", "ZEOS", "Zeus", "Zoom", "Zyxel" ]
		self.website = "https://cirt.net/passwords?criteria={search}"

	def help(self):
		Logger.printMessage(message=ht.getFunctionsNamesFromModule('ht_router'), debug_module=True)

	def getDefaultLogin(self, routerBrand='cisco'):
		formatedBrand = urllib.parse.quote(routerBrand)
		url = self.website.format(search=formatedBrand)
		response = requests.get( url )
		soup = BeautifulSoup(response.content)
		finalResponse = []

		for links in soup.find_all('table'):
			rows = links.find_all('tr')

			user = rows[1].find_all('td')[1].text
			if user == '(none)':
				user = ''

			password = rows[2].find_all('td')[1].text
			if password == '(none)':
				password = ''

			if not (user, password) in finalResponse:
				finalResponse.append( (user, password) )

		return finalResponse

	def getBrands(self):
		return self.brands