"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Java Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-java
 */
class PDKPipelineJavaProject extends awscdk_1.AwsCdkJavaApp {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
            mainClass: options.mainClass !== "org.acme.MyApp"
                ? options.mainClass
                : 'software.aws.Pipeline -Dexec.classpathScope="test"',
        });
        this.addDependency("software.aws.awsprototypingsdk/aws-prototyping-sdk@^0");
        this.addDependency("io.github.cdklabs/cdknag@^2");
        this.testTask.exec("mvn test");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-api@5.7.0");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-engine@5.7.0");
        const mainPackage = this.mainClass
            .split(" ")[0]
            .split(".")
            .slice(0, -1)
            .join(".");
        new projen_1.SampleDir(this, path.join("src", "main", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "main", "java", "software", "aws"),
        });
        new projen_1.SampleDir(this, path.join("src", "test", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "test", "java", "software", "aws"),
        });
    }
}
exports.PDKPipelineJavaProject = PDKPipelineJavaProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineJavaProject[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipelineJavaProject", version: "0.5.2" };
//# sourceMappingURL=data:application/json;base64,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