# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.149.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.platform_appearance import PlatformAppearance
from empire_platform_api_public_client.models.user_preferences_general_notifications import UserPreferencesGeneralNotifications
from empire_platform_api_public_client.models.user_preferences_subscription_notifications import UserPreferencesSubscriptionNotifications

class UserPreferences(BaseModel):
    """
    UserPreferences
    """
    general_notifications: UserPreferencesGeneralNotifications = Field(..., alias="generalNotifications")
    subscription_notifications: UserPreferencesSubscriptionNotifications = Field(..., alias="subscriptionNotifications")
    appearance: PlatformAppearance = Field(...)
    __properties = ["generalNotifications", "subscriptionNotifications", "appearance"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserPreferences:
        """Create an instance of UserPreferences from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of general_notifications
        if self.general_notifications:
            _dict['generalNotifications'] = self.general_notifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subscription_notifications
        if self.subscription_notifications:
            _dict['subscriptionNotifications'] = self.subscription_notifications.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserPreferences:
        """Create an instance of UserPreferences from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserPreferences.parse_obj(obj)

        _obj = UserPreferences.parse_obj({
            "general_notifications": UserPreferencesGeneralNotifications.from_dict(obj.get("generalNotifications")) if obj.get("generalNotifications") is not None else None,
            "subscription_notifications": UserPreferencesSubscriptionNotifications.from_dict(obj.get("subscriptionNotifications")) if obj.get("subscriptionNotifications") is not None else None,
            "appearance": obj.get("appearance")
        })
        return _obj

