# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.149.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.timescale_nomination_status import TimescaleNominationStatus

class TimescaleNominationsMtusInnerCurrentNomination(BaseModel):
    """
    Optional field for storing Nomination status and value (if any nomination has been made already)  * `curtailedOrCappedOrFlooredValue` - Only sent when the current nomination is in CAPPED, FLOORED or CURTAILED status 
    """
    status: TimescaleNominationStatus = Field(...)
    value: StrictInt = Field(..., description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    curtailed_or_capped_or_floored_value: Optional[StrictInt] = Field(None, alias="curtailedOrCappedOrFlooredValue", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["status", "value", "curtailedOrCappedOrFlooredValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimescaleNominationsMtusInnerCurrentNomination:
        """Create an instance of TimescaleNominationsMtusInnerCurrentNomination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimescaleNominationsMtusInnerCurrentNomination:
        """Create an instance of TimescaleNominationsMtusInnerCurrentNomination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimescaleNominationsMtusInnerCurrentNomination.parse_obj(obj)

        _obj = TimescaleNominationsMtusInnerCurrentNomination.parse_obj({
            "status": obj.get("status"),
            "value": obj.get("value"),
            "curtailed_or_capped_or_floored_value": obj.get("curtailedOrCappedOrFlooredValue")
        })
        return _obj

