# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.149.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.mtu_period import MtuPeriod
from empire_platform_api_public_client.models.source_auction_result import SourceAuctionResult

class SourceAuction(BaseModel):
    """
    SourceAuction
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId", description="Generated display identifier")
    name: StrictStr = Field(..., description="Human readable name")
    product_type: AuctionProductType = Field(..., alias="productType")
    direction: BorderDirection = Field(...)
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    results: SourceAuctionResult = Field(...)
    __properties = ["id", "displayId", "name", "productType", "direction", "deliveryPeriod", "results"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SourceAuction:
        """Create an instance of SourceAuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of results
        if self.results:
            _dict['results'] = self.results.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SourceAuction:
        """Create an instance of SourceAuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SourceAuction.parse_obj(obj)

        _obj = SourceAuction.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "name": obj.get("name"),
            "product_type": obj.get("productType"),
            "direction": obj.get("direction"),
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "results": SourceAuctionResult.from_dict(obj.get("results")) if obj.get("results") is not None else None
        })
        return _obj

