# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.149.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Union
from pydantic import BaseModel, Field, StrictInt, confloat, conint

class DayAheadOrIntraDayAuctionResultsMtu(BaseModel):
    """
    * `requestedCapacity` - Sum of ALL bids for the given MTU in kilowatts * `allocatedTrs` - The SUM AC for the given MTU for the Auction in kilowatts * `marginalPrice` - Calculated marginal price for the MTU (lowest successful or partially successful bid price) * `participantCount` - Number of Participants submitting bids for the given MTU * `successfulParticipantCount` - Number of Participants that have received AC for the given MTU * `bidCount` - Number of bids received for the given MTU 
    """
    mtu: datetime = Field(..., description="The first moment (inclusive) of an MTU period  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute MTU start point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format - only with `XX:00:00`, `XX:15:00`, `XX:30:00` and `XX:45:00` time parts are valid values (depending on MTU size) ")
    requested_capacity: StrictInt = Field(..., alias="requestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    allocated_trs: StrictInt = Field(..., alias="allocatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    marginal_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="marginalPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    participant_count: conint(strict=True, ge=0) = Field(..., alias="participantCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    successful_participant_count: conint(strict=True, ge=0) = Field(..., alias="successfulParticipantCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    bid_count: conint(strict=True, ge=0) = Field(..., alias="bidCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    __properties = ["mtu", "requestedCapacity", "allocatedTrs", "marginalPrice", "participantCount", "successfulParticipantCount", "bidCount"]

    @validator('mtu')
    def mtu_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$", value):
            raise ValueError(r"must validate the regular expression /^.*T.*:(00|15|30|45):00(\.0+)?(Z|\+.*)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DayAheadOrIntraDayAuctionResultsMtu:
        """Create an instance of DayAheadOrIntraDayAuctionResultsMtu from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DayAheadOrIntraDayAuctionResultsMtu:
        """Create an instance of DayAheadOrIntraDayAuctionResultsMtu from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DayAheadOrIntraDayAuctionResultsMtu.parse_obj(obj)

        _obj = DayAheadOrIntraDayAuctionResultsMtu.parse_obj({
            "mtu": obj.get("mtu"),
            "requested_capacity": obj.get("requestedCapacity"),
            "allocated_trs": obj.get("allocatedTrs"),
            "marginal_price": obj.get("marginalPrice"),
            "participant_count": obj.get("participantCount"),
            "successful_participant_count": obj.get("successfulParticipantCount"),
            "bid_count": obj.get("bidCount")
        })
        return _obj

