# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.149.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Union
from pydantic import BaseModel, Field, confloat, conint, conlist
from empire_platform_api_public_client.models.public_long_term_auction_results_allocated_capacity_inner import PublicLongTermAuctionResultsAllocatedCapacityInner
from empire_platform_api_public_client.models.public_long_term_auction_results_bids_inner import PublicLongTermAuctionResultsBidsInner

class PublicLongTermAuctionResults(BaseModel):
    """
    PublicLongTermAuctionResults
    """
    bids: conlist(PublicLongTermAuctionResultsBidsInner) = Field(...)
    allocated_capacity: conlist(PublicLongTermAuctionResultsAllocatedCapacityInner) = Field(..., alias="allocatedCapacity")
    marginal_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="marginalPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["bids", "allocatedCapacity", "marginalPrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PublicLongTermAuctionResults:
        """Create an instance of PublicLongTermAuctionResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bids (list)
        _items = []
        if self.bids:
            for _item in self.bids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bids'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in allocated_capacity (list)
        _items = []
        if self.allocated_capacity:
            for _item in self.allocated_capacity:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allocatedCapacity'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PublicLongTermAuctionResults:
        """Create an instance of PublicLongTermAuctionResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PublicLongTermAuctionResults.parse_obj(obj)

        _obj = PublicLongTermAuctionResults.parse_obj({
            "bids": [PublicLongTermAuctionResultsBidsInner.from_dict(_item) for _item in obj.get("bids")] if obj.get("bids") is not None else None,
            "allocated_capacity": [PublicLongTermAuctionResultsAllocatedCapacityInner.from_dict(_item) for _item in obj.get("allocatedCapacity")] if obj.get("allocatedCapacity") is not None else None,
            "marginal_price": obj.get("marginalPrice")
        })
        return _obj

